/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 *
 * (C) 2005-2006, JBoss Inc.
 */
package org.jboss.soa.esb.actions.cbr;

import org.jboss.soa.esb.services.routing.MessageRouterException;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.util.XPathNamespaceContext;
import org.jboss.soa.esb.ConfigurationException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.apache.taglibs.bsf.expression;

import javax.xml.xpath.*;
import java.util.*;
import java.util.regex.Pattern;
import java.io.*;

/**
 * Regex Content Based Router implementation.
 *
 * @author <a href="mailto:tom.fennelly@jboss.com">tom.fennelly@jboss.com</a>
 */
public class RegexRouter extends AbstractPropertyRulesRouter {

    public Map<String, RoutingRule> buildRoutingMap(Properties rules) throws MessageRouterException {
        Map<String, RoutingRule> routingMap = new HashMap<String, RoutingRule>();

        Set<Map.Entry<Object, Object>> ruleSet = rules.entrySet();
        for(Map.Entry<Object, Object> rule : ruleSet) {
            String destinationName = (String) rule.getKey();
            String expression = (String) rule.getValue();

            routingMap.put(destinationName, new RegexRoutingRule(Pattern.compile(expression, Pattern.DOTALL)));
        }

        return routingMap;
    }

    private class RegexRoutingRule implements RoutingRule {

        private Pattern regexExpression;

        private RegexRoutingRule(Pattern regexExpression) {
            this.regexExpression = regexExpression;
        }

        public boolean evaluate(Object objectToTest) throws MessageRouterException {
            if(objectToTest instanceof CharSequence) {
                return regexExpression.matcher((CharSequence) objectToTest).matches();
            } else {
                logger.debug("Unsupported Regex evaluation type '" + objectToTest.getClass().getName() + "'.  Only supports CharSequence types.");
            }

            return false;
        }
    }
}