/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.soa.esb.actions.routing;

import org.apache.log4j.Logger;
import org.jboss.remoting.Client;
import org.jboss.remoting.InvokerLocator;
import org.jboss.soa.esb.actions.AbstractActionPipelineProcessor;
import org.jboss.soa.esb.actions.ActionProcessingException;
import org.jboss.soa.esb.actions.ActionUtils;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.listeners.ListenerTagNames;
import org.jboss.soa.esb.listeners.message.MessageDeliverException;
import org.jboss.soa.esb.message.body.content.BytesBody;
import org.jboss.soa.esb.message.MessagePayloadProxy;

/**
 * HttpRouter Action Processor. This ActionProcessor will forward the message to an url for further processing.
 * If the routeUrl property is not set a default url will be used.
 *
 * <p/> Sample Action Configuration:
 *
 * <pre>
 *    &lt;Action class=&quot;org.jboss.soa.esb.actions.routing.HttpRouter&quot;&gt;
 *    	&lt;property name=&quot;routeUrl&quot; value=&quot;http://localhost:8888&quot;&lt;/property&gt;
 *    &lt;/Action&gt;
 * </pre>
 *
 *
 *
 * @author <a href="mailto:johan.kumps@telenet.be">Johan Kumps</a>
 * @deprecated {@link org.jboss.soa.esb.actions.routing.http.HttpRouter} can provide the same functionality and more.
 */
@Deprecated
public class HttpRouter extends AbstractActionPipelineProcessor {

	/* The logger for this class */
	private static Logger logger = Logger.getLogger(HttpRouter.class);

	/* The url to route the message to */
	private String urlToRouteTo = null;

	/*
	 * The url to route the message to if the url was not set in the
	 * configuration
	 */
	private static final String DEFAULT_URL_TO_ROUTE_TO = "http://localhost:5400";
    private MessagePayloadProxy payloadProxy;

    /**
	 * Constructing a HttpRouter instance
	 *
	 * @param configTree
	 *            the configuration to use in this HttpRouter instance
	 */
	public HttpRouter(ConfigTree configTree) {
                urlToRouteTo = obtainAttribute(configTree,
                    ListenerTagNames.HTTP_ROUTER_ROUTE_URL,
                    DEFAULT_URL_TO_ROUTE_TO);
        payloadProxy = new MessagePayloadProxy(configTree,
                                               new String[] {BytesBody.BYTES_LOCATION, ActionUtils.POST_ACTION_DATA},
                                               new String[] {ActionUtils.POST_ACTION_DATA});
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see org.jboss.soa.esb.actions.ActionProcessor#process(java.lang.Object)
	 */
	public org.jboss.soa.esb.message.Message process(
			org.jboss.soa.esb.message.Message message)
			throws ActionProcessingException {

        Object oCurr;

        try {
            oCurr = payloadProxy.getPayload(message);
        } catch (MessageDeliverException e) {
            throw new ActionProcessingException(e);
        }

        if (logger.isInfoEnabled()) {
			logger
					.info("HttpRouter currently routing message " + message
							+ " with payload <<" + oCurr + ">> to "
							+ this.urlToRouteTo);
		}

		try {
			InvokerLocator locator = new InvokerLocator(this.urlToRouteTo);

			Client remotingClient = new Client(locator);
                        remotingClient.connect();
                        try
                        {
                            remotingClient.invoke(oCurr, null);
                            return null;
                        }
                        finally
                        {
                            remotingClient.disconnect() ;
                        }
		} catch (Throwable e) {
			String errorMessage = "Exception while sending message [" + oCurr
					+ "] to destination [" + this.urlToRouteTo + "].";
			logger.error(errorMessage, e);
			throw new ActionProcessingException(errorMessage, e);
		}
	}

	/**
	 * Method obtaining an attribute from the configuration tree
	 *
	 * @param configTree
	 *            the configuration to use
	 * @param p_sAtt
	 *            the name of the attribute to get
	 * @param p_sDefault
	 *            the default value for the attribute if not set
	 * @return the value of the attribute or the default one is not set in
	 *         configuration tree
	 */
	private String obtainAttribute(final ConfigTree configTree, String p_sAtt, String p_sDefault) {
		String sVal = configTree.getAttribute(p_sAtt);
		return (null != sVal) ? sVal : p_sDefault;
	}
}
