/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.soa.esb.helpers.persist;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.sql.DataSource;

import org.apache.log4j.Logger;

public class JdbcCleanConn
{
	private DataSource m_oDS = null;

	private Connection m_conn = null;
	
	private boolean transactional = false;

	protected List<PreparedStatement> m_olPrepSt = new ArrayList<PreparedStatement>();

	protected Logger m_oLogger;

	public JdbcCleanConn(DataSource p_oDS)
	{
		this(p_oDS, false);
	}
	
	public JdbcCleanConn(DataSource p_oDS, boolean transactional)
	{
		m_oDS = p_oDS;
		m_oLogger = Logger.getLogger(this.getClass());
		this.transactional = transactional;
	}
	
	public void commit() throws SQLException
	{
		if ((null != m_conn) && (!transactional))
		{
			m_conn.commit();
		}
		else
			throw new SQLException("Connection is null!");
	}

	public void rollback() throws SQLException
	{
		if ((null != m_conn) && (!transactional))
		{
			m_conn.rollback();
		} else {
			throw new SQLException("Connection is null");
		}
	}

	public List<PreparedStatement> getStatements() {
		return m_olPrepSt;
	}
	
	public void release()
	{
		if (null != m_conn)
		{
			if (!transactional)
			{
				try
				{
					m_conn.rollback();
				}
				catch (Exception eRoll)
				{
				}
			}

			for (PreparedStatement PS : m_olPrepSt)
			{
				try
				{
					PS.close();
				}
				catch (Exception e)
				{
				}
			}
			try
			{
				m_conn.close();
			}
			catch (Exception e1)
			{
			}
		}
		else
			m_oLogger.debug("Connection is null.");
		
		m_olPrepSt.clear();
		m_conn = null;
	} // __________________________________

	public PreparedStatement prepareStatement(String p_sSt, int p_i1, int p_i2)
			throws SQLException
	{
		if (null == m_conn)
		{
			connect();
			
			if (m_conn == null)
				throw new SQLException("Connection is null!");
		}
		PreparedStatement PS = m_conn.prepareStatement(p_sSt, p_i1, p_i2);
		m_olPrepSt.add(PS);
		return PS;
	} // __________________________________

	public PreparedStatement prepareStatement(String p_sSt) throws SQLException
	{
		if (null == m_conn)
		{
			connect();
			
			if (m_conn == null)
				throw new SQLException("Connection is null!");
		}

		PreparedStatement PS = m_conn.prepareStatement(p_sSt);
		m_olPrepSt.add(PS);
		return PS;
	} // __________________________________

	public ResultSet execQueryWait(PreparedStatement p_PS, int p_iQtry)
			throws SQLException
	{		
		if (null == m_conn)
		{
			connect();
			
			if (m_conn == null)
				throw new SQLException("Connection is null!");
		}

		if (p_PS == null)
			throw new SQLException("Null PreparedStatement!");
		
		SQLException eRet = null;
		int iQtry = (p_iQtry < 1) ? 1 : (p_iQtry < 50) ? p_iQtry : 50;
		for (int i1 = 0; i1 < iQtry; i1++)
		{
			try
			{
				return p_PS.executeQuery();
			}
			catch (SQLException e)
			{
				if (null == eRet)
					eRet = e;
				
				try {
					Thread.sleep(100 + (long)(100 * Math.random()));
				} catch (InterruptedException ex) {
					m_oLogger.debug("Thread interrupted.", ex);
				}
				
				release();
				m_conn = null;
				
			}
		}
		m_oLogger.debug("execQueryWait() FAILED", eRet);
		throw eRet;
	} // __________________________________

	public int execUpdWait(PreparedStatement p_PS, int p_iQtry)
			throws SQLException
	{
		if (null == m_conn)
		{
			connect();
			
			if (m_conn == null)
				throw new SQLException("Connection is null!");
		}

		if (p_PS == null)
			throw new SQLException("Null PreparedStatement!");
		
		SQLException eRet = null;
		int iQtry = (p_iQtry < 1) ? 1 : (p_iQtry < 50) ? p_iQtry : 50;
		for (int i1 = 0; i1 < iQtry; i1++)
		{
			try
			{
				return p_PS.executeUpdate();
			}
			catch (SQLException e)
			{
				if (null == eRet)
					eRet = e;
				
				try
				{
					Thread.sleep(100 + (long)(100 * Math.random()));
				}
				catch (InterruptedException ex)
				{
					m_oLogger.debug("Thread interrupted.", ex);
				}
				
				release();
				m_conn = null;

			}
		}
		m_oLogger.debug("execUpdWait() FAILED", eRet);
		throw eRet;
	} // __________________________________

	private void connect() throws SQLException
	{
		if (m_conn != null)
		{
			return;
		}

		if (m_oDS == null)
			throw new SQLException("DataSource is null!");
		
		SQLException eRet = null;
		for (int i1 = 0; i1 < 5; i1++)
		{
			try
			{
				m_conn = m_oDS.getConnection();
				eRet = null;
				break;
			}
			catch (SQLException e)
			{
				if (null == eRet)
					eRet = e;

				// TODO magic number!!

				try
				{
					Thread.sleep(2000 + (long)(100 * Math.random()));
				}
				catch (InterruptedException ex)
				{
					m_oLogger.debug("Thread interrupted.", ex);
				}
			}
		}

		if (eRet != null)
		{
			m_oLogger.debug("connect() FAILED", eRet);
			throw eRet;
		}

		if (m_conn == null)
		{
			throw new RuntimeException("connect() FAILED: no connection");
		}

		if (!transactional)
		{
			m_conn.setAutoCommit(false);
			m_conn.setTransactionIsolation(Connection.TRANSACTION_SERIALIZABLE);
		}

		m_olPrepSt.clear();

	} // __________________________________

} // ____________________________________________________________________________
