/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 *
 * (C) 2005-2006, JBoss Inc.
 */
package org.jboss.soa.esb.http;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.jboss.internal.soa.esb.assertion.AssertArgument;
import org.jboss.soa.esb.message.Message;

/**
 * HTTP Request Information.
 * @author <a href="mailto:tom.fennelly@jboss.com">tom.fennelly@jboss.com</a>
 */
public class HttpRequest implements Serializable {

    /** Request information key in esb message properties */
    private static final String REQUEST_KEY = HttpRequest.class.getName() + "#request";

    private String authType;
    private String characterEncoding;
    private String contentType;
    private String contextPath;
    private String localAddr;
    private String localName;
    private String method;
    private String pathInfo;
    private String protocol;
    private String queryString;
    private String remoteAddr;
    private String remoteHost;
    private String remoteUser;
    private int contentLength;
    private String requestSessionId;
    private String requestURI;
    private String scheme;
    private String serverName;
    private String requestPath;
    private List<String> pathInfoTokens = new ArrayList<String>();
    private Map<String, String[]> queryParams = new HashMap<String, String[]>();
    private List<HttpHeader> headers = new ArrayList<HttpHeader>();

    public String getAuthType() {
        return authType;
    }

    public void setAuthType(String authType) {
        this.authType = authType;
    }

    public String getCharacterEncoding() {
        return characterEncoding;
    }

    public void setCharacterEncoding(String characterEncoding) {
        this.characterEncoding = characterEncoding;
    }

    public String getContentType() {
        return contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getContextPath() {
        return contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public String getLocalAddr() {
        return localAddr;
    }

    public void setLocalAddr(String localAddr) {
        this.localAddr = localAddr;
    }

    public String getLocalName() {
        return localName;
    }

    public void setLocalName(String localName) {
        this.localName = localName;
    }

    public String getMethod() {
        return method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getPathInfo() {
        return pathInfo;
    }

    public void setPathInfo(String pathInfo) {
        this.pathInfo = pathInfo;
    }

    public String getProtocol() {
        return protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getQueryString() {
        return queryString;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public String getRemoteAddr() {
        return remoteAddr;
    }

    public void setRemoteAddr(String remoteAddr) {
        this.remoteAddr = remoteAddr;
    }

    public String getRemoteHost() {
        return remoteHost;
    }

    public void setRemoteHost(String remoteHost) {
        this.remoteHost = remoteHost;
    }

    public String getRemoteUser() {
        return remoteUser;
    }

    public void setRemoteUser(String remoteUser) {
        this.remoteUser = remoteUser;
    }

    public int getContentLength() {
        return contentLength;
    }

    public void setContentLength(int contentLength) {
        this.contentLength = contentLength;
    }

    public String getRequestSessionId() {
        return requestSessionId;
    }

    public void setRequestSessionId(String requestSessionId) {
        this.requestSessionId = requestSessionId;
    }

    public String getRequestURI() {
        return requestURI;
    }

    public void setRequestURI(String requestURI) {
        this.requestURI = requestURI;
    }

    public String getScheme() {
        return scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public String getServerName() {
        return serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getRequestPath() {
        return requestPath;
    }

    public void setRequestPath(String requestPath) {
        this.requestPath = requestPath;
    }

    public List<String> getPathInfoTokens() {
        return pathInfoTokens;
    }

    public Map<String, String[]> getQueryParams() {
        return queryParams;
    }

    public List<HttpHeader> getHeaders() {
        return headers;
    }
    
    public HttpHeader getHeader(String headerName) {
    	for (HttpHeader header : headers) {
    		if (header.getName().equalsIgnoreCase(headerName)) {
    			return header;
    		}
    	}
    	return null;
    }
    
    public String getHeaderValue(String headerName) {
    	HttpHeader header = getHeader(headerName);
    	return (header != null) ? header.getValue() : null;
    }

    public static HttpRequest getRequest(Message message) {
        AssertArgument.isNotNull(message, "message");
        return (HttpRequest) message.getProperties().getProperty(HttpRequest.REQUEST_KEY);
    }

    public void setRequest(Message message) {
        AssertArgument.isNotNull(message, "message");
        message.getProperties().setProperty(HttpRequest.REQUEST_KEY, this);
    }
}
