/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated 
 * by the @authors tag. All rights reserved. 
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors. 
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
 * MA  02110-1301, USA.
 * 
 * (C) 2005-2006,
 * @author JBoss Inc.
 */

package org.jboss.soa.esb.listeners.config.model;

/**
 * Exception representing errors during parsing of the model.
 * 
 * <a href='mailto:Kevin.Conner@jboss.com>Kevin Conner</a>
 */
public class ModelException extends Exception
{
    /**
     * The serial version UID for this class.
     */
    private static final long serialVersionUID = 6108565070668277643L;

    /**
     * Default constructor for the exception
     */
    public ModelException()
    {
    }

    /**
     * Create an exception with a specified message.
     * @param message The message associated with this exception.
     */
    public ModelException(final String message)
    {
        super(message) ;
    }

    /**
     * Create an exception with a specified cause.
     * @param cause The cause associated with this exception.
     */
    public ModelException(final Throwable cause)
    {
        super(cause) ;
    }

    /**
     * Create an exception with a specified message and cause.
     * @param message The message associated with this exception.
     * @param cause The cause associated with this exception.
     */
    public ModelException(final String message, final Throwable cause)
    {
        super(message, cause) ;
    }

}
