/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 *
 * (C) 2005-2006, JBoss Inc.
 */
package org.jboss.internal.soa.esb.webservice;


import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.List;

import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.wsdl.PortType;
import javax.wsdl.Types;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.factory.WSDLFactory;
import javax.xml.namespace.QName;

import junit.framework.TestCase;

import org.jboss.internal.soa.esb.util.StreamUtils;
import org.jboss.soa.esb.listeners.config.Generator;
import org.jboss.soa.esb.listeners.config.WebserviceInfo;
import org.jboss.soa.esb.util.ClassUtil;
import org.xml.sax.InputSource;

public class ESBContractGeneratorUnitTest extends TestCase {
    public void testRequestResponseFault() throws Exception {
        executeTest("jbossesb_config_06.xml") ;
    }
    
    public void testRequestResponseFault110() throws Exception {
        executeTest("jbossesb_config_06.110.xml") ;
    }
    
    public void testRequestResponseFault120() throws Exception {
        executeTest("jbossesb_config_06.120.xml") ;
    }
    
    public void testRequestResponse() throws Exception {
        executeTest("jbossesb_config_07.xml") ;
    }
    
    public void testRequestResponse110() throws Exception {
        executeTest("jbossesb_config_07.110.xml") ;
    }
    
    public void testRequestResponse120() throws Exception {
        executeTest("jbossesb_config_07.120.xml") ;
    }
    
    public void testRequest() throws Exception {
        executeTest("jbossesb_config_08.xml") ;
    }
    
    public void testRequest110() throws Exception {
        executeTest("jbossesb_config_08.110.xml") ;
    }
    
    public void testRequest120() throws Exception {
        executeTest("jbossesb_config_08.120.xml") ;
    }
    
    public void testDuplicateSchemas() throws Exception {
        Definition def = executeTest("jbossesb_duplicate_schemas.xml") ;
        Types types = def.getTypes();
        assertEquals(1, types.getExtensibilityElements().size());

        def = executeTest("jbossesb_duplicate_schemas2.xml") ;
        types = def.getTypes();
        assertEquals(2, types.getExtensibilityElements().size());
    }
    
    public void testWSAExtensions110() throws Exception {
        executeWSAExtensionsTest("jbossesb_config_09.110.xml") ;
    }

    public void testWSAExtensions120() throws Exception {
        executeWSAExtensionsTest("jbossesb_config_09.120.xml") ;
    }

    //@SuppressWarnings("unchecked")
    private void executeWSAExtensionsTest(final String resourceName) throws Exception {
        final String targetNamespace = "http://soa.jboss.org/FirstServiceESB" ;
        final String wsawNamespace = "http://www.w3.org/2006/05/addressing/wsdl" ;
        
        final Definition def = executeTest(resourceName) ;
        assertNotNull("Definition", def) ;
        
        final QName portName = new QName(targetNamespace, "SimpleListenerPortType") ;
        final PortType portType = def.getPortType(portName) ;
        assertNotNull("Port type", portType) ;
        
        final Operation operation = portType.getOperation("SimpleListenerOp", "SimpleListenerReq", "SimpleListenerRes") ;
        assertNotNull("Operation", operation) ;
        
        final QName actionQName = new QName(wsawNamespace, "Action") ;
        assertNotNull("Input action", operation.getInput().getExtensionAttribute(actionQName)) ;
        assertNotNull("Output action", operation.getOutput().getExtensionAttribute(actionQName)) ;
        
        final QName bindingName = new QName(targetNamespace, "SimpleListenerBinding") ;
        final Binding binding = def.getBinding(bindingName) ;
        assertNotNull("Binding", binding) ;
        
        final List<ExtensibilityElement> extensions = binding.getExtensibilityElements() ;
        boolean found = false ;
        for(ExtensibilityElement extension: extensions)
        {
            final QName type = extension.getElementType() ;
            if (wsawNamespace.equals(type.getNamespaceURI()))
            {
                assertEquals("Extension element local name", "UsingAddressing", type.getLocalPart()) ;
                assertTrue("Required element", extension.getRequired().booleanValue()) ;
                found = true ;
            }
        }
        assertTrue("Extension found", found) ;
    }

    private Definition executeTest(final String resourceName) throws Exception {
        final InputStream is = ClassUtil.getResourceAsStream(resourceName, getClass()) ;
        final byte[] configBytes = StreamUtils.readStream(is) ;
        ByteArrayOutputStream listenerXml = new ByteArrayOutputStream();
        ByteArrayOutputStream gatewayXml = new ByteArrayOutputStream();
        Generator generator = new Generator(new ByteArrayInputStream(configBytes), listenerXml, gatewayXml);
        generator.generate();
        List<WebserviceInfo> services = generator.getModel().getWebserviceServices();
        final WebserviceInfo service = services.get(0) ;
        final ESBServiceEndpointInfo endpointInfo = new ESBServiceEndpointInfo(service) ;
        String wsdl = ESBContractGenerator.generateWSDL(service, endpointInfo);
        java.io.StringReader strReader = new java.io.StringReader(wsdl);
        InputSource inputSource = new InputSource(strReader);
        Definition def = WSDLFactory.newInstance().newWSDLReader().readWSDL("file://tmp.wsdl", inputSource);
        assertNotNull("Failed to generate wsdl file" , def);

        return def;
    }

}
