/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.soa.esb.message.payload;

import java.util.Enumeration;

import junit.framework.TestCase;

import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.body.content.BytesBody;
import org.jboss.soa.esb.message.body.content.IncompatibleModeException;
import org.jboss.soa.esb.message.body.content.MapBody;
import org.jboss.soa.esb.message.body.content.ObjectBody;
import org.jboss.soa.esb.message.body.content.Payload;
import org.jboss.soa.esb.message.body.content.TextBody;
import org.jboss.soa.esb.message.format.MessageFactory;
import org.jboss.soa.esb.message.format.MessageType;

/**
 * Unit tests for the Payload class.
 * 
 * @author Mark Little
 */

public class PayloadUnitTest extends TestCase
{
	public void testMapMessage() throws Exception
	{
		Message msg = MessageFactory.getInstance().getMessage();

		assertEquals((msg != null), true);

		MapBody mapMessage = Payload.createMapBody(msg);

		assertEquals(msg.getBody() instanceof MapBody, true);
		
		mapMessage.setString("foo", "bar");
		mapMessage.setBoolean("hello", true);

		Enumeration<String> names = mapMessage.getMapNames();

		assertNotNull(names);

		assertEquals(mapMessage.getString("foo"), "bar");
		assertEquals(mapMessage.getBoolean("hello"), true);
	}

	public void testTextMessage() throws Exception
	{
		Message msg = MessageFactory.getInstance().getMessage(MessageType.JAVA_SERIALIZED);

		assertEquals((msg != null), true);

		TextBody textMessage = Payload.createTextBody(msg);

		textMessage.setText("hello world");

		assertEquals(textMessage.getText(), "hello world");
	}

	public void testObjectMessage() throws Exception
	{
		Message msg = MessageFactory.getInstance().getMessage();

		assertEquals((msg != null), true);

		ObjectBody objectMessage = Payload.createObjectBody(msg);;

		objectMessage.setObject("hello world");

		assertEquals(objectMessage.getObject(), "hello world");
	}

	public void testBytesMessage() throws Exception
	{
		Message msg = MessageFactory.getInstance().getMessage(MessageType.JAVA_SERIALIZED);

		assertEquals((msg != null), true);

		BytesBody mapMessage = Payload.createBytesBody(msg);

		try
		{
			mapMessage.readMode();
			
			fail();
		}
		catch (Exception ex)
		{
		}
		
		try
		{
			mapMessage.writeBoolean(true);

			fail();
		}
		catch (IncompatibleModeException ex)
		{
		}

		mapMessage.writeMode();

		mapMessage.writeInt(12345);
		mapMessage.writeUTFString("hello world");
		mapMessage.writeShort((short) 10);
		mapMessage.writeBoolean(true);

		mapMessage.flush();
		
		mapMessage.readMode();

		assertEquals(mapMessage.readInt(), 12345);
		assertEquals(mapMessage.readUTFString(), "hello world");
		assertEquals(mapMessage.readShort(), (short) 10);
		assertEquals(mapMessage.readBoolean(), true);
	}
}
