/*
* JBoss, Home of Professional Open Source
* Copyright 2006, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/

package org.jboss.internal.soa.esb.persistence.format.jcr;

import java.io.IOException;

import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

import org.apache.jackrabbit.core.TransientRepository;
import org.apache.log4j.Logger;
import org.jboss.soa.esb.common.Environment;
import org.jboss.soa.esb.common.ModulePropertyManager;
import org.jboss.soa.esb.common.tests.BaseTest;
import org.jboss.soa.esb.common.tests.MockDataSource;
import org.mockejb.jndi.MockContextFactory;

import com.arjuna.common.util.propertyservice.PropertyManager;

/**
 * Test for JCRConnectionManager - tests that we can get an instance, and
 * set and get a repository.   
 *
 * @author <a href="tcunning@redhat.com">Tom Cunningham</a>
 */
public class JCRConnectionManagerUnitTest extends BaseTest {
	private static final Logger logger = Logger.getLogger(JCRConnectionManagerUnitTest.class);
	
	protected void setUp() throws Exception {
		MockContextFactory.setAsInitial();
	}
	
	public void testConnectionManager () {
		JCRConnectionManager jcrm = JCRConnectionManager.getInstance();
		if (jcrm == null) {
			fail("The JCRConnectionManager getInstance method should not return null");
		}
		
		try {
			@SuppressWarnings("unused")
			Session sess = jcrm.newRepositorySession();
			fail("Should not be able to create new repository session with no user/pass");
		} catch (RepositoryException re) {
		}

		PropertyManager mpm = ModulePropertyManager.getPropertyManager(ModulePropertyManager.DBSTORE_MODULE);
		mpm.setProperty(Environment.MSG_STORE_JCR_USERNAME, "joe");
		mpm.setProperty(Environment.MSG_STORE_JCR_PASSWORD, "shmoe");
		mpm.setProperty(Environment.MSG_STORE_DB_DATASOURCE_NAME, "datasource");
		mpm.setProperty(Environment.MSG_STORE_JCR_JNDI_PATH, "path");
		PropertyManager core = ModulePropertyManager.getPropertyManager(ModulePropertyManager.CORE_MODULE);
		core.setProperty(Environment.JNDI_SERVER_CONTEXT_FACTORY, "org.mockejb.jndi.MockContextFactory");
		core.setProperty(Environment.JNDI_SERVER_PKG_PREFIX, "org.mockejb.jndi");
		Repository repository = null;
		try {
			repository = new TransientRepository();
		} catch (IOException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		}
		Context ctx;
		MockDataSource mds = new MockDataSource(this);
		try {
			ctx = new InitialContext();
			ctx.rebind("datasource", mds);
			ctx.rebind("path", repository);
		} catch (NamingException e) {
			fail(e.getMessage());
			logger.error("", e);
		}
				
		try {
			@SuppressWarnings("unused")
			Repository rep = jcrm.getRepository();
		} catch (RepositoryException re) {
			fail(re.getMessage());
			logger.error("", re);
		}
		
	}
}
