/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.esb.services.jbpm.integration.job;

import org.jbpm.job.Job;

/**
 * Job utility methods used by the commands.
 * @author Kevin Conner
 */
class JobUtil
{
    /**
     * Has the job been deleted?
     * @param job The job to test.
     * @return true if deleted, false otherwise.
     */
    static boolean isDeleted(final Job job)
    {
        /*
         * The jBPM code tests for null but lazy loading means
         * that a proxy is returned and that an exception will be
         * raised when accessed.  We test for both assumptions here,
         * just to be safe.
         */
        if (job != null)
        {
            try
            {
                job.getLockOwner() ;
                return false ;
            }
            catch (final Exception ex) {} // ignore
        }
        return true ;
    }
}
