package org.jboss.soa.esb.actions.soap;

import org.xml.sax.SAXException;

import java.util.Map;
import java.util.Properties;
import java.io.IOException;

/**
 * @author
 */
public interface SoapUIInvoker {
    String buildRequest(String wsdl, String operation, Map params, Properties httpClientProps, String smooksResource, String soapNs) throws IOException, UnsupportedOperationException, SAXException;
    
    String buildResponse(String wsdl, String operation, Map params, Properties httpClientProps, String smooksResource, String soapNs) throws IOException, UnsupportedOperationException, SAXException;
    
    String buildFault(String wsdl, String operation, String faultName, Map params, Properties httpClientProps, String smooksResource, String soapNs) throws IOException, UnsupportedOperationException, SAXException;

    String getEndpoint(String wsdl, Properties httpClientProps) throws IOException;
}
