/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.esb.registry.rmi;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.apache.xerces.parsers.DOMParser;
import org.jboss.soa.esb.http.mock.SOAPProcessorHttpServletRequest;
import org.jboss.soa.esb.http.mock.SOAPProcessorHttpServletResponse;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/**
* @author <a href="mailto:tcunning@redhat.com">Tom Cunningham</a>
*/
public class PublishService extends UnicastRemoteObject
	implements Publish
{
	private static final String SOAP_OPEN_TAGS = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>"
		+ "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\">"
		+ "<soap:Body>";
		
	private static final String SOAP_CLOSE_TAGS = "</soap:Body>"
		+ "</soap:Envelope>";
	
	private static final long serialVersionUID = 1L;
	
	private RegistrationService rs = null;
		
	public RegistrationService getsetRegistrationService() {
		return rs;
	}

	public void setRegistrationService(RegistrationService rs) {
		this.rs = rs;
	}

	public PublishService() throws RemoteException {
		super();
	}

	private String convertElementToSOAPRequest (Element request) 
		throws TransformerConfigurationException, TransformerException {
		TransformerFactory tf = TransformerFactory.newInstance();
		Transformer trans = tf.newTransformer();
		StringWriter sw = new StringWriter();
		trans.transform(new DOMSource(request), new StreamResult(sw));
		return new String(SOAP_OPEN_TAGS
				+ sw.toString() 
				+ SOAP_CLOSE_TAGS);
	}

	private Node marshalResult(String result) throws SAXException, IOException {
		DOMParser parser = new DOMParser();
		InputStream is = new ByteArrayInputStream(result.getBytes());
		parser.parse(new InputSource(is));
		
		Document document = parser.getDocument();
		Element docelement = document.getDocumentElement();	
		Node bodyNode = docelement.getFirstChild();
		
		return bodyNode;
	}
	
	public Node publish(Element request) throws RemoteException {
		SOAPProcessorHttpServletRequest soaprequest = null;
		SOAPProcessorHttpServletResponse soapresponse = null;
		
		try {			
			String soaprequeststring = convertElementToSOAPRequest(request);
			
		    Map<String, List<String>> headers = new HashMap<String, List<String>>();
		    
			soaprequest = new SOAPProcessorHttpServletRequest("/", 
					soaprequeststring.getBytes(), headers);
			soapresponse = new SOAPProcessorHttpServletResponse();
			soaprequest.setAttribute("org.apache.catalina.core.DISPATCHER_TYPE", Integer.valueOf(2));
			
			rs.getServletConfig().getServletContext().getRequestDispatcher("/uddi/publishing").forward(soaprequest,soapresponse);
		} catch (Exception e) {
			e.printStackTrace();
		}
	
		Node node = null;
		try { 
			String content = new String(soapresponse.getContent());
			if ((content != null) && (!"".equals(content))) {
				node = marshalResult(content);
			}
		} catch (Exception e) {
			e.printStackTrace();
			throw new RemoteException("", e.fillInStackTrace());
		}
		return node;
	}
}
