/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.test.ws.jaxrpc.jbws801;

import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.Iterator;

import javax.xml.rpc.ServiceException;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.rpc.server.ServiceLifecycle;
import javax.xml.rpc.server.ServletEndpointContext;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.SOAPMessage;

public class LargeAttachmentImpl implements LargeAttachment, ServiceLifecycle
{
   private ServletEndpointContext context;

   public long sendLargeFile() throws RemoteException
   {
      long count = 0;
      SOAPMessage message = ((SOAPMessageContext) context.getMessageContext()).getMessage();
      try
      {
         byte[] buffer = new byte[1024];
         for (Iterator iter = message.getAttachments(); iter.hasNext(); )
         {
            AttachmentPart part = (AttachmentPart) iter.next();

            InputStream inputStream = null;
            try
            {
               inputStream = part.getDataHandler().getInputStream();
               int read = 0;
               do
               {
                  count += read;
                  read = inputStream.read(buffer);
               }
               while (read != -1);
            }
            finally
            {
               if (inputStream != null) inputStream.close();
            }
         }
      }
      catch (Exception e)
      {
         throw new RemoteException(e.getMessage());
      }

      System.out.println("[Size = " + count + "]");
      return count;
   }


   // ServiceLifecycle *******************************************************************************************

   public void init(Object context) throws ServiceException
   {
      this.context = (ServletEndpointContext)context;
   }

   public void destroy()
   {
      this.context = null;
   }
}
