/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.test.ws.jaxws.jbws1857.types;

import javax.xml.bind.JAXBElement;
import javax.xml.bind.annotation.XmlElementDecl;
import javax.xml.bind.annotation.XmlRegistry;
import javax.xml.namespace.QName;


/**
 * This object contains factory methods for each 
 * Java content interface and Java element interface 
 * generated in the org.jboss.test.ws.jaxws.jbws1857.types package. 
 * <p>An ObjectFactory allows you to programatically 
 * construct new instances of the Java representation 
 * for XML content. The Java representation of XML 
 * content can consist of schema derived interfaces 
 * and classes representing the binding of schema 
 * type definitions, element declarations and model 
 * groups.  Factory methods for each of these are 
 * provided in this class.
 * 
 */
@XmlRegistry
public class ObjectFactory {

    private final static QName _UpdateNatPersonResponse_QNAME = new QName("http://example.com", "updateNatPersonResponse");
    private final static QName _FetchNatPersonResponse_QNAME = new QName("http://example.com", "fetchNatPersonResponse");
    private final static QName _DeleteNatPerson_QNAME = new QName("http://example.com", "deleteNatPerson");
    private final static QName _InsertMandantUser_QNAME = new QName("http://example.com", "insertMandantUser");
    private final static QName _FetchGlaeubiger_QNAME = new QName("http://example.com", "fetchGlaeubiger");
    private final static QName _UpdateGlaeubiger_QNAME = new QName("http://example.com", "updateGlaeubiger");
    private final static QName _UpdateMandant_QNAME = new QName("http://example.com", "updateMandant");
    private final static QName _DeleteMandant_QNAME = new QName("http://example.com", "deleteMandant");
    private final static QName _DeleteMandantUser_QNAME = new QName("http://example.com", "deleteMandantUser");
    private final static QName _FetchGlaeubigerResponse_QNAME = new QName("http://example.com", "fetchGlaeubigerResponse");
    private final static QName _InsertMandant_QNAME = new QName("http://example.com", "insertMandant");
    private final static QName _UpdateMandantUserResponse_QNAME = new QName("http://example.com", "updateMandantUserResponse");
    private final static QName _UpdateUser_QNAME = new QName("http://example.com", "updateUser");
    private final static QName _InsertGlaeubiger_QNAME = new QName("http://example.com", "insertGlaeubiger");
    private final static QName _InsertUserResponse_QNAME = new QName("http://example.com", "insertUserResponse");
    private final static QName _UpdateUserResponse_QNAME = new QName("http://example.com", "updateUserResponse");
    private final static QName _DeleteUserResponse_QNAME = new QName("http://example.com", "deleteUserResponse");
    private final static QName _FetchMandantResponse_QNAME = new QName("http://example.com", "fetchMandantResponse");
    private final static QName _InsertMandantUserResponse_QNAME = new QName("http://example.com", "insertMandantUserResponse");
    private final static QName _UpdateNatPerson_QNAME = new QName("http://example.com", "updateNatPerson");
    private final static QName _DeleteGlaeubigerResponse_QNAME = new QName("http://example.com", "deleteGlaeubigerResponse");
    private final static QName _DeleteMandantUserResponse_QNAME = new QName("http://example.com", "deleteMandantUserResponse");
    private final static QName _UpdateMandantResponse_QNAME = new QName("http://example.com", "updateMandantResponse");
    private final static QName _FetchMandantUserResponse_QNAME = new QName("http://example.com", "fetchMandantUserResponse");
    private final static QName _DeleteUser_QNAME = new QName("http://example.com", "deleteUser");
    private final static QName _InsertNatPerson_QNAME = new QName("http://example.com", "insertNatPerson");
    private final static QName _UpdateGlaeubigerResponse_QNAME = new QName("http://example.com", "updateGlaeubigerResponse");
    private final static QName _FetchUserResponse_QNAME = new QName("http://example.com", "fetchUserResponse");
    private final static QName _DeleteNatPersonResponse_QNAME = new QName("http://example.com", "deleteNatPersonResponse");
    private final static QName _FetchNatPerson_QNAME = new QName("http://example.com", "fetchNatPerson");
    private final static QName _UpdateMandantUser_QNAME = new QName("http://example.com", "updateMandantUser");
    private final static QName _FetchMandantUser_QNAME = new QName("http://example.com", "fetchMandantUser");
    private final static QName _FetchMandant_QNAME = new QName("http://example.com", "fetchMandant");
    private final static QName _FetchUser_QNAME = new QName("http://example.com", "fetchUser");
    private final static QName _InsertGlaeubigerResponse_QNAME = new QName("http://example.com", "insertGlaeubigerResponse");
    private final static QName _InsertMandantResponse_QNAME = new QName("http://example.com", "insertMandantResponse");
    private final static QName _InsertUser_QNAME = new QName("http://example.com", "insertUser");
    private final static QName _DeleteGlaeubiger_QNAME = new QName("http://example.com", "deleteGlaeubiger");
    private final static QName _InsertNatPersonResponse_QNAME = new QName("http://example.com", "insertNatPersonResponse");
    private final static QName _DeleteMandantResponse_QNAME = new QName("http://example.com", "deleteMandantResponse");

    /**
     * Create a new ObjectFactory that can be used to create new instances of schema derived classes for package: org.jboss.test.ws.jaxws.jbws1857.types
     * 
     */
    public ObjectFactory() {
    }

    /**
     * Create an instance of {@link InsertNatPersonResponse }
     * 
     */
    public InsertNatPersonResponse createInsertNatPersonResponse() {
        return new InsertNatPersonResponse();
    }

    /**
     * Create an instance of {@link UpdateGlaeubiger }
     * 
     */
    public UpdateGlaeubiger createUpdateGlaeubiger() {
        return new UpdateGlaeubiger();
    }

    /**
     * Create an instance of {@link InsertMandantUser }
     * 
     */
    public InsertMandantUser createInsertMandantUser() {
        return new InsertMandantUser();
    }

    /**
     * Create an instance of {@link DeleteMandantUser }
     * 
     */
    public DeleteMandantUser createDeleteMandantUser() {
        return new DeleteMandantUser();
    }

    /**
     * Create an instance of {@link FetchNatPerson }
     * 
     */
    public FetchNatPerson createFetchNatPerson() {
        return new FetchNatPerson();
    }

    /**
     * Create an instance of {@link NatPersonResult }
     * 
     */
    public NatPersonResult createNatPersonResult() {
        return new NatPersonResult();
    }

    /**
     * Create an instance of {@link DeleteNatPerson }
     * 
     */
    public DeleteNatPerson createDeleteNatPerson() {
        return new DeleteNatPerson();
    }

    /**
     * Create an instance of {@link Glaeubiger }
     * 
     */
    public Glaeubiger createGlaeubiger() {
        return new Glaeubiger();
    }

    /**
     * Create an instance of {@link UserResult }
     * 
     */
    public UserResult createUserResult() {
        return new UserResult();
    }

    /**
     * Create an instance of {@link AusstellendeBehoerde }
     * 
     */
    public AusstellendeBehoerde createAusstellendeBehoerde() {
        return new AusstellendeBehoerde();
    }

    /**
     * Create an instance of {@link FetchMandantUserResponse }
     * 
     */
    public FetchMandantUserResponse createFetchMandantUserResponse() {
        return new FetchMandantUserResponse();
    }

    /**
     * Create an instance of {@link FetchMandantUser }
     * 
     */
    public FetchMandantUser createFetchMandantUser() {
        return new FetchMandantUser();
    }

    /**
     * Create an instance of {@link User }
     * 
     */
    public User createUser() {
        return new User();
    }

    /**
     * Create an instance of {@link InsertNatPerson }
     * 
     */
    public InsertNatPerson createInsertNatPerson() {
        return new InsertNatPerson();
    }

    /**
     * Create an instance of {@link DeleteNatPersonResponse }
     * 
     */
    public DeleteNatPersonResponse createDeleteNatPersonResponse() {
        return new DeleteNatPersonResponse();
    }

    /**
     * Create an instance of {@link MandantUserArrayResult }
     * 
     */
    public MandantUserArrayResult createMandantUserArrayResult() {
        return new MandantUserArrayResult();
    }

    /**
     * Create an instance of {@link UpdateMandantUserResponse }
     * 
     */
    public UpdateMandantUserResponse createUpdateMandantUserResponse() {
        return new UpdateMandantUserResponse();
    }

    /**
     * Create an instance of {@link UpdateMandantResponse }
     * 
     */
    public UpdateMandantResponse createUpdateMandantResponse() {
        return new UpdateMandantResponse();
    }

    /**
     * Create an instance of {@link InsertGlaeubiger }
     * 
     */
    public InsertGlaeubiger createInsertGlaeubiger() {
        return new InsertGlaeubiger();
    }

    /**
     * Create an instance of {@link DeleteGlaeubiger }
     * 
     */
    public DeleteGlaeubiger createDeleteGlaeubiger() {
        return new DeleteGlaeubiger();
    }

    /**
     * Create an instance of {@link HerkunftReferenz }
     * 
     */
    public HerkunftReferenz createHerkunftReferenz() {
        return new HerkunftReferenz();
    }

    /**
     * Create an instance of {@link GlaeubigerVerbindung }
     * 
     */
    public GlaeubigerVerbindung createGlaeubigerVerbindung() {
        return new GlaeubigerVerbindung();
    }

    /**
     * Create an instance of {@link FetchGlaeubigerResponse }
     * 
     */
    public FetchGlaeubigerResponse createFetchGlaeubigerResponse() {
        return new FetchGlaeubigerResponse();
    }

    /**
     * Create an instance of {@link FetchUserResponse }
     * 
     */
    public FetchUserResponse createFetchUserResponse() {
        return new FetchUserResponse();
    }

    /**
     * Create an instance of {@link Adresse }
     * 
     */
    public Adresse createAdresse() {
        return new Adresse();
    }

    /**
     * Create an instance of {@link MandantArrayResult }
     * 
     */
    public MandantArrayResult createMandantArrayResult() {
        return new MandantArrayResult();
    }

    /**
     * Create an instance of {@link InsertMandant }
     * 
     */
    public InsertMandant createInsertMandant() {
        return new InsertMandant();
    }

    /**
     * Create an instance of {@link MandantUserResult }
     * 
     */
    public MandantUserResult createMandantUserResult() {
        return new MandantUserResult();
    }

    /**
     * Create an instance of {@link UserArrayResult }
     * 
     */
    public UserArrayResult createUserArrayResult() {
        return new UserArrayResult();
    }

    /**
     * Create an instance of {@link MandantResult }
     * 
     */
    public MandantResult createMandantResult() {
        return new MandantResult();
    }

    /**
     * Create an instance of {@link DeleteMandantUserResponse }
     * 
     */
    public DeleteMandantUserResponse createDeleteMandantUserResponse() {
        return new DeleteMandantUserResponse();
    }

    /**
     * Create an instance of {@link DeleteMandantResponse }
     * 
     */
    public DeleteMandantResponse createDeleteMandantResponse() {
        return new DeleteMandantResponse();
    }

    /**
     * Create an instance of {@link FetchMandant }
     * 
     */
    public FetchMandant createFetchMandant() {
        return new FetchMandant();
    }

    /**
     * Create an instance of {@link FetchGlaeubiger }
     * 
     */
    public FetchGlaeubiger createFetchGlaeubiger() {
        return new FetchGlaeubiger();
    }

    /**
     * Create an instance of {@link UpdateNatPersonResponse }
     * 
     */
    public UpdateNatPersonResponse createUpdateNatPersonResponse() {
        return new UpdateNatPersonResponse();
    }

    /**
     * Create an instance of {@link GlaeubigerArrayResult }
     * 
     */
    public GlaeubigerArrayResult createGlaeubigerArrayResult() {
        return new GlaeubigerArrayResult();
    }

    /**
     * Create an instance of {@link GlaeubigerResult }
     * 
     */
    public GlaeubigerResult createGlaeubigerResult() {
        return new GlaeubigerResult();
    }

    /**
     * Create an instance of {@link MandantUser }
     * 
     */
    public MandantUser createMandantUser() {
        return new MandantUser();
    }

    /**
     * Create an instance of {@link FetchNatPersonResponse }
     * 
     */
    public FetchNatPersonResponse createFetchNatPersonResponse() {
        return new FetchNatPersonResponse();
    }

    /**
     * Create an instance of {@link DeleteUser }
     * 
     */
    public DeleteUser createDeleteUser() {
        return new DeleteUser();
    }

    /**
     * Create an instance of {@link NatuerlichePerson }
     * 
     */
    public NatuerlichePerson createNatuerlichePerson() {
        return new NatuerlichePerson();
    }

    /**
     * Create an instance of {@link Verlustschein }
     * 
     */
    public Verlustschein createVerlustschein() {
        return new Verlustschein();
    }

    /**
     * Create an instance of {@link UpdateMandantUser }
     * 
     */
    public UpdateMandantUser createUpdateMandantUser() {
        return new UpdateMandantUser();
    }

    /**
     * Create an instance of {@link DeleteMandant }
     * 
     */
    public DeleteMandant createDeleteMandant() {
        return new DeleteMandant();
    }

    /**
     * Create an instance of {@link InsertMandantUserResponse }
     * 
     */
    public InsertMandantUserResponse createInsertMandantUserResponse() {
        return new InsertMandantUserResponse();
    }

    /**
     * Create an instance of {@link GlaeubigerVertreter }
     * 
     */
    public GlaeubigerVertreter createGlaeubigerVertreter() {
        return new GlaeubigerVertreter();
    }

    /**
     * Create an instance of {@link InsertUserResponse }
     * 
     */
    public InsertUserResponse createInsertUserResponse() {
        return new InsertUserResponse();
    }

    /**
     * Create an instance of {@link Nationalitaet }
     * 
     */
    public Nationalitaet createNationalitaet() {
        return new Nationalitaet();
    }

    /**
     * Create an instance of {@link UpdateNatPerson }
     * 
     */
    public UpdateNatPerson createUpdateNatPerson() {
        return new UpdateNatPerson();
    }

    /**
     * Create an instance of {@link DeleteUserResponse }
     * 
     */
    public DeleteUserResponse createDeleteUserResponse() {
        return new DeleteUserResponse();
    }

    /**
     * Create an instance of {@link InsertUser }
     * 
     */
    public InsertUser createInsertUser() {
        return new InsertUser();
    }

    /**
     * Create an instance of {@link UpdateUserResponse }
     * 
     */
    public UpdateUserResponse createUpdateUserResponse() {
        return new UpdateUserResponse();
    }

    /**
     * Create an instance of {@link PersonAdresse }
     * 
     */
    public PersonAdresse createPersonAdresse() {
        return new PersonAdresse();
    }

    /**
     * Create an instance of {@link PersonInterface }
     * 
     */
    public PersonInterface createPersonInterface() {
        return new PersonInterface();
    }

    /**
     * Create an instance of {@link FetchUser }
     * 
     */
    public FetchUser createFetchUser() {
        return new FetchUser();
    }

    /**
     * Create an instance of {@link Mandant }
     * 
     */
    public Mandant createMandant() {
        return new Mandant();
    }

    /**
     * Create an instance of {@link FetchMandantResponse }
     * 
     */
    public FetchMandantResponse createFetchMandantResponse() {
        return new FetchMandantResponse();
    }

    /**
     * Create an instance of {@link UpdateMandant }
     * 
     */
    public UpdateMandant createUpdateMandant() {
        return new UpdateMandant();
    }

    /**
     * Create an instance of {@link InsertMandantResponse }
     * 
     */
    public InsertMandantResponse createInsertMandantResponse() {
        return new InsertMandantResponse();
    }

    /**
     * Create an instance of {@link DeleteGlaeubigerResponse }
     * 
     */
    public DeleteGlaeubigerResponse createDeleteGlaeubigerResponse() {
        return new DeleteGlaeubigerResponse();
    }

    /**
     * Create an instance of {@link InsertGlaeubigerResponse }
     * 
     */
    public InsertGlaeubigerResponse createInsertGlaeubigerResponse() {
        return new InsertGlaeubigerResponse();
    }

    /**
     * Create an instance of {@link UpdateGlaeubigerResponse }
     * 
     */
    public UpdateGlaeubigerResponse createUpdateGlaeubigerResponse() {
        return new UpdateGlaeubigerResponse();
    }

    /**
     * Create an instance of {@link UpdateUser }
     * 
     */
    public UpdateUser createUpdateUser() {
        return new UpdateUser();
    }

    /**
     * Create an instance of {@link ServiceStatus }
     * 
     */
    public ServiceStatus createServiceStatus() {
        return new ServiceStatus();
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link UpdateNatPersonResponse }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://example.com", name = "updateNatPersonResponse")
    public JAXBElement<UpdateNatPersonResponse> createUpdateNatPersonResponse(UpdateNatPersonResponse value) {
        return new JAXBElement<UpdateNatPersonResponse>(_UpdateNatPersonResponse_QNAME, UpdateNatPersonResponse.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link FetchNatPersonResponse }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://example.com", name = "fetchNatPersonResponse")
    public JAXBElement<FetchNatPersonResponse> createFetchNatPersonResponse(FetchNatPersonResponse value) {
        return new JAXBElement<FetchNatPersonResponse>(_FetchNatPersonResponse_QNAME, FetchNatPersonResponse.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link DeleteNatPerson }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://example.com", name = "deleteNatPerson")
    public JAXBElement<DeleteNatPerson> createDeleteNatPerson(DeleteNatPerson value) {
        return new JAXBElement<DeleteNatPerson>(_DeleteNatPerson_QNAME, DeleteNatPerson.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link InsertMandantUser }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://example.com", name = "insertMandantUser")
    public JAXBElement<InsertMandantUser> createInsertMandantUser(InsertMandantUser value) {
        return new JAXBElement<InsertMandantUser>(_InsertMandantUser_QNAME, InsertMandantUser.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link FetchGlaeubiger }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://example.com", name = "fetchGlaeubiger")
    public JAXBElement<FetchGlaeubiger> createFetchGlaeubiger(FetchGlaeubiger value) {
        return new JAXBElement<FetchGlaeubiger>(_FetchGlaeubiger_QNAME, FetchGlaeubiger.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link UpdateGlaeubiger }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://example.com", name = "updateGlaeubiger")
    public JAXBElement<UpdateGlaeubiger> createUpdateGlaeubiger(UpdateGlaeubiger value) {
        return new JAXBElement<UpdateGlaeubiger>(_UpdateGlaeubiger_QNAME, UpdateGlaeubiger.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link UpdateMandant }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://example.com", name = "updateMandant")
    public JAXBElement<UpdateMandant> createUpdateMandant(UpdateMandant value) {
        return new JAXBElement<UpdateMandant>(_UpdateMandant_QNAME, UpdateMandant.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link DeleteMandant }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://example.com", name = "deleteMandant")
    public JAXBElement<DeleteMandant> createDeleteMandant(DeleteMandant value) {
        return new JAXBElement<DeleteMandant>(_DeleteMandant_QNAME, DeleteMandant.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link DeleteMandantUser }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://example.com", name = "deleteMandantUser")
    public JAXBElement<DeleteMandantUser> createDeleteMandantUser(DeleteMandantUser value) {
        return new JAXBElement<DeleteMandantUser>(_DeleteMandantUser_QNAME, DeleteMandantUser.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link FetchGlaeubigerResponse }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://example.com", name = "fetchGlaeubigerResponse")
    public JAXBElement<FetchGlaeubigerResponse> createFetchGlaeubigerResponse(FetchGlaeubigerResponse value) {
        return new JAXBElement<FetchGlaeubigerResponse>(_FetchGlaeubigerResponse_QNAME, FetchGlaeubigerResponse.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link InsertMandant }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://example.com", name = "insertMandant")
    public JAXBElement<InsertMandant> createInsertMandant(InsertMandant value) {
        return new JAXBElement<InsertMandant>(_InsertMandant_QNAME, InsertMandant.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link UpdateMandantUserResponse }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://example.com", name = "updateMandantUserResponse")
    public JAXBElement<UpdateMandantUserResponse> createUpdateMandantUserResponse(UpdateMandantUserResponse value) {
        return new JAXBElement<UpdateMandantUserResponse>(_UpdateMandantUserResponse_QNAME, UpdateMandantUserResponse.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link UpdateUser }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://example.com", name = "updateUser")
    public JAXBElement<UpdateUser> createUpdateUser(UpdateUser value) {
        return new JAXBElement<UpdateUser>(_UpdateUser_QNAME, UpdateUser.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link InsertGlaeubiger }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://example.com", name = "insertGlaeubiger")
    public JAXBElement<InsertGlaeubiger> createInsertGlaeubiger(InsertGlaeubiger value) {
        return new JAXBElement<InsertGlaeubiger>(_InsertGlaeubiger_QNAME, InsertGlaeubiger.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link InsertUserResponse }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://example.com", name = "insertUserResponse")
    public JAXBElement<InsertUserResponse> createInsertUserResponse(InsertUserResponse value) {
        return new JAXBElement<InsertUserResponse>(_InsertUserResponse_QNAME, InsertUserResponse.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link UpdateUserResponse }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://example.com", name = "updateUserResponse")
    public JAXBElement<UpdateUserResponse> createUpdateUserResponse(UpdateUserResponse value) {
        return new JAXBElement<UpdateUserResponse>(_UpdateUserResponse_QNAME, UpdateUserResponse.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link DeleteUserResponse }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://example.com", name = "deleteUserResponse")
    public JAXBElement<DeleteUserResponse> createDeleteUserResponse(DeleteUserResponse value) {
        return new JAXBElement<DeleteUserResponse>(_DeleteUserResponse_QNAME, DeleteUserResponse.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link FetchMandantResponse }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://example.com", name = "fetchMandantResponse")
    public JAXBElement<FetchMandantResponse> createFetchMandantResponse(FetchMandantResponse value) {
        return new JAXBElement<FetchMandantResponse>(_FetchMandantResponse_QNAME, FetchMandantResponse.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link InsertMandantUserResponse }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://example.com", name = "insertMandantUserResponse")
    public JAXBElement<InsertMandantUserResponse> createInsertMandantUserResponse(InsertMandantUserResponse value) {
        return new JAXBElement<InsertMandantUserResponse>(_InsertMandantUserResponse_QNAME, InsertMandantUserResponse.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link UpdateNatPerson }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://example.com", name = "updateNatPerson")
    public JAXBElement<UpdateNatPerson> createUpdateNatPerson(UpdateNatPerson value) {
        return new JAXBElement<UpdateNatPerson>(_UpdateNatPerson_QNAME, UpdateNatPerson.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link DeleteGlaeubigerResponse }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://example.com", name = "deleteGlaeubigerResponse")
    public JAXBElement<DeleteGlaeubigerResponse> createDeleteGlaeubigerResponse(DeleteGlaeubigerResponse value) {
        return new JAXBElement<DeleteGlaeubigerResponse>(_DeleteGlaeubigerResponse_QNAME, DeleteGlaeubigerResponse.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link DeleteMandantUserResponse }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://example.com", name = "deleteMandantUserResponse")
    public JAXBElement<DeleteMandantUserResponse> createDeleteMandantUserResponse(DeleteMandantUserResponse value) {
        return new JAXBElement<DeleteMandantUserResponse>(_DeleteMandantUserResponse_QNAME, DeleteMandantUserResponse.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link UpdateMandantResponse }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://example.com", name = "updateMandantResponse")
    public JAXBElement<UpdateMandantResponse> createUpdateMandantResponse(UpdateMandantResponse value) {
        return new JAXBElement<UpdateMandantResponse>(_UpdateMandantResponse_QNAME, UpdateMandantResponse.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link FetchMandantUserResponse }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://example.com", name = "fetchMandantUserResponse")
    public JAXBElement<FetchMandantUserResponse> createFetchMandantUserResponse(FetchMandantUserResponse value) {
        return new JAXBElement<FetchMandantUserResponse>(_FetchMandantUserResponse_QNAME, FetchMandantUserResponse.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link DeleteUser }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://example.com", name = "deleteUser")
    public JAXBElement<DeleteUser> createDeleteUser(DeleteUser value) {
        return new JAXBElement<DeleteUser>(_DeleteUser_QNAME, DeleteUser.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link InsertNatPerson }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://example.com", name = "insertNatPerson")
    public JAXBElement<InsertNatPerson> createInsertNatPerson(InsertNatPerson value) {
        return new JAXBElement<InsertNatPerson>(_InsertNatPerson_QNAME, InsertNatPerson.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link UpdateGlaeubigerResponse }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://example.com", name = "updateGlaeubigerResponse")
    public JAXBElement<UpdateGlaeubigerResponse> createUpdateGlaeubigerResponse(UpdateGlaeubigerResponse value) {
        return new JAXBElement<UpdateGlaeubigerResponse>(_UpdateGlaeubigerResponse_QNAME, UpdateGlaeubigerResponse.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link FetchUserResponse }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://example.com", name = "fetchUserResponse")
    public JAXBElement<FetchUserResponse> createFetchUserResponse(FetchUserResponse value) {
        return new JAXBElement<FetchUserResponse>(_FetchUserResponse_QNAME, FetchUserResponse.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link DeleteNatPersonResponse }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://example.com", name = "deleteNatPersonResponse")
    public JAXBElement<DeleteNatPersonResponse> createDeleteNatPersonResponse(DeleteNatPersonResponse value) {
        return new JAXBElement<DeleteNatPersonResponse>(_DeleteNatPersonResponse_QNAME, DeleteNatPersonResponse.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link FetchNatPerson }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://example.com", name = "fetchNatPerson")
    public JAXBElement<FetchNatPerson> createFetchNatPerson(FetchNatPerson value) {
        return new JAXBElement<FetchNatPerson>(_FetchNatPerson_QNAME, FetchNatPerson.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link UpdateMandantUser }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://example.com", name = "updateMandantUser")
    public JAXBElement<UpdateMandantUser> createUpdateMandantUser(UpdateMandantUser value) {
        return new JAXBElement<UpdateMandantUser>(_UpdateMandantUser_QNAME, UpdateMandantUser.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link FetchMandantUser }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://example.com", name = "fetchMandantUser")
    public JAXBElement<FetchMandantUser> createFetchMandantUser(FetchMandantUser value) {
        return new JAXBElement<FetchMandantUser>(_FetchMandantUser_QNAME, FetchMandantUser.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link FetchMandant }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://example.com", name = "fetchMandant")
    public JAXBElement<FetchMandant> createFetchMandant(FetchMandant value) {
        return new JAXBElement<FetchMandant>(_FetchMandant_QNAME, FetchMandant.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link FetchUser }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://example.com", name = "fetchUser")
    public JAXBElement<FetchUser> createFetchUser(FetchUser value) {
        return new JAXBElement<FetchUser>(_FetchUser_QNAME, FetchUser.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link InsertGlaeubigerResponse }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://example.com", name = "insertGlaeubigerResponse")
    public JAXBElement<InsertGlaeubigerResponse> createInsertGlaeubigerResponse(InsertGlaeubigerResponse value) {
        return new JAXBElement<InsertGlaeubigerResponse>(_InsertGlaeubigerResponse_QNAME, InsertGlaeubigerResponse.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link InsertMandantResponse }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://example.com", name = "insertMandantResponse")
    public JAXBElement<InsertMandantResponse> createInsertMandantResponse(InsertMandantResponse value) {
        return new JAXBElement<InsertMandantResponse>(_InsertMandantResponse_QNAME, InsertMandantResponse.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link InsertUser }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://example.com", name = "insertUser")
    public JAXBElement<InsertUser> createInsertUser(InsertUser value) {
        return new JAXBElement<InsertUser>(_InsertUser_QNAME, InsertUser.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link DeleteGlaeubiger }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://example.com", name = "deleteGlaeubiger")
    public JAXBElement<DeleteGlaeubiger> createDeleteGlaeubiger(DeleteGlaeubiger value) {
        return new JAXBElement<DeleteGlaeubiger>(_DeleteGlaeubiger_QNAME, DeleteGlaeubiger.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link InsertNatPersonResponse }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://example.com", name = "insertNatPersonResponse")
    public JAXBElement<InsertNatPersonResponse> createInsertNatPersonResponse(InsertNatPersonResponse value) {
        return new JAXBElement<InsertNatPersonResponse>(_InsertNatPersonResponse_QNAME, InsertNatPersonResponse.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link DeleteMandantResponse }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://example.com", name = "deleteMandantResponse")
    public JAXBElement<DeleteMandantResponse> createDeleteMandantResponse(DeleteMandantResponse value) {
        return new JAXBElement<DeleteMandantResponse>(_DeleteMandantResponse_QNAME, DeleteMandantResponse.class, null, value);
    }

}
