/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.dpro.session;

import com.iplanet.am.util.Misc;
import com.iplanet.dpro.session.TokenRestriction;
import com.iplanet.dpro.session.service.SessionService;
import com.iplanet.sso.SSOToken;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class DNOrIPAddressListTokenRestriction
implements TokenRestriction {
    private String dn;
    private Set addressList = new HashSet();
    private String asString;
    private static Comparator addressComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            return ((InetAddress)o1).getHostAddress().compareTo(((InetAddress)o2).getHostAddress());
        }
    };

    public DNOrIPAddressListTokenRestriction(String dn, List hostNames) throws Exception {
        this.dn = Misc.canonicalize(dn);
        Iterator i = hostNames.iterator();
        while (i.hasNext()) {
            this.addressList.add(InetAddress.getByName((String)i.next()));
        }
        StringBuffer buf = new StringBuffer();
        buf.append(dn).append("\n");
        Object[] sortedAddressList = this.addressList.toArray();
        Arrays.sort(sortedAddressList, addressComparator);
        for (int i2 = 0; i2 < sortedAddressList.length; ++i2) {
            buf.append(((InetAddress)sortedAddressList[i2]).getHostAddress());
            buf.append("\n");
        }
        this.asString = buf.toString();
    }

    public String toString() {
        return this.asString;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean isSatisfied(Object context) throws Exception {
        if (context == null) {
            return false;
        }
        if (context instanceof SSOToken) {
            SSOToken usedBy = (SSOToken)context;
            return Misc.canonicalize(usedBy.getPrincipal().getName()).equals(this.dn);
        }
        if (context instanceof InetAddress) {
            return this.addressList.contains(context);
        }
        if (SessionService.sessionDebug.warningEnabled()) {
            SessionService.sessionDebug.warning("Unknown context type:" + context);
        }
        return false;
    }

    public boolean equals(Object other) {
        return other != null && other instanceof DNOrIPAddressListTokenRestriction && other.toString().equals(this.toString());
    }
}

