/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.ldap;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.ldap.Attr;
import com.iplanet.services.util.XMLException;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.ums.Guid;
import com.iplanet.ums.PersistentObject;
import com.iplanet.ums.UMSObject;
import com.sun.identity.authentication.internal.AuthContext;
import com.sun.identity.authentication.internal.AuthPrincipal;
import com.sun.identity.authentication.spi.AuthLoginException;
import com.sun.identity.common.ShutdownManager;
import com.sun.identity.common.configuration.ServerConfiguration;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdUtils;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.security.DecodeAction;
import com.sun.identity.security.EncodeAction;
import com.sun.identity.setup.Bootstrap;
import com.sun.identity.setup.ConfiguratorException;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.xml.XMLUtils;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSSchema;
import com.sun.identity.sm.ServiceManager;
import com.sun.identity.tools.bundles.VersionCheck;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.security.AccessController;
import java.security.Principal;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginException;
import netscape.ldap.util.DN;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ServerConfigMgr {
    private static final String HELP = "--help";
    private static final String S_HELP = "-h";
    private static final String Q_HELP = "?";
    private static final String SQ_HELP = "-?";
    private static final String ADMIN = "--admin";
    private static final String S_ADMIN = "-a";
    private static final String PROXY = "--proxy";
    private static final String S_PROXY = "-p";
    private static final String OLD = "--old";
    private static final String S_OLD = "-o";
    private static final String NEW = "--new";
    private static final String S_NEW = "-n";
    private static final String ENCRYPT = "--encrypt";
    private static final String S_ENCRYPT = "-e";
    private static final String RESOURCE_BUNDLE_NAME = "DSConfig";
    private static final int MIN_PASSWORD_LEN = 8;
    private static final String RUN_TIME_CONFIG_PATH = "com.iplanet.coreservices.configpath";
    private static boolean isAMSDKConfigured;
    private boolean isLegacy;
    private static ResourceBundle i18n;
    private static Debug debug;
    private String configFile;
    private Node root;
    private Node defaultServerGroup;
    private String strXMLDeclarationHdr;
    private SSOToken ssoToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());

    public ServerConfigMgr() throws Exception {
        this.isLegacy = ServerConfiguration.isLegacy();
        isAMSDKConfigured = ServiceManager.isAMSDKConfigured();
        this.getServerConfigXMLDoc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getServerConfigXMLDoc() throws Exception {
        InputStream is = null;
        try {
            if (this.isLegacy) {
                this.configFile = ServerConfigMgr.getServiceConfigXMLFileLocation();
                is = new FileInputStream(this.configFile);
            } else {
                String strXML = ServerConfiguration.getServerConfigXML(this.ssoToken, SystemProperties.getServerInstanceName());
                is = new ByteArrayInputStream(strXML.getBytes());
            }
            Document document = XMLUtils.getXMLDocument(is);
            if (document == null) {
                throw new XMLException(i18n.getString("dscfg-error-reading-config-file") + "\n" + i18n.getString("dscfg-corrupted-serverconfig"));
            }
            this.root = XMLUtils.getRootNode(document, "iPlanetDataAccessLayer");
            if (this.root == null) {
                throw new XMLException(i18n.getString("dscfg-unable-to-find-root-node") + "\n" + i18n.getString("dscfg-corrupted-serverconfig"));
            }
            this.defaultServerGroup = XMLUtils.getNamedChildNode(this.root, "ServerGroup", "name", "default");
            if (this.defaultServerGroup == null) {
                throw new XMLException(i18n.getString("dscfg-unable-to-find-default-servergroup") + "\n" + i18n.getString("dscfg-corrupted-serverconfig"));
            }
            this.strXMLDeclarationHdr = this.getXMLDeclarationHeader(this.ssoToken, this.configFile);
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getXMLDeclarationHeader(SSOToken ssoToken, String configFile) throws Exception {
        StringBuffer xml = new StringBuffer();
        InputStream is = null;
        try {
            if (this.isLegacy) {
                is = new FileInputStream(configFile);
            } else {
                String strXML = ServerConfiguration.getServerConfigXML(ssoToken, SystemProperties.getServerInstanceName());
                is = new ByteArrayInputStream(strXML.getBytes());
            }
            BufferedReader in = new BufferedReader(new InputStreamReader(is));
            String line = in.readLine();
            while (line != null) {
                int index = line.indexOf("iPlanetDataAccessLayer");
                if (index != -1) {
                    if (--index > 0) {
                        xml.append(line.substring(0, index)).append("\n");
                    }
                    break;
                }
                xml.append(line).append("\n");
                line = in.readLine();
            }
        }
        finally {
            is.close();
        }
        return xml.toString();
    }

    private static String getServiceConfigXMLFileLocation() throws Exception {
        String fileLoc;
        File file;
        String path = SystemProperties.get("com.iplanet.services.configpath");
        if (path == null) {
            path = System.getProperty(RUN_TIME_CONFIG_PATH);
        }
        if (!((file = new File(fileLoc = path + System.getProperty("file.separator") + "serverconfig.xml")).exists() && file.canRead() && file.canWrite())) {
            String[] objs = new String[]{fileLoc};
            throw new Exception(MessageFormat.format(i18n.getString("dscfg-no-file-permission"), objs));
        }
        return fileLoc;
    }

    private static void validateArguments(String[] args) {
        if (args.length == 0) {
            System.err.println(i18n.getString("dscfg-usage"));
            System.exit(1);
        } else {
            String action = args[0];
            if (!(action.equals(HELP) || action.equals(S_HELP) || action.equals(Q_HELP) || action.equals(SQ_HELP) || action.equals(ADMIN) || action.equals(S_ADMIN) || action.equals(PROXY) || action.equals(S_PROXY) || action.equals(ENCRYPT) || action.equals(S_ENCRYPT))) {
                Object[] objs = new Object[]{action};
                System.err.println(MessageFormat.format(i18n.getString("dscfg-invalid-option"), objs));
                System.err.println(i18n.getString("dscfg-usage"));
                System.exit(1);
            }
            if (action.equals(ADMIN) || action.equals(S_ADMIN) || action.equals(PROXY) || action.equals(S_PROXY)) {
                if (args.length != 5) {
                    System.err.println(i18n.getString("dscfg-illegal-args"));
                    System.err.println(i18n.getString("dscfg-usage"));
                    System.exit(1);
                }
            } else if (action.equals(ENCRYPT) || action.equals(S_ENCRYPT)) {
                if (args.length != 2) {
                    System.err.println(i18n.getString("dscfg-illegal-args"));
                    System.err.println(i18n.getString("dscfg-usage"));
                    System.exit(1);
                }
            } else if (args.length != 1) {
                System.err.println(i18n.getString("dscfg-illegal-args"));
                System.err.println(i18n.getString("dscfg-usage"));
                System.exit(1);
            }
        }
    }

    private static boolean printHelpMessage(String[] args) {
        boolean processed = false;
        if (args[0].equals(HELP) || args[0].equals(S_HELP) || args[0].equals(Q_HELP) || args[0].equals(SQ_HELP)) {
            processed = true;
            System.out.println(i18n.getString("dscfg-usage"));
        }
        return processed;
    }

    private static boolean encryptPassword(String[] args) {
        boolean processed = false;
        if (args[0].equals(S_ENCRYPT) || args[0].equals(ENCRYPT)) {
            processed = true;
            String password = null;
            if (args.length > 1) {
                try {
                    password = ServerConfigMgr.readOneLinerFromFile(args[1]);
                    if (password == null || password.length() == 0) {
                        Object[] messageArgs = new Object[]{args[1]};
                        System.err.println(MessageFormat.format(i18n.getString("dscfg-null-password"), messageArgs));
                        System.err.println(i18n.getString("dscfg-usage"));
                        System.exit(1);
                    }
                    System.out.println((String)AccessController.doPrivileged(new EncodeAction(password)));
                }
                catch (FileNotFoundException e) {
                    Object[] messageArgs = new Object[]{args[1]};
                    System.err.println(MessageFormat.format(i18n.getString("dscfg-passwd-file-not-found"), messageArgs));
                    System.exit(1);
                }
                catch (IOException ioe) {
                    Object[] messageArgs = new Object[]{args[1]};
                    System.err.println(MessageFormat.format(i18n.getString("dscfg-passwd-file-not-found"), messageArgs));
                    System.exit(1);
                }
            } else {
                Object[] messageArgs = new Object[]{args[0]};
                System.err.println(MessageFormat.format(i18n.getString("dscfg-incorrect-usage"), messageArgs));
                System.err.println(i18n.getString("dscfg-usage"));
                System.exit(1);
            }
        }
        return processed;
    }

    private static boolean changePassword(String[] args) throws Exception {
        boolean adminPassword = false;
        boolean proxyPassword = false;
        if (args[0].equals(S_ADMIN) || args[0].equals(ADMIN)) {
            adminPassword = true;
        } else {
            proxyPassword = true;
        }
        isAMSDKConfigured = ServiceManager.isAMSDKConfigured();
        if (proxyPassword && !isAMSDKConfigured) {
            System.err.println(i18n.getString("dscfg-proxy-no-suppport"));
            System.exit(1);
        }
        String oldPassword = null;
        String newPassword = null;
        for (int i = 1; i < args.length; ++i) {
            if (args[i].equals(OLD) || args[i].equals(S_OLD)) {
                oldPassword = ServerConfigMgr.readOneLinerFromFile(args[++i]);
                continue;
            }
            if (args[i].equals(NEW) || args[i].equals(S_NEW)) {
                newPassword = ServerConfigMgr.readOneLinerFromFile(args[++i]);
                continue;
            }
            Object[] objs = new Object[]{args[i]};
            System.err.println(MessageFormat.format(i18n.getString("dscfg-invalid-option"), objs));
            System.err.println(i18n.getString("dscfg-usage"));
            System.exit(1);
        }
        ServerConfigMgr.validatePasswords(oldPassword, newPassword);
        if (adminPassword && !isAMSDKConfigured) {
            SSOToken ssoToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
            if (!ServerConfigMgr.authenticateDsameUser(ssoToken, oldPassword, newPassword)) {
                throw new Exception(i18n.getString("dscfg-invalid-password"));
            }
            String dsameuserDN = "cn=dsameuser,ou=DSAME Users," + SMSEntry.getRootSuffix();
            AMIdentity dsameuser = IdUtils.getIdentity(ssoToken, dsameuserDN);
            HashSet<String> setNewPwd = new HashSet<String>(2);
            setNewPwd.add(newPassword);
            HashMap<String, HashSet<String>> mapPassword = new HashMap<String, HashSet<String>>(2);
            mapPassword.put("userpassword", setNewPwd);
            dsameuser.setAttributes(mapPassword);
            dsameuser.store();
        } else {
            DN proxyDN;
            ServerConfigMgr scm = new ServerConfigMgr();
            DN adminDN = new DN(scm.getUserDN("admin"));
            if (adminDN.equals(proxyDN = new DN(scm.getUserDN("proxy")))) {
                adminPassword = true;
                proxyPassword = true;
            }
            if (adminPassword) {
                scm.setAdminUserPassword(oldPassword, newPassword);
            }
            if (proxyPassword) {
                scm.setProxyUserPassword(oldPassword, newPassword);
            }
            scm.save();
        }
        System.out.println(i18n.getString("dscfg-passwd-success"));
        return true;
    }

    private static boolean authenticateDsameUser(SSOToken ssoToken, String oldPassword, String newPassword) {
        Callback[] idCallbacks = new Callback[2];
        NameCallback nameCallback = new NameCallback("dummy");
        nameCallback.setName("dsameuser");
        idCallbacks[0] = nameCallback;
        PasswordCallback passwordCallback = new PasswordCallback("dummy", false);
        passwordCallback.setPassword(oldPassword.toCharArray());
        idCallbacks[1] = passwordCallback;
        try {
            AMIdentityRepository amir = new AMIdentityRepository(ssoToken, "/");
            if (!amir.authenticate(idCallbacks)) {
                passwordCallback.setPassword(newPassword.toCharArray());
                return amir.authenticate(idCallbacks);
            }
            return true;
        }
        catch (SSOException ex) {
            return false;
        }
        catch (AuthLoginException ex) {
            return false;
        }
        catch (IdRepoException ex) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            Bootstrap.load();
            if (VersionCheck.isVersionValid() == 1) {
                System.exit(1);
            }
            debug = Debug.getInstance("amSDK");
            ServerConfigMgr.validateArguments(args);
            boolean proceeded = ServerConfigMgr.printHelpMessage(args) || ServerConfigMgr.encryptPassword(args) || ServerConfigMgr.changePassword(args);
        }
        catch (ConfiguratorException ex) {
            System.err.println(ex.getL10NMessage(Locale.getDefault()));
            System.exit(1);
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
            System.exit(1);
        }
        finally {
            ShutdownManager.getInstance().shutdown();
        }
    }

    public void setAdminUserPassword(String oldPassword, String newPassword) throws Exception {
        this.changePassword("admin", oldPassword, newPassword);
        if (!this.isLegacy) {
            Bootstrap.modifyDSAMEUserPassword((String)newPassword);
        }
    }

    protected void setProxyUserPassword(String oldPassword, String newPassword) throws Exception {
        this.changePassword("proxy", oldPassword, newPassword);
    }

    public void save() throws Exception {
        String xml = this.strXMLDeclarationHdr + SMSSchema.nodeToString(this.root);
        if (this.isLegacy) {
            PrintWriter out = new PrintWriter(new FileOutputStream(this.configFile));
            out.print(xml);
            out.close();
        } else {
            ServerConfiguration.setServerConfigXML(this.ssoToken, SystemProperties.getServerInstanceName(), xml);
        }
    }

    private void changePassword(String userType, String oldPassword, String newPassword) throws Exception {
        String fileEncPassword = this.getUserPassword(userType);
        String userDN = this.getUserDN(userType);
        if (fileEncPassword == null || fileEncPassword.length() == 0 || userDN == null || userDN.length() == 0) {
            debug.error("Null password or user DN for user type: " + userType + " from file: " + this.configFile);
            throw new XMLException(i18n.getString("dscfg-corrupted-serverconfig"));
        }
        if (!oldPassword.equals(AccessController.doPrivileged(new DecodeAction(fileEncPassword)))) {
            throw new Exception(i18n.getString("dscfg-old-passwd-donot-match"));
        }
        if (isAMSDKConfigured) {
            try {
                new AuthContext((Principal)new AuthPrincipal(userDN), newPassword.toCharArray());
                if (debug.messageEnabled()) {
                    debug.message("DN: " + userDN + " new password is already updated in the directory");
                }
            }
            catch (LoginException lee) {
                try {
                    AuthContext ac = new AuthContext((Principal)new AuthPrincipal(userDN), oldPassword.toCharArray());
                    PersistentObject user = UMSObject.getObject((SSOToken)ac.getSSOToken(), (Guid)new Guid(userDN));
                    if (debug.messageEnabled()) {
                        debug.message("For DN: " + userDN + " changing password in directory");
                    }
                    user.setAttribute(new Attr("userPassword", newPassword));
                    user.save();
                }
                catch (LoginException le) {
                    if (debug.warningEnabled()) {
                        debug.warning("For DN: " + userDN + " new and old passwords donot match with directory");
                    }
                    throw new Exception(i18n.getString("dscfg-invalid-password") + "\n" + le.getMessage());
                }
            }
        }
        this.setUserPassword(userType, newPassword);
    }

    private String getUserDN(String userType) throws Exception {
        Node dnNode = XMLUtils.getChildNode(this.getUserNode(userType), "DirDN");
        if (dnNode == null) {
            throw new XMLException(i18n.getString("dscfg-corrupted-serverconfig"));
        }
        return XMLUtils.getValueOfValueNode(dnNode);
    }

    private String getUserPassword(String userType) throws Exception {
        Node pwdNode = XMLUtils.getChildNode(this.getUserNode(userType), "DirPassword");
        if (pwdNode == null) {
            throw new XMLException(i18n.getString("dscfg-corrupted-serverconfig"));
        }
        return XMLUtils.getValueOfValueNode(pwdNode);
    }

    private void setUserPassword(String userType, String password) throws Exception {
        Node pwdNode = XMLUtils.getChildNode(this.getUserNode(userType), "DirPassword");
        if (pwdNode == null) {
            throw new XMLException(i18n.getString("dscfg-corrupted-serverconfig"));
        }
        String encPassword = (String)AccessController.doPrivileged(new EncodeAction(password));
        NodeList textNodes = pwdNode.getChildNodes();
        Node textNode = textNodes.item(0);
        textNode.setNodeValue(encPassword);
        for (int i = 1; i < textNodes.getLength(); ++i) {
            pwdNode.removeChild(textNodes.item(i));
        }
    }

    private Node getUserNode(String userType) throws Exception {
        Node userNode = XMLUtils.getNamedChildNode(this.defaultServerGroup, "User", "type", userType);
        if (userNode == null) {
            debug.error("Unable to get user type: " + userType + " node from file: " + this.configFile);
            throw new XMLException(i18n.getString("dscfg-corrupted-serverconfig"));
        }
        return userNode;
    }

    private static void validatePasswords(String oldPassword, String newPassword) {
        if (oldPassword == null || oldPassword.length() == 0) {
            System.err.println(i18n.getString("dscfg-null-old-password"));
            System.err.println(i18n.getString("dscfg-usage"));
            System.exit(1);
        }
        if (newPassword == null || newPassword.length() == 0) {
            System.err.println(i18n.getString("dscfg-null-new-password"));
            System.err.println(i18n.getString("dscfg-usage"));
            System.exit(1);
        }
        if (newPassword.length() < 8) {
            String[] objs = new String[]{Integer.toString(8)};
            System.err.println(MessageFormat.format(i18n.getString("dscfg-password-lenght-not-met"), objs));
            System.exit(1);
        } else if (newPassword.equals(oldPassword)) {
            System.err.println(i18n.getString("dscfg-passwords-are-same"));
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readOneLinerFromFile(String fileName) throws FileNotFoundException, IOException {
        BufferedReader br = null;
        String lineData = null;
        try {
            FileReader fr = new FileReader(fileName);
            br = new BufferedReader(fr);
            lineData = br.readLine();
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
        return lineData;
    }

    static {
        i18n = ResourceBundle.getBundle(RESOURCE_BUNDLE_NAME);
    }
}

