/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.interaction;

import com.sun.identity.liberty.ws.interaction.InteractionManager;
import com.sun.identity.shared.configuration.SystemPropertiesManager;
import com.sun.identity.shared.debug.Debug;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;

class InteractionConfig {
    static final String WSC_SPECIFIED_INTERACTION_CHOICE = "com.sun.identity.liberty.interaction.wscSpecifiedInteractionChoice";
    static final String INTERACT_IF_NEEDED = "interactIfNeeded";
    static final String DO_NOT_INTERACT = "doNotInteract";
    static final String DO_NOT_INTERACT_FOR_DATA = "doNotInteractForData";
    static final String WSC_WILL_INCLUDE_USER_INTERACTION_HEADER_OLD = "com.sun.identity.liberty.interaction.wscWillInlcudeUserInteractionHeader";
    static final String WSC_WILL_INCLUDE_USER_INTERACTION_HEADER = "com.sun.identity.liberty.interaction.wscWillIncludeUserInteractionHeader";
    static final String WSC_WILL_REDIRECT = "com.sun.identity.liberty.interaction.wscWillRedirect";
    static final String WSC_SPECIFIED_MAX_INTERACTION_TIME = "com.sun.identity.liberty.interaction.wscSpecifiedMaxInteractionTime";
    static final int DEFAULT_WSC_MAX_INTERACTION_TIME = 60;
    static final String WSC_WILL_ENFORCE_HTTPS_CHECK = "com.sun.identity.liberty.interaction.wscWillEnforceHttpsCheck";
    static final String WSP_WILL_REDIRECT = "com.sun.identity.liberty.interaction.wspWillRedirect";
    static final String WSP_WILL_REDIRECT_FOR_DATA = "com.sun.identity.liberty.interaction.wspWillRedirectForData";
    static final String WSP_REDIRECT_TIME = "com.sun.identity.liberty.interaction.wspRedirectTime";
    static final int DEFAULT_WSP_REDIRECT_TIME = 30;
    static final String WSP_REDIRECT_HANDLER = "com.sun.identity.liberty.interaction.wspRedirectHandler";
    static final String WSP_REDIRECT_HANDLER_SERVLET = "WSPRedirectHandler";
    static final String INTERACTION_CONFIG_CLASS = "com.sun.identity.liberty.interaction.interactionConfigClass";
    static final String LB_WSP_REDIRECT_HANDLER = "com.sun.identity.liberty.interaction.lbWspRedirectHandler";
    static final String TRUSTED_WSP_REDIRECT_HANDLERS = "com.sun.identity.liberty.interaction.trustedWspRedirectHandlers";
    static final String WSP_WILL_ENFORCE_HTTPS_CHECK = "com.sun.identity.liberty.interaction.wspWillEnforceHttpsCheck";
    static final String WSP_WILL_ENFORCE_RETURN_TO_HOST_EQUALS_REQUEST_HOST = "com.sun.identity.liberty.interaction.wspWillEnforceReturnToHostEqualsRequestHost";
    static final String HTML_STYLE_SHEET_LOCATION = "com.sun.identity.liberty.interaction.htmlStyleSheetLocation";
    static final String WML_STYLE_SHEET_LOCATION = "com.sun.identity.liberty.interaction.wmlStyleSheetLocation";
    public static final String HANDLER_HOST_ID = "HandlerHostId";
    static final String YES = "yes";
    private static InteractionConfig interactionConfig = null;
    private static Debug debug = Debug.getInstance("libInteraction");
    private QName wscSpecifiedInteractionChoice = InteractionManager.QNAME_INTERACT_IF_NEEDED;
    private boolean wscWillIncludeUserInteractionHeader = true;
    private boolean wscWillRedirect = true;
    private int wscSpecifiedMaxInteractionTime = 60;
    private boolean wscWillEnforceHttpsCheck = false;
    private String wscSpecifiedConnectTo = "null";
    private boolean wspWillRedirect = true;
    private boolean wspWillRedirectForData = true;
    private int wspRedirectTime = 30;
    protected String wspRedirectHandler = null;
    protected String lbWspRedirectHandler = null;
    protected Map trustedWspRedirectHandlers = new HashMap();
    protected String localServerId = null;
    private boolean wspWillEnforceHttpsCheck = false;
    private boolean wspWillEnforceReturnToHostEqualsRequestHost = false;
    private String htmlStyleSheetLocation = null;
    private String wmlStyleSheetLocation = null;
    private static String interactionConfigClassName = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized InteractionConfig getInstance() {
        if (interactionConfig == null) {
            interactionConfigClassName = SystemPropertiesManager.get(INTERACTION_CONFIG_CLASS);
            if (debug.messageEnabled()) {
                debug.message("InteractionConfig.getInstance():interactionConfigClassName:" + interactionConfigClassName);
            }
            if (interactionConfigClassName == null) {
                if (debug.messageEnabled()) {
                    debug.message("InteractionConfig.getInstance(): interactionConfigClassName not specified, defaulting to  federation library InteractionConfig");
                }
                interactionConfig = new InteractionConfig();
            } else {
                try {
                    interactionConfig = (InteractionConfig)Class.forName(interactionConfigClassName).newInstance();
                }
                catch (InstantiationException ie) {
                    debug.error("InteractionConfig.getInstance() Can not instantiate class:" + interactionConfigClassName);
                }
                catch (IllegalAccessException iae) {
                    debug.error("InteractionConfig.getInstance() Illegal access to class:" + interactionConfigClassName);
                }
                catch (ClassNotFoundException cnfe) {
                    debug.error("InteractionConfig.getInstance() class not found :" + interactionConfigClassName);
                }
                finally {
                    if (interactionConfig == null) {
                        if (debug.warningEnabled()) {
                            debug.warning("InteractionConfig.getInstance():did not find configured class,  would use config class:com.sun.identity.liberty.ws.interaction.InteractionConfig");
                        }
                        interactionConfig = new InteractionConfig();
                    }
                }
            }
            if (debug.messageEnabled()) {
                debug.message("InteractionConfig.getInstance():created instance:" + interactionConfig.toString());
            }
        }
        return interactionConfig;
    }

    protected InteractionConfig() {
        this.initialize();
        if (debug.messageEnabled()) {
            debug.message("InteractionConfig():constructed singleton instance:with Values=" + this.toString());
        }
    }

    boolean wscIncludesUserInteractionHeader() {
        return this.wscWillIncludeUserInteractionHeader;
    }

    boolean wscSupportsRedirect() {
        return this.wscWillRedirect;
    }

    QName getWSCSpecifiedInteractionChoice() {
        return this.wscSpecifiedInteractionChoice;
    }

    int getWSCSpecifiedMaxInteractionTime() {
        return this.wscSpecifiedMaxInteractionTime;
    }

    String getWSCSpecifiedConnectTo() {
        return this.wscSpecifiedConnectTo;
    }

    boolean wscEnforcesHttpsCheck() {
        return this.wscWillEnforceHttpsCheck;
    }

    int getWSPRedirectTime() {
        return this.wspRedirectTime;
    }

    String getWSPRedirectHandler() {
        return this.wspRedirectHandler;
    }

    String getLbWSPRedirectHandler() {
        return this.lbWspRedirectHandler;
    }

    Map getTrustedWSPRedirectHandlers() {
        return this.trustedWspRedirectHandlers;
    }

    String getLocalServerId() {
        return this.localServerId;
    }

    boolean wspSupportsRedirect() {
        return this.wspWillRedirect;
    }

    boolean wspRedirectsForData() {
        return this.wspWillRedirectForData;
    }

    boolean wspEnforcesHttpsCheck() {
        return this.wspWillEnforceHttpsCheck;
    }

    boolean wspEnforcesReturnToHostEqualsRequestHost() {
        return this.wspWillEnforceReturnToHostEqualsRequestHost;
    }

    String getHTMLStyleSheetLocation() {
        return this.htmlStyleSheetLocation;
    }

    String getWMLStyleSheetLocation() {
        return this.wmlStyleSheetLocation;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("InteractionConfig:wscSpecifiedInteractionChoice=" + this.wscSpecifiedInteractionChoice);
        sb.append(":wscWillIncludeUserInteractionHeader=" + this.wscWillIncludeUserInteractionHeader);
        sb.append(":wscWillRedirect=" + this.wscWillRedirect);
        sb.append(":wscSpecifiedMaxInteractionTime=" + this.wscSpecifiedMaxInteractionTime);
        sb.append(":wscWillEnforceHttpsCheck=" + this.wscWillEnforceHttpsCheck);
        sb.append(":wscSpecifiedConnectTo=" + this.wscSpecifiedConnectTo);
        sb.append(":wspWillRedirect=" + this.wspWillRedirect);
        sb.append(":wspWillRedirectForData=" + this.wspWillRedirectForData);
        sb.append(":wspRedirectTime=" + this.wspRedirectTime);
        sb.append(":wspRedirectHandler=" + this.wspRedirectHandler);
        sb.append(":lbWspRedirectHandler=" + this.lbWspRedirectHandler);
        sb.append(":trustedWspRedirectHandlers=" + this.trustedWspRedirectHandlers);
        sb.append(":localServerId=" + this.localServerId);
        sb.append(":interactionConfigClassName=" + interactionConfigClassName);
        sb.append(":interactionConfig.getClass().getName()=" + this.getClass().getName());
        sb.append(":wspWillEnforceHttpsCheck=" + this.wspWillEnforceHttpsCheck);
        sb.append(":wspWillEnforceReturnToHostEqualsRequestHost=" + this.wspWillEnforceReturnToHostEqualsRequestHost);
        sb.append(":htmlStyleSheetLocation=" + this.htmlStyleSheetLocation);
        sb.append(":wmlStyleSheetLocation=" + this.wmlStyleSheetLocation);
        return sb.toString();
    }

    protected void initialize() {
        String trustedRedirectHandlersString;
        String s = null;
        s = SystemPropertiesManager.get(WSC_SPECIFIED_INTERACTION_CHOICE);
        if (s != null) {
            if (s.equals(INTERACT_IF_NEEDED)) {
                this.wscSpecifiedInteractionChoice = InteractionManager.QNAME_INTERACT_IF_NEEDED;
            } else if (s.equals(DO_NOT_INTERACT)) {
                this.wscSpecifiedInteractionChoice = InteractionManager.QNAME_DO_NOT_INTERACT;
            } else if (s.equals(DO_NOT_INTERACT_FOR_DATA)) {
                this.wscSpecifiedInteractionChoice = InteractionManager.QNAME_DO_NOT_INTERACT_FOR_DATA;
            } else {
                if (debug.warningEnabled()) {
                    debug.warning("InteractionConfig.initialize():invalid wscSpecifiedInteractionChoice=" + s + ":defaulting to = " + INTERACT_IF_NEEDED);
                }
                this.wscSpecifiedInteractionChoice = InteractionManager.QNAME_INTERACT_IF_NEEDED;
            }
        } else {
            if (debug.warningEnabled()) {
                debug.warning("InteractionConfig.initialize():wscSpecifiedInteractionChoice not specified :defaulting to = interactIfNeeded");
            }
            this.wscSpecifiedInteractionChoice = InteractionManager.QNAME_INTERACT_IF_NEEDED;
        }
        s = SystemPropertiesManager.get(WSC_WILL_INCLUDE_USER_INTERACTION_HEADER);
        if (s == null) {
            s = SystemPropertiesManager.get(WSC_WILL_INCLUDE_USER_INTERACTION_HEADER_OLD);
        }
        if (s != null) {
            this.wscWillIncludeUserInteractionHeader = s.equalsIgnoreCase(YES);
        } else {
            if (debug.warningEnabled()) {
                debug.warning("InteractionConfig.initialize():wscWillIncludeUerInteractionHeader not specified:defaulting to = true");
            }
            this.wscWillIncludeUserInteractionHeader = true;
        }
        s = SystemPropertiesManager.get(WSC_WILL_REDIRECT);
        if (s != null) {
            this.wscWillRedirect = s.equalsIgnoreCase(YES);
        } else {
            if (debug.warningEnabled()) {
                debug.warning("InteractionConfig.initialize():wscWillRedirect not specified:defaulting to = true");
            }
            this.wscWillRedirect = true;
        }
        s = SystemPropertiesManager.get(WSC_SPECIFIED_MAX_INTERACTION_TIME);
        if (s != null) {
            try {
                this.wscSpecifiedMaxInteractionTime = Integer.parseInt(s);
            }
            catch (NumberFormatException nfe) {
                debug.error("InteractionConfig.initialize():invalid wscSpecifiedMaxInteractionTime=" + s, nfe);
                debug.error("InteractionConfig.initialize():defaulting wscSpecifiedMaxInteractionTimeto=60");
                this.wscSpecifiedMaxInteractionTime = 60;
            }
        } else {
            if (debug.warningEnabled()) {
                debug.warning("InteractionConfig.initialize():wscSpecifiedMaxInteractionTime not specified:defaulting to = 60");
            }
            this.wscSpecifiedMaxInteractionTime = 60;
        }
        if ((s = SystemPropertiesManager.get(WSC_WILL_ENFORCE_HTTPS_CHECK)) != null) {
            this.wscWillEnforceHttpsCheck = s.equalsIgnoreCase(YES);
        } else {
            if (debug.warningEnabled()) {
                debug.warning("InteractionConfig.initialize():wscWillEnforceHttpsCheck not specified:defaulting to = true");
            }
            this.wscWillEnforceHttpsCheck = true;
        }
        s = SystemPropertiesManager.get(WSP_WILL_REDIRECT);
        if (s != null) {
            this.wspWillRedirect = s.equalsIgnoreCase(YES);
        } else {
            if (debug.warningEnabled()) {
                debug.warning("InteractionConfig.initialize():wspWillRedirect not specified:defaulting to = true");
            }
            this.wspWillRedirect = true;
        }
        s = SystemPropertiesManager.get(WSP_WILL_REDIRECT_FOR_DATA);
        if (s != null) {
            this.wspWillRedirectForData = s.equalsIgnoreCase(YES);
        } else {
            if (debug.warningEnabled()) {
                debug.warning("InteractionConfig.initialize():wspWillRedirectForData not specified:defaulting to = true");
            }
            this.wspWillRedirectForData = true;
        }
        s = SystemPropertiesManager.get(WSP_REDIRECT_TIME);
        if (s != null) {
            try {
                this.wspRedirectTime = Integer.parseInt(s);
            }
            catch (NumberFormatException nfe) {
                debug.error("InteractionConfig.initialize():invalid wspRedirectTime=" + s, nfe);
                debug.error("InteractionConfig.initialize():defaulting wspRedirectTime=30");
                this.wspRedirectTime = 30;
            }
        } else {
            if (debug.warningEnabled()) {
                debug.warning("InteractionConfig.initialize():wspRedirectTime not specified:defaulting to = 30");
            }
            this.wspRedirectTime = 30;
        }
        if ((s = SystemPropertiesManager.get(WSP_WILL_ENFORCE_HTTPS_CHECK)) != null) {
            this.wspWillEnforceHttpsCheck = s.equalsIgnoreCase(YES);
        } else {
            if (debug.warningEnabled()) {
                debug.warning("InteractionConfig.initialize():wspWillEnforceHttpsCheck not specified:defaulting to = true");
            }
            this.wspWillEnforceHttpsCheck = true;
        }
        s = SystemPropertiesManager.get(WSP_WILL_ENFORCE_RETURN_TO_HOST_EQUALS_REQUEST_HOST);
        if (s != null) {
            this.wspWillEnforceReturnToHostEqualsRequestHost = s.equalsIgnoreCase(YES);
        } else {
            if (debug.warningEnabled()) {
                debug.warning("InteractionConfig.initialize():wspWillEnforceReturnToHostEqualsRequestHost not  specified:defaulting to = true");
            }
            this.wspWillEnforceReturnToHostEqualsRequestHost = true;
        }
        this.wspRedirectHandler = SystemPropertiesManager.get(WSP_REDIRECT_HANDLER);
        if (this.wspRedirectHandler == null) {
            debug.error("InteractionConfig.initialize():wspRedirectHandler is null");
        }
        this.lbWspRedirectHandler = SystemPropertiesManager.get(LB_WSP_REDIRECT_HANDLER);
        if (this.lbWspRedirectHandler == null && debug.messageEnabled()) {
            debug.message("InteractionConfig.initialize():lbWspRedirectHandler is null");
        }
        if ((trustedRedirectHandlersString = SystemPropertiesManager.get(TRUSTED_WSP_REDIRECT_HANDLERS)) == null) {
            if (debug.messageEnabled()) {
                debug.message("InteractionConfig.initialize():trustedRedirectHandlersString is null");
            }
        } else {
            StringTokenizer st = new StringTokenizer(trustedRedirectHandlersString, " ");
            int handlerId = 1;
            while (st.hasMoreTokens()) {
                this.trustedWspRedirectHandlers.put(Integer.toString(handlerId), st.nextToken());
                ++handlerId;
            }
        }
        this.localServerId = null;
        Iterator iter = this.trustedWspRedirectHandlers.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            if (!this.wspRedirectHandler.equals(this.trustedWspRedirectHandlers.get(key))) continue;
            this.localServerId = key;
            break;
        }
        if (this.localServerId == null) {
            debug.error("WSPRedirectHandlerServlet.handleRequest():local serverId is null for wspRedirectHandler:" + this.wspRedirectHandler);
        }
        this.htmlStyleSheetLocation = SystemPropertiesManager.get(HTML_STYLE_SHEET_LOCATION);
        if (this.htmlStyleSheetLocation == null) {
            debug.error("InteractionConfig.initialize():htmlStyleSheetLocation is null");
        }
        this.wmlStyleSheetLocation = SystemPropertiesManager.get(WML_STYLE_SHEET_LOCATION);
        if (this.wmlStyleSheetLocation == null) {
            debug.error("InteractionConfig.initialize():wmlStyleSheetLocation is null");
        }
    }
}

