/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy.plugins;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.policy.ConditionDecision;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.Syntax;
import com.sun.identity.policy.interfaces.Condition;
import com.sun.identity.shared.debug.Debug;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class IPCondition
implements Condition {
    public static final String IP_RANGE = "IpRange";
    private static final Debug DEBUG = Debug.getInstance("amPolicy");
    private Map properties;
    private ArrayList ipList = new ArrayList();
    private ArrayList dnsList = new ArrayList();
    private long startIp = Long.MAX_VALUE;
    private long endIp = Long.MIN_VALUE;
    private static List propertyNames = new ArrayList(3);

    public List getPropertyNames() {
        return new ArrayList(propertyNames);
    }

    public Syntax getPropertySyntax(String property) {
        return Syntax.NONE;
    }

    public String getDisplayName(String property, Locale locale) throws PolicyException {
        return "";
    }

    public Set getValidValues(String property) throws PolicyException {
        return Collections.EMPTY_SET;
    }

    public void setProperties(Map properties) throws PolicyException {
        this.properties = properties;
        this.ipList.clear();
        this.dnsList.clear();
        this.validateProperties();
    }

    public Map getProperties() {
        return this.properties == null ? null : Collections.unmodifiableMap(this.properties);
    }

    public ConditionDecision getConditionDecision(SSOToken token, Map env) throws PolicyException, SSOException {
        boolean allowed = false;
        String ip = (String)env.get("requestIp");
        if (ip == null && token != null) {
            ip = token.getIPAddress().getHostAddress();
        }
        Set reqDnsNames = (Set)env.get("requestDnsName");
        if (ip != null && this.isAllowedByIp(ip)) {
            allowed = true;
        } else if (reqDnsNames != null && reqDnsNames.size() != 0) {
            Iterator names = reqDnsNames.iterator();
            while (names.hasNext()) {
                String dnsName = (String)names.next();
                if (!this.isAllowedByDns(dnsName)) continue;
                allowed = true;
                break;
            }
        }
        if (DEBUG.messageEnabled()) {
            DEBUG.message("At IPCondition.getConditionDecision():requestIp,  requestDnsName, allowed = " + ip + ", " + reqDnsNames + "," + allowed);
        }
        return new ConditionDecision(allowed);
    }

    public Object clone() {
        IPCondition theClone = null;
        try {
            theClone = (IPCondition)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        theClone.dnsList = (ArrayList)this.dnsList.clone();
        theClone.ipList = (ArrayList)this.ipList.clone();
        if (this.properties != null) {
            theClone.properties = new HashMap();
            Iterator it = this.properties.keySet().iterator();
            while (it.hasNext()) {
                Object o = it.next();
                HashSet values = new HashSet();
                values.addAll((Set)this.properties.get(o));
                theClone.properties.put(o, values);
            }
        }
        return theClone;
    }

    private boolean validateProperties() throws PolicyException {
        Set dnsNameSet;
        if (this.properties == null || this.properties.keySet() == null) {
            throw new PolicyException("amPolicy", "properties_can_not_be_null_or_empty", null, null);
        }
        Set keySet = this.properties.keySet();
        if (!(keySet.contains(IP_RANGE) || keySet.contains("DnsName") || keySet.contains("StartIp"))) {
            Object[] args = new String[]{"DnsName,StartIp"};
            throw new PolicyException("amPolicy", "at_least_one_of_the_properties_should_be_defined", args, null);
        }
        Iterator keys = keySet.iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (IP_RANGE.equals(key) || "DnsName".equals(key) || "StartIp".equals(key) || "EndIp".equals(key)) continue;
            Object[] args = new String[]{key};
            throw new PolicyException("amPolicy", "attempt_to_set_invalid_property ", args, null);
        }
        Set ipRangeSet = (Set)this.properties.get(IP_RANGE);
        if (ipRangeSet != null) {
            this.validateIpRangeSet(ipRangeSet);
        }
        if ((dnsNameSet = (Set)this.properties.get("DnsName")) != null) {
            this.validateDnsNames(dnsNameSet);
        }
        Set startIpSet = (Set)this.properties.get("StartIp");
        Set endIpSet = (Set)this.properties.get("EndIp");
        if (startIpSet != null) {
            if (endIpSet == null) {
                Object[] args = new String[]{"StartIp", "EndIp"};
                throw new PolicyException("amPolicy", "pair_property_not_defined", args, null);
            }
            this.validateStartIp(startIpSet);
        }
        if (endIpSet != null) {
            this.validateEndIp(endIpSet);
        }
        return true;
    }

    private boolean validateIpRangeSet(Set ipSet) throws PolicyException {
        Iterator ipRanges = ipSet.iterator();
        while (ipRanges.hasNext()) {
            String startIp;
            String ipRange = (String)ipRanges.next();
            StringTokenizer st = new StringTokenizer(ipRange, "-");
            int tokenCount = st.countTokens();
            if (tokenCount > 2) {
                Object[] args = new String[]{IP_RANGE, ipRange};
                throw new PolicyException("amPolicy", "invalid_property_value", args, null);
            }
            String endIp = startIp = st.nextToken();
            if (tokenCount == 2) {
                endIp = st.nextToken();
            }
            this.ipList.add(new Long(this.stringToIp(startIp)));
            this.ipList.add(new Long(this.stringToIp(endIp)));
        }
        return true;
    }

    private boolean validateEndIp(Set ipSet) throws PolicyException {
        if (this.startIp == Long.MAX_VALUE) {
            Object[] args = new String[]{"EndIp", "StartIp"};
            throw new PolicyException("amPolicy", "pair_property_not_defined", args, null);
        }
        if (ipSet.size() != 1) {
            Object[] args = new String[]{"EndIp"};
            throw new PolicyException("amPolicy", "multiple_values_not_allowed_for", args, null);
        }
        Iterator endIpIter = ipSet.iterator();
        try {
            String endIpString = (String)endIpIter.next();
            this.endIp = this.stringToIp(endIpString);
        }
        catch (ClassCastException ce) {
            Object[] args = new String[]{"EndIp"};
            throw new PolicyException("amPolicy", "property_is_not_a_String", args, ce);
        }
        if (this.endIp < this.startIp) {
            throw new PolicyException("amPolicy", "start_ip_can_not_be_greater_than_end_ip", null, null);
        }
        return true;
    }

    private boolean validateStartIp(Set ipSet) throws PolicyException {
        if (ipSet.size() != 1) {
            Object[] args = new String[]{"StartIp"};
            throw new PolicyException("amPolicy", "multiple_values_not_allowed_for_property", args, null);
        }
        Iterator startIpIter = ipSet.iterator();
        try {
            String startIpString = (String)startIpIter.next();
            this.startIp = this.stringToIp(startIpString);
        }
        catch (ClassCastException ce) {
            Object[] args = new String[]{"StartIp"};
            throw new PolicyException("amPolicy", "property_is_not_a_String", args, ce);
        }
        return true;
    }

    private void validateDnsNames(Set dnsNameSet) throws PolicyException {
        Iterator dnsNames = dnsNameSet.iterator();
        while (dnsNames.hasNext()) {
            String dnsName = (String)dnsNames.next();
            this.validateDnsName(dnsName);
            this.dnsList.add(dnsName.toLowerCase());
        }
    }

    private long stringToIp(String ip) throws PolicyException {
        StringTokenizer st = new StringTokenizer(ip, ".");
        int tokenCount = st.countTokens();
        if (tokenCount != 4) {
            Object[] args = new String[]{"ip", ip};
            throw new PolicyException("amPolicy", "invalid_property_value", args, null);
        }
        long ipValue = 0L;
        while (st.hasMoreElements()) {
            String s = st.nextToken();
            short ipElement = 0;
            try {
                ipElement = Short.parseShort(s);
            }
            catch (Exception e) {
                Object[] args = new String[]{"ip", ip};
                throw new PolicyException("amPolicy", "invalid_property_value", args, null);
            }
            if (ipElement < 0 || ipElement > 255) {
                Object[] args = new String[]{"ipElement", s};
                throw new PolicyException("amPolicy", "invalid_property_value", args, null);
            }
            ipValue = ipValue * 256L + (long)ipElement;
        }
        return ipValue;
    }

    private void validateDnsName(String dnsName) throws PolicyException {
        int starIndex = dnsName.indexOf("*");
        if (!(starIndex < 0 || dnsName.equals("*") || starIndex <= 0 && (starIndex != 0 || dnsName.indexOf("*", 1) == -1 && dnsName.charAt(1) == '.'))) {
            Object[] args = new String[]{"DnsName", dnsName};
            throw new PolicyException("amPolicy", "invalid_property_value", args, null);
        }
    }

    private boolean isAllowedByIp(String ip) throws PolicyException {
        boolean allowed = false;
        long requestIp = this.stringToIp(ip);
        Iterator ipValues = this.ipList.iterator();
        while (ipValues.hasNext()) {
            long startIp = (Long)ipValues.next();
            if (!ipValues.hasNext()) continue;
            long endIp = (Long)ipValues.next();
            if (requestIp < startIp || requestIp > endIp) continue;
            allowed = true;
            break;
        }
        if (requestIp >= this.startIp && requestIp <= this.endIp) {
            allowed = true;
        }
        return allowed;
    }

    private boolean isAllowedByDns(String dnsName) throws PolicyException {
        boolean allowed = false;
        dnsName = dnsName.toLowerCase();
        Iterator dnsNames = this.dnsList.iterator();
        while (dnsNames.hasNext()) {
            String dnsPattern = (String)dnsNames.next();
            if (dnsPattern.equals("*")) {
                allowed = true;
                break;
            }
            int starIndex = dnsPattern.indexOf("*");
            if (starIndex != -1) {
                String dnsWildSuffix = dnsPattern.substring(1);
                if (!dnsName.endsWith(dnsWildSuffix)) continue;
                allowed = true;
                break;
            }
            if (!dnsPattern.equalsIgnoreCase(dnsName)) continue;
            allowed = true;
            break;
        }
        return allowed;
    }

    static {
        propertyNames.add("StartIp");
        propertyNames.add("EndIp");
        propertyNames.add("DnsName");
    }
}

