/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sae.api;

import com.sun.identity.shared.encode.Base64;
import java.io.FileInputStream;
import java.io.UnsupportedEncodingException;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeMap;

public class SecureAttrs {
    public static final String SAE_PARAM_DATA = "sun.data";
    public static final String SAE_PARAM_CMD = "sun.cmd";
    public static final String SAE_PARAM_USERID = "sun.userid";
    public static final String SAE_PARAM_AUTHLEVEL = "sun.authlevel";
    public static final String SAE_PARAM_IDPENTITYID = "sun.idpentityid";
    public static final String SAE_PARAM_SPENTITYID = "sun.spentityid";
    public static final String SAE_PARAM_SPAPPURL = "sun.spappurl";
    public static final String SAE_PARAM_IDPAPPURL = "sun.idpappurl";
    public static final String SAE_PARAM_APPID = "sun.appid";
    public static final String SAE_PARAM_TS = "sun.ts";
    public static final String SAE_PARAM_SIGN = "sun.sign";
    public static final String SAE_PARAM_ERROR = "sun.error";
    public static final String SAE_PARAM_APPSLORETURNURL = "sun.returnurl";
    public static final String SAE_PARAM_APPRETURN = "sun.appreturn";
    public static final String SAE_CMD_LOGOUT = "logout";
    public static final String SAE_CRYPTO_TYPE = "type";
    public static final String SAE_CRYPTO_TYPE_ASYM = "asymmetric";
    public static final String SAE_CRYPTO_TYPE_SYM = "symmetric";
    public static final String SAE_CONFIG_KEYSTORE_FILE = "keystorefile";
    public static final String SAE_CONFIG_KEYSTORE_TYPE = "keystoretype";
    public static final String SAE_CONFIG_KEYSTORE_PASS = "keystorepass";
    public static final String SAE_CONFIG_PRIVATE_KEY_ALIAS = "privatekeyalias";
    public static final String SAE_CONFIG_PUBLIC_KEY_ALIAS = "pubkeyalias";
    public static final String SAE_CONFIG_PRIVATE_KEY = "privatekey";
    public static final String SAE_CONFIG_PRIVATE_KEY_PASS = "privatekeypass";
    public static final String SAE_CONFIG_CACHE_KEYS = "cachekeys";
    public static final String SAE_CONFIG_SHARED_SECRET = "secret";
    public static final String SAE_CONFIG_SIG_VALIDITY_DURATION = "saesigvalidityduration";
    public static boolean dbg = false;
    private static Certs certs = null;
    private static boolean isServer = false;
    private static HashMap instances = new HashMap();
    private static boolean initdone = false;
    private static int tsDuration = 120000;
    private boolean asymsigning = false;

    public static synchronized SecureAttrs getInstance(String type) {
        if (instances.get(type) == null) {
            instances.put(type, new SecureAttrs(type));
        }
        return (SecureAttrs)instances.get(type);
    }

    public static synchronized void init(Properties properties) throws Exception {
        if (initdone) {
            return;
        }
        String dur = properties.getProperty(SAE_CONFIG_SIG_VALIDITY_DURATION);
        if (dur != null) {
            tsDuration = Integer.parseInt(dur);
        }
        certs = isServer ? (Certs)Class.forName("com.sun.identity.sae.api.FMCerts").newInstance() : new DefaultCerts();
        certs.init(properties);
        initdone = true;
    }

    public static boolean isInitialized() {
        return initdone;
    }

    public String getEncodedString(Map attrs, String secret) throws Exception {
        if (attrs == null || attrs.isEmpty()) {
            return null;
        }
        StringBuffer sb = new StringBuffer(200);
        Iterator iter = attrs.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            sb.append(key).append("=").append(value).append("|");
        }
        sb.append("Signature=").append(this.getSignedString(attrs, secret));
        return Base64.encode(sb.toString().getBytes("UTF-8"));
    }

    public Map verifyEncodedString(String str, String secret) throws Exception {
        String signatureValue;
        if (str == null) {
            return null;
        }
        Map map = this.getRawAttributesFromEncodedData(str);
        if (!this.verifyAttrs(map, signatureValue = (String)map.remove("Signature"), secret)) {
            return null;
        }
        return map;
    }

    public Map getRawAttributesFromEncodedData(String str) throws Exception {
        if (str == null) {
            return null;
        }
        byte[] bytes = Base64.decode(str);
        String decoded = new String(bytes);
        if (decoded.indexOf("|") == -1) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(decoded, "|");
        HashMap<String, String> map = new HashMap<String, String>();
        while (tokenizer.hasMoreTokens()) {
            String st = tokenizer.nextToken();
            int index = st.indexOf("=");
            if (index == -1) continue;
            String attr = st.substring(0, index);
            String value = st.substring(index + 1, st.length());
            map.put(attr, value);
        }
        return map;
    }

    public static void setPrivateKey(PrivateKey privatekey) {
        certs.setPrivatekey(privatekey);
    }

    public static void addPublicKey(String pubkeyalias, X509Certificate x509certificate) {
        certs.addPublicKey(pubkeyalias, x509certificate);
    }

    public static void setServerFlag(boolean flag) {
        isServer = flag;
    }

    private static X509Certificate getPublicKey(String alias) {
        return certs.getPublicKey(alias);
    }

    public String getSignedString(Map attrs, String secret) throws Exception {
        StringBuffer str = this.normalize(attrs);
        long timestamp = new Date().getTime();
        String signature = null;
        if (this.asymsigning) {
            PrivateKey pKey = certs.getPrivateKey(secret);
            signature = this.signAsym(str.append(timestamp).toString(), pKey);
        } else {
            String seed = secret + timestamp;
            signature = this.encrypt(str + seed, seed);
        }
        if (signature == null) {
            return null;
        }
        return "TS" + timestamp + "TS" + signature;
    }

    public boolean verifyAttrs(Map attrs, String token, String secret) throws Exception {
        StringBuffer str = this.normalize(attrs);
        int idx = token.indexOf("TS", 2);
        String ts = token.substring(2, idx);
        long signts = Long.parseLong(ts);
        long nowts = new Date().getTime();
        if (nowts - signts > (long)tsDuration) {
            return false;
        }
        if (this.asymsigning) {
            String signature = token.substring(idx + 2, token.length());
            return SecureAttrs.verifyAsym(str.append(ts).toString(), signature, SecureAttrs.getPublicKey(secret));
        }
        String seed = secret + ts;
        String newstr = "TS" + ts + "TS" + this.encrypt(str + seed, seed);
        return token.equals(newstr);
    }

    private SecureAttrs(String type) {
        if (SAE_CRYPTO_TYPE_ASYM.equals(type)) {
            this.asymsigning = true;
        }
    }

    private StringBuffer normalize(Map attrs) {
        TreeMap smap = new TreeMap(attrs);
        StringBuffer str = new StringBuffer();
        Iterator iter = smap.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            str.append(key).append("=").append(smap.get(key)).append("|");
        }
        return str;
    }

    private synchronized String encrypt(String plaintext, String seed) throws Exception {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException e) {
            throw new Exception(e.getMessage());
        }
        try {
            md.update(plaintext.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new Exception(e.getMessage());
        }
        byte[] raw = md.digest();
        String hash = Base64.encode(raw);
        return hash;
    }

    private String signAsym(String s, PrivateKey privatekey) {
        if (s == null || s.length() == 0 || privatekey == null) {
            if (dbg) {
                System.out.println("SAE : signAsym: returning since priv key null");
            }
            return null;
        }
        String s1 = privatekey.getAlgorithm();
        Signature signature = null;
        Object obj = null;
        if (s1.equals("RSA")) {
            try {
                signature = Signature.getInstance("SHA1withRSA");
                String s2 = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
            }
            catch (Exception exception) {
                System.out.println("SAE:asym sign : RSA failed =" + exception);
                return null;
            }
        } else if (s1.equals("DSA")) {
            try {
                signature = Signature.getInstance("SHA1withDSA");
                String s3 = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
            }
            catch (Exception exception1) {
                System.out.println("SAE:asym sign : DSA failed =" + exception1);
                return null;
            }
        } else {
            System.out.println("SAE:asym sign : No Algorithm");
            return null;
        }
        try {
            signature.initSign(privatekey);
        }
        catch (Exception exception2) {
            System.out.println("SAE:asym sign : sig.initSign failed" + exception2);
            return null;
        }
        try {
            System.out.println("Query str:" + s);
            signature.update(s.getBytes());
        }
        catch (Exception exception3) {
            System.out.println("SAE:asym sign : sig.update failed" + exception3);
            return null;
        }
        byte[] abyte0 = null;
        try {
            abyte0 = signature.sign();
        }
        catch (Exception exception4) {
            System.out.println("SAE:asym sign : sig.sign failed" + exception4);
            return null;
        }
        if (abyte0 == null || abyte0.length == 0) {
            System.out.println("SAE:asym sign : sigBytes null");
            return null;
        }
        String s4 = Base64.encode(abyte0);
        System.out.println("B64 Signature=" + s4);
        return s4;
    }

    private static boolean verifyAsym(String s, String s1, X509Certificate x509certificate) {
        if (s == null || s.length() == 0 || x509certificate == null || s1 == null) {
            if (dbg) {
                System.out.println("SAE:asym verify: qstring or cert or signature is null");
            }
            return false;
        }
        byte[] abyte0 = Base64.decode(s1);
        System.out.println("SAE:verifyAsym:signature=" + abyte0 + " origstr=" + s1);
        Object obj = null;
        Object obj1 = null;
        String s2 = x509certificate.getPublicKey().getAlgorithm();
        Signature signature = null;
        if (s2.equals("DSA")) {
            try {
                signature = Signature.getInstance("SHA1withDSA");
            }
            catch (Exception exception) {
                System.out.println("SAE:asym verify : DSA instance" + exception);
                exception.printStackTrace();
                return false;
            }
        } else if (s2.equals("RSA")) {
            try {
                signature = Signature.getInstance("SHA1withRSA");
            }
            catch (Exception exception1) {
                System.out.println("SAE:asym verify : RSA instance" + exception1);
                exception1.printStackTrace();
                return false;
            }
        } else {
            System.out.println("SAE:asym verify : no instance");
            return false;
        }
        try {
            signature.initVerify(x509certificate);
        }
        catch (Exception exception2) {
            System.out.println("SAE:asym verify :sig.initVerify" + exception2);
            exception2.printStackTrace();
            return false;
        }
        try {
            signature.update(s.getBytes());
        }
        catch (Exception exception3) {
            System.out.println("SAE:asym verify :sig.update:" + exception3 + " sig=" + abyte0);
            exception3.printStackTrace();
            return false;
        }
        boolean flag = false;
        try {
            flag = signature.verify(abyte0);
        }
        catch (Exception exception4) {
            System.out.println("SAE:asym verify :sig.verify:" + exception4 + "sig=" + abyte0);
            exception4.printStackTrace();
            return false;
        }
        return flag;
    }

    public static void main(String[] args) {
        try {
            Properties properties = new Properties();
            properties.setProperty(SAE_CONFIG_KEYSTORE_FILE, "mykeystore");
            properties.setProperty(SAE_CONFIG_KEYSTORE_TYPE, "JKS");
            properties.setProperty(SAE_CONFIG_KEYSTORE_PASS, "22222222");
            properties.setProperty(SAE_CONFIG_PRIVATE_KEY_ALIAS, "testcert");
            properties.setProperty("publickeyalias", "testcert");
            properties.setProperty(SAE_CONFIG_PRIVATE_KEY_PASS, "11111111");
            SecureAttrs.init(properties);
            System.out.println("TEST 1 START test encoded str ===========");
            SecureAttrs secureattrs = SecureAttrs.getInstance(SAE_CRYPTO_TYPE_SYM);
            String s = "YnJhbmNoPTAwNXxtYWlsPXVzZXI1QG1haWwuY29tfHN1bi51c2VyaWQ9dXNlcjV8U2lnbmF0dXJlPVRTMTE3NDI3ODY1OTM2NlRTbzI2MkhoL3R1dDRJc0U1V3ZqWjVSLzZkM0FzPQ==";
            Map map = secureattrs.verifyEncodedString(s, SAE_CONFIG_SHARED_SECRET);
            if (map == null) {
                System.out.println("    FAILED");
            } else {
                System.out.println("    PASSED" + map);
            }
            System.out.println("TEST 1 END ================");
            System.out.println("TEST 2 START : encode followed by decode ===");
            HashMap<String, String> hashmap = new HashMap<String, String>();
            hashmap.put("branch", "bb");
            hashmap.put("mail", "mm");
            hashmap.put(SAE_PARAM_USERID, "uu");
            hashmap.put(SAE_PARAM_SPAPPURL, "apapp");
            System.out.println("  TEST 2a START : SYM KEY ===");
            secureattrs = SecureAttrs.getInstance(SAE_CRYPTO_TYPE_SYM);
            String s1 = SAE_CONFIG_SHARED_SECRET;
            String s2 = secureattrs.getEncodedString(hashmap, s1);
            System.out.println("Encoded string: " + s2);
            Map map1 = secureattrs.verifyEncodedString(s2, s1);
            if (map1 != null) {
                System.out.println("  2a PASSED " + map1);
            } else {
                System.out.println("  2a FAILED " + map1);
            }
            System.out.println("  TEST 2b START : ASYM KEY ===");
            secureattrs = SecureAttrs.getInstance(SAE_CRYPTO_TYPE_ASYM);
            s1 = "testcert";
            String s3 = secureattrs.getEncodedString(hashmap, s1);
            System.out.println("Encoded string: " + s3);
            map1 = secureattrs.verifyEncodedString(s3, s1);
            if (map1 != null) {
                System.out.println("  2b PASSED " + map1);
            } else {
                System.out.println("  2b FAILED " + map1);
            }
            System.out.println("TEST 2 END  ====================");
            System.out.println("TEST 3 START : decode with incorrect secret");
            System.out.println("  TEST 3a START : SYM KEY ===");
            secureattrs = SecureAttrs.getInstance(SAE_CRYPTO_TYPE_SYM);
            map1 = secureattrs.verifyEncodedString(s2, "junk");
            if (map1 != null) {
                System.out.println("  3a FAILED " + map1);
            } else {
                System.out.println("  3a PASSED " + map1);
            }
            System.out.println("  TEST 3b START : ASYM KEY ===");
            secureattrs = SecureAttrs.getInstance(SAE_CRYPTO_TYPE_ASYM);
            map1 = secureattrs.verifyEncodedString(s3, "junk");
            if (map1 != null) {
                System.out.println("  3b FAILED " + map1);
            } else {
                System.out.println("  3b PASSED " + map1);
            }
            System.out.println("TEST 3 END  ====================");
            System.out.println("TEST 4 START : decode with correct secret");
            System.out.println("  TEST 4a START : SYM KEY ===");
            secureattrs = SecureAttrs.getInstance(SAE_CRYPTO_TYPE_SYM);
            s1 = SAE_CONFIG_SHARED_SECRET;
            map1 = secureattrs.verifyEncodedString(s2, s1);
            if (map1 != null) {
                System.out.println("  4a PASSED " + map1);
            } else {
                System.out.println("  4a FAILED " + map1);
            }
            System.out.println("  TEST 4b START : ASYM KEY ===");
            secureattrs = SecureAttrs.getInstance(SAE_CRYPTO_TYPE_ASYM);
            s1 = "testcert";
            map1 = secureattrs.verifyEncodedString(s3, s1);
            if (map1 != null) {
                System.out.println("  4a PASSED " + map1);
            } else {
                System.out.println("  4a FAILED " + map1);
            }
            System.out.println("TEST 4 END  ====================");
        }
        catch (Exception exception) {
            System.out.println("TEST Exc : " + exception);
        }
    }

    static class DefaultCerts
    implements Certs {
        private PrivateKey privateKey = null;
        private KeyStore ks = null;
        private String keystoreFile = "";
        private HashMap keyTable = new HashMap();
        private boolean cacheKeys = true;
        private String pkpass = null;

        DefaultCerts() {
        }

        public void init(Properties properties) throws Exception {
            String keyfile = properties.getProperty(SecureAttrs.SAE_CONFIG_KEYSTORE_FILE);
            if (keyfile != null) {
                String ktype = properties.getProperty(SecureAttrs.SAE_CONFIG_KEYSTORE_TYPE, "JKS");
                this.ks = KeyStore.getInstance(ktype);
                FileInputStream fileinputstream = new FileInputStream(keyfile);
                String kpass = properties.getProperty(SecureAttrs.SAE_CONFIG_KEYSTORE_PASS);
                this.pkpass = properties.getProperty(SecureAttrs.SAE_CONFIG_PRIVATE_KEY_PASS);
                this.ks.load(fileinputstream, kpass.toCharArray());
                String pkeyalias = properties.getProperty(SecureAttrs.SAE_CONFIG_PRIVATE_KEY_ALIAS);
                if (pkeyalias != null) {
                    this.privateKey = (PrivateKey)this.ks.getKey(pkeyalias, this.pkpass.toCharArray());
                }
                String pubkeyalias = properties.getProperty(SecureAttrs.SAE_CONFIG_PUBLIC_KEY_ALIAS);
                if ("false".equals(properties.getProperty(SecureAttrs.SAE_CONFIG_CACHE_KEYS))) {
                    this.cacheKeys = false;
                }
                if (this.cacheKeys && pubkeyalias != null) {
                    this.getPublicKeyFromKeystore(pubkeyalias);
                }
            }
        }

        public PrivateKey getPrivateKey(String alias) {
            try {
                if (alias == null) {
                    return this.privateKey;
                }
                return (PrivateKey)this.ks.getKey(alias, this.pkpass.toCharArray());
            }
            catch (Exception ex) {
                return null;
            }
        }

        public X509Certificate getPublicKey(String alias) {
            X509Certificate x509certificate = (X509Certificate)this.keyTable.get(alias);
            if (x509certificate == null && this.ks != null) {
                try {
                    x509certificate = this.getPublicKeyFromKeystore(alias);
                }
                catch (Exception exception) {
                    System.out.println("SAE:getPublicKey:Exc:" + exception);
                }
            }
            return x509certificate;
        }

        public void setPrivatekey(PrivateKey privatekey) {
            this.privateKey = privatekey;
        }

        public void addPublicKey(String pubkeyalias, X509Certificate x509certificate) {
            this.keyTable.put(pubkeyalias, x509certificate);
        }

        private X509Certificate getPublicKeyFromKeystore(String pubkeyalias) throws Exception {
            X509Certificate x509certificate = (X509Certificate)this.ks.getCertificate(pubkeyalias);
            if (this.cacheKeys) {
                this.keyTable.put(pubkeyalias, x509certificate);
            }
            return x509certificate;
        }
    }

    public static interface Certs {
        public void init(Properties var1) throws Exception;

        public PrivateKey getPrivateKey(String var1);

        public X509Certificate getPublicKey(String var1);

        public void setPrivatekey(PrivateKey var1);

        public void addPublicKey(String var1, X509Certificate var2);
    }
}

