/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml.assertion;

import com.sun.identity.saml.common.SAMLConstants;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLRequesterException;
import com.sun.identity.saml.common.SAMLUtilsCommon;
import com.sun.identity.shared.xml.XMLUtils;
import org.w3c.dom.Element;

public class NameIdentifier {
    static SAMLConstants sc;
    private String _nameQualifier = "";
    private String _format = "";
    private String _name = "";

    protected NameIdentifier() {
    }

    public NameIdentifier(Element nameIdentifierElement) throws SAMLException {
        Element elt = nameIdentifierElement;
        String eltName = elt.getLocalName();
        if (eltName == null) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("NameIdentifier: local name missing");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("nullInput"));
        }
        if (!eltName.equals("NameIdentifier")) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("NameIdentifier: invalid root element");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("invalidElement"));
        }
        String read = elt.getAttribute("NameQualifier");
        if (read != null) {
            this._nameQualifier = read;
        }
        if ((read = elt.getAttribute("Format")) != null) {
            this._format = read;
        }
        if ((read = XMLUtils.getElementValue(elt)) == null || read.length() == 0) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("NameIdentifier: null input specified");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("nullInput"));
        }
        this._name = read;
    }

    public NameIdentifier(String name) throws SAMLException {
        if (name == null || name.length() == 0) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("NameIdentifier: null input specified");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("nullInput"));
        }
        this._name = name;
    }

    public NameIdentifier(String name, String nameQualifier) throws SAMLException {
        if (name == null || name.length() == 0) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("NameIdentifier: null input specified");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("nullInput"));
        }
        if (nameQualifier != null) {
            this._nameQualifier = nameQualifier;
        }
        this._name = name;
    }

    public NameIdentifier(String name, String nameQualifier, String format) throws SAMLException {
        if (name == null || name.length() == 0) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("NameIdentifier: null input specified");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("nullInput"));
        }
        this._nameQualifier = nameQualifier == null ? "" : nameQualifier;
        this._format = format == null ? "" : format;
        this._name = name;
    }

    public String getFormat() {
        return this._format;
    }

    public boolean setFormat(String format) {
        if (format == null || format.length() == 0) {
            return false;
        }
        this._format = format;
        return true;
    }

    public String getNameQualifier() {
        return this._nameQualifier;
    }

    public boolean setNameQualifier(String nameQualifier) {
        if (nameQualifier == null || nameQualifier.length() == 0) {
            return false;
        }
        this._nameQualifier = nameQualifier;
        return true;
    }

    protected boolean setName(String name) {
        if (name == null || name.length() == 0) {
            return false;
        }
        this._name = name;
        return true;
    }

    public String getName() {
        return this._name;
    }

    public String toString() {
        String xml = this.toString(true, false);
        return xml;
    }

    public String toString(boolean includeNS, boolean declareNS) {
        StringBuffer xml = new StringBuffer(3000);
        String NS = "";
        String appendNS = "";
        if (declareNS) {
            NS = " xmlns:saml=\"urn:oasis:names:tc:SAML:1.0:assertion\"";
        }
        if (includeNS) {
            appendNS = "saml:";
        }
        xml.append("<").append(appendNS).append("NameIdentifier").append(NS);
        if (this._nameQualifier != null && this._nameQualifier.length() != 0) {
            xml.append(" ").append("NameQualifier").append("=\"").append(this._nameQualifier).append("\"");
        }
        if (this._format != null && this._format.length() != 0) {
            xml.append(" ").append("Format").append("=\"").append(this._format).append("\"");
        }
        xml.append(">").append(this._name);
        xml.append(SAMLUtilsCommon.makeEndElementTagXML("NameIdentifier", includeNS));
        return xml.toString();
    }

    public boolean equals(NameIdentifier nid) {
        if (nid != null) {
            String name = nid.getName();
            String nameQualifier = nid.getNameQualifier();
            String format = nid.getFormat();
            if (name.length() == 0 || !name.equalsIgnoreCase(this._name)) {
                return false;
            }
            if (!nameQualifier.equalsIgnoreCase(this._nameQualifier)) {
                return false;
            }
            return format.equals(this._format);
        }
        return false;
    }
}

