/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml2.xmlsig;

import com.sun.identity.saml.xmlsig.OfflineResolver;
import com.sun.identity.saml2.common.SAML2Exception;
import com.sun.identity.saml2.common.SAML2SDKUtils;
import com.sun.identity.saml2.common.SAML2Utils;
import com.sun.identity.saml2.xmlsig.SigProvider;
import com.sun.identity.shared.configuration.SystemPropertiesManager;
import com.sun.org.apache.xml.internal.security.Init;
import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.keys.KeyInfo;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolverException;
import com.sun.org.apache.xml.internal.security.signature.XMLSignature;
import com.sun.org.apache.xml.internal.security.signature.XMLSignatureException;
import com.sun.org.apache.xml.internal.security.transforms.TransformationException;
import com.sun.org.apache.xml.internal.security.transforms.Transforms;
import com.sun.org.apache.xml.internal.security.utils.Constants;
import com.sun.org.apache.xml.internal.security.utils.IdResolver;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import com.sun.org.apache.xpath.internal.XPathAPI;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class FMSigProvider
implements SigProvider {
    private static String c14nMethod = null;
    private static String transformAlg = null;
    private static String sigAlg = null;
    private static boolean checkCert = true;

    public Element sign(String xmlString, String idValue, PrivateKey privateKey, X509Certificate cert) throws SAML2Exception {
        Node firstChild;
        String classMethod = "FMSigProvider.sign: ";
        if (xmlString == null || xmlString.length() == 0 || idValue == null || idValue.length() == 0 || privateKey == null) {
            SAML2SDKUtils.debug.error(classMethod + "Either input xml string or id value or " + "private key is null.");
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("nullInput"));
        }
        Document doc = com.sun.identity.shared.xml.XMLUtils.toDOMDocument(xmlString, SAML2SDKUtils.debug);
        if (doc == null) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("errorObtainingElement"));
        }
        Element root = doc.getDocumentElement();
        XMLSignature sig = null;
        try {
            Constants.setSignatureSpecNSprefix((String)"");
        }
        catch (XMLSecurityException xse1) {
            throw new SAML2Exception(xse1);
        }
        IdResolver.registerElementById((Element)root, (String)idValue);
        try {
            if (sigAlg == null || sigAlg.trim().length() == 0) {
                if (privateKey.getAlgorithm().equalsIgnoreCase("DSA")) {
                    sigAlg = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
                } else if (privateKey.getAlgorithm().equalsIgnoreCase("RSA")) {
                    sigAlg = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
                }
            }
            sig = new XMLSignature(doc, "", sigAlg, c14nMethod);
        }
        catch (XMLSecurityException xse2) {
            throw new SAML2Exception(xse2);
        }
        for (firstChild = root.getFirstChild(); !(firstChild == null || firstChild.getLocalName() != null && firstChild.getLocalName().equals("Issuer")); firstChild = firstChild.getNextSibling()) {
        }
        Node nextSibling = null;
        if (firstChild != null) {
            nextSibling = firstChild.getNextSibling();
        }
        if (nextSibling == null) {
            root.appendChild(sig.getElement());
        } else {
            root.insertBefore(sig.getElement(), nextSibling);
        }
        sig.getSignedInfo().addResourceResolver(new OfflineResolver());
        Transforms transforms = new Transforms(doc);
        try {
            transforms.addTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature");
        }
        catch (TransformationException te1) {
            throw new SAML2Exception(te1);
        }
        try {
            transforms.addTransform(transformAlg);
        }
        catch (TransformationException te2) {
            throw new SAML2Exception(te2);
        }
        String ref = "#" + idValue;
        try {
            sig.addDocument(ref, transforms, "http://www.w3.org/2000/09/xmldsig#sha1");
        }
        catch (XMLSignatureException sige1) {
            throw new SAML2Exception(sige1);
        }
        if (cert != null) {
            try {
                sig.addKeyInfo(cert);
            }
            catch (XMLSecurityException xse3) {
                throw new SAML2Exception(xse3);
            }
        }
        try {
            sig.sign(privateKey);
        }
        catch (XMLSignatureException sige2) {
            throw new SAML2Exception(sige2);
        }
        if (SAML2SDKUtils.debug.messageEnabled()) {
            SAML2SDKUtils.debug.message(classMethod + "Signing is successful.");
        }
        return sig.getElement();
    }

    public boolean verify(String xmlString, String idValue, X509Certificate senderCert) throws SAML2Exception {
        boolean certgood;
        String classMethod = "FMSigProvider.verify: ";
        if (xmlString == null || xmlString.length() == 0 || idValue == null || idValue.length() == 0) {
            SAML2SDKUtils.debug.error(classMethod + "Either input xmlString or idValue is null.");
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("nullInput"));
        }
        Document doc = com.sun.identity.shared.xml.XMLUtils.toDOMDocument(xmlString, SAML2SDKUtils.debug);
        if (doc == null) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("errorObtainingElement"));
        }
        Element nscontext = XMLUtils.createDSctx((Document)doc, (String)"ds", (String)"http://www.w3.org/2000/09/xmldsig#");
        Element sigElement = null;
        try {
            sigElement = (Element)XPathAPI.selectSingleNode(doc, "//ds:Signature[1]", nscontext);
        }
        catch (TransformerException te) {
            throw new SAML2Exception(te);
        }
        IdResolver.registerElementById((Element)doc.getDocumentElement(), (String)idValue);
        XMLSignature signature = null;
        try {
            signature = new XMLSignature(sigElement, "");
        }
        catch (XMLSignatureException sige) {
            throw new SAML2Exception(sige);
        }
        catch (XMLSecurityException xse) {
            throw new SAML2Exception(xse);
        }
        signature.addResourceResolver(new OfflineResolver());
        KeyInfo ki = signature.getKeyInfo();
        X509Certificate certToUse = null;
        if (ki != null && ki.containsX509Data()) {
            try {
                certToUse = ki.getX509Certificate();
            }
            catch (KeyResolverException kre) {
                SAML2SDKUtils.debug.error(classMethod + "Could not obtain a certificate " + "from inside the document.");
                certToUse = null;
            }
            if (certToUse != null && checkCert) {
                if (!certToUse.equals(senderCert)) {
                    SAML2SDKUtils.debug.error(classMethod + "The cert contained in the document " + "is NOT the same as the one being " + "passed in.");
                    throw new SAML2Exception(SAML2SDKUtils.bundle.getString("invalidCertificate"));
                }
                if (SAML2SDKUtils.debug.messageEnabled()) {
                    SAML2SDKUtils.debug.message(classMethod + "The cert contained in the document " + "is the same as the one being " + "passed in.");
                }
            }
        }
        if (certToUse == null) {
            certToUse = senderCert;
        }
        if (!(certgood = SAML2Utils.validateCertificate((X509Certificate)certToUse))) {
            SAML2SDKUtils.debug.error(classMethod + "Signing Certificate is validated as bad.");
            return false;
        }
        boolean result = false;
        try {
            result = signature.checkSignatureValue(certToUse);
        }
        catch (XMLSignatureException xse) {
            throw new SAML2Exception(xse);
        }
        if (!result) {
            SAML2SDKUtils.debug.error(classMethod + "Signature verification failed.");
            return false;
        }
        if (SAML2SDKUtils.debug.messageEnabled()) {
            SAML2SDKUtils.debug.message(classMethod + "Signature verification successful.");
        }
        return true;
    }

    static {
        Init.init();
        c14nMethod = SystemPropertiesManager.get("com.sun.identity.saml.xmlsig.c14nMethod", "http://www.w3.org/2001/10/xml-exc-c14n#");
        transformAlg = SystemPropertiesManager.get("com.sun.identity.saml.xmlsig.transformAlg", "http://www.w3.org/2001/10/xml-exc-c14n#");
        sigAlg = SystemPropertiesManager.get("com.sun.identity.saml.xmlsig.xmlSigAlgorithm");
        String valCert = SystemPropertiesManager.get("com.sun.identity.saml.checkcert", "on");
        if (valCert != null && valCert.trim().equalsIgnoreCase("off")) {
            checkCert = false;
        }
    }
}

