/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.xacml.context.impl;

import com.sun.identity.shared.xml.XMLUtils;
import com.sun.identity.xacml.common.XACMLConstants;
import com.sun.identity.xacml.common.XACMLException;
import com.sun.identity.xacml.common.XACMLSDKUtils;
import com.sun.identity.xacml.context.Action;
import com.sun.identity.xacml.context.Attribute;
import com.sun.identity.xacml.context.ContextFactory;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ActionImpl
implements Action {
    private List attributes;
    private boolean mutable = true;

    public ActionImpl() {
    }

    public ActionImpl(String xml) throws XACMLException {
        Document document = XMLUtils.toDOMDocument(xml, XACMLSDKUtils.debug);
        if (document == null) {
            XACMLSDKUtils.debug.error("ActionImpl.processElement(): invalid XML input");
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("errorObtainingElement"));
        }
        Element rootElement = document.getDocumentElement();
        this.processElement(rootElement);
        this.makeImmutable();
    }

    public ActionImpl(Element element) throws XACMLException {
        this.processElement(element);
        this.makeImmutable();
    }

    private void processElement(Element element) throws XACMLException {
        if (element == null) {
            XACMLSDKUtils.debug.error("ActionImpl.processElement(): invalid root element");
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("invalid_element"));
        }
        String elemName = element.getLocalName();
        if (elemName == null) {
            XACMLSDKUtils.debug.error("ActionImpl.processElement(): local name missing");
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("missing_local_name"));
        }
        if (!elemName.equals(XACMLConstants.ACTION)) {
            XACMLSDKUtils.debug.error("ActionImpl.processElement(): invalid local name " + elemName);
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("invalid_local_name"));
        }
        NodeList nodes = element.getChildNodes();
        int numOfNodes = nodes.getLength();
        if (numOfNodes >= 1) {
            ContextFactory factory = ContextFactory.getInstance();
            for (int nextElem = 0; nextElem < numOfNodes; ++nextElem) {
                Node child = nodes.item(nextElem);
                if (child.getNodeType() != 1) continue;
                String attrChildName = child.getLocalName();
                if (attrChildName.equals(XACMLConstants.ATTRIBUTE)) {
                    if (this.attributes == null) {
                        this.attributes = new ArrayList();
                    }
                    Attribute attribute = factory.getInstance().createAttribute((Element)child);
                    this.attributes.add(attribute);
                    continue;
                }
                XACMLSDKUtils.debug.error("ActionImpl.processElement(): Invalid element :" + attrChildName);
                throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("invalid_element"));
            }
        }
    }

    public List getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List attributes) throws XACMLException {
        if (!this.mutable) {
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("objectImmutable"));
        }
        if (attributes != null && !attributes.isEmpty()) {
            if (this.attributes == null) {
                this.attributes = new ArrayList();
            }
            this.attributes.addAll(attributes);
        }
    }

    public String toXMLString(boolean includeNSPrefix, boolean declareNS) throws XACMLException {
        StringBuffer sb = new StringBuffer(2000);
        StringBuffer namespaceBuffer = new StringBuffer(100);
        String nsDeclaration = "";
        if (declareNS) {
            namespaceBuffer.append(XACMLConstants.CONTEXT_NS_DECLARATION).append(XACMLConstants.SPACE);
            namespaceBuffer.append(XACMLConstants.XSI_NS_URI).append(XACMLConstants.SPACE).append(XACMLConstants.CONTEXT_SCHEMA_LOCATION);
        }
        if (includeNSPrefix) {
            nsDeclaration = XACMLConstants.CONTEXT_NS_PREFIX + ":";
        }
        sb.append("<").append(nsDeclaration).append(XACMLConstants.ACTION).append(namespaceBuffer);
        sb.append(">");
        int length = 0;
        if (this.attributes != null) {
            sb.append("\n");
            length = this.attributes.size();
            for (int i = 0; i < length; ++i) {
                Attribute attr = (Attribute)this.attributes.get(i);
                sb.append(attr.toXMLString(includeNSPrefix, false));
            }
        }
        sb.append("</").append(nsDeclaration).append(XACMLConstants.ACTION);
        sb.append(">\n");
        return sb.toString();
    }

    public String toXMLString() throws XACMLException {
        return this.toXMLString(true, false);
    }

    public void makeImmutable() {
        this.mutable = false;
    }

    public boolean isMutable() {
        return this.mutable;
    }
}

