/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.juddi.config.AppConfig;
import org.apache.juddi.query.util.DynamicQuery;
import org.apache.log4j.Logger;
import org.uddi.api_v3.ListDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EntityQuery {
    private static Logger log = Logger.getLogger(EntityQuery.class);
    public static final String KEY_NAME = "entityKey";
    public static final int DEFAULT_MAXROWS = 1000;
    public static final int DEFAULT_MAXINCLAUSE = 1000;

    public static String buildAlias(String entityName) {
        if (entityName == null || entityName.length() == 0) {
            return "x";
        }
        return entityName.substring(0, entityName.length() - 3) + "_";
    }

    public static List<?> getPagedResult(EntityManager em, DynamicQuery dynamicQry, Integer maxRowsUser, Integer listHead, ListDescription listDesc) {
        int startIndex;
        int maxRows = 1000;
        try {
            maxRows = AppConfig.getConfiguration().getInteger("juddi.maxRows", Integer.valueOf(1000));
        }
        catch (ConfigurationException ce) {
            log.error((Object)"Configuration exception occurred retrieving: juddi.maxRows");
        }
        if (maxRowsUser != null && maxRowsUser > 0 && maxRowsUser < maxRows) {
            maxRows = maxRowsUser;
        }
        if (listHead == null || listHead <= 0) {
            listHead = 1;
        }
        Query qry = dynamicQry.buildJPAQuery(em);
        List result = qry.getResultList();
        int resultSize = result.size();
        if (listDesc != null) {
            listDesc.setActualCount(resultSize);
            listDesc.setListHead(listHead.intValue());
        }
        if ((startIndex = listHead - 1) >= resultSize) {
            if (listDesc != null) {
                listDesc.setIncludeCount(0);
            }
            return Collections.emptyList();
        }
        int endIndex = Math.min(startIndex + maxRows, resultSize);
        if (listDesc != null) {
            listDesc.setIncludeCount(endIndex - startIndex);
        }
        ArrayList subList = new ArrayList(endIndex);
        for (int i = startIndex; i < endIndex; ++i) {
            subList.add(result.get(i));
        }
        return subList;
    }

    public static List<?> getQueryResult(EntityManager em, DynamicQuery dynamicQry, List<?> keysIn, String inListTerm) {
        List result = new ArrayList(0);
        if (keysIn == null) {
            log.debug((Object)dynamicQry);
            Query qry = dynamicQry.buildJPAQuery(em);
            result = qry.getResultList();
        } else {
            int endIndex;
            int maxInClause = 1000;
            try {
                maxInClause = AppConfig.getConfiguration().getInteger("juddi.maxInClause", Integer.valueOf(1000));
            }
            catch (ConfigurationException ce) {
                log.error((Object)"Configuration exception occurred retrieving: juddi.maxInClause");
            }
            int startIndex = 0;
            for (int inParamsLeft = keysIn.size(); inParamsLeft > 0; inParamsLeft -= endIndex - startIndex) {
                endIndex = startIndex + Math.min(inParamsLeft, maxInClause);
                ArrayList subKeysIn = new ArrayList(endIndex);
                for (int i = startIndex; i < endIndex; ++i) {
                    subKeysIn.add(keysIn.get(i));
                }
                dynamicQry.appendInListWithAnd(inListTerm, subKeysIn);
                log.debug((Object)dynamicQry);
                Query qry = dynamicQry.buildJPAQuery(em);
                List resultChunk = qry.getResultList();
                result.addAll(resultChunk);
                startIndex = endIndex;
            }
        }
        return result;
    }
}

