/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.subscription;

import java.net.URL;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.LockModeType;
import javax.persistence.Query;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.juddi.api.impl.UDDISecurityImpl;
import org.apache.juddi.api.impl.UDDISubscriptionImpl;
import org.apache.juddi.api_v3.AccessPointType;
import org.apache.juddi.config.AppConfig;
import org.apache.juddi.config.PersistenceManager;
import org.apache.juddi.model.BindingTemplate;
import org.apache.juddi.model.Subscription;
import org.apache.juddi.model.UddiEntityPublisher;
import org.apache.juddi.subscription.TypeConvertor;
import org.apache.log4j.Logger;
import org.uddi.api_v3.AuthToken;
import org.uddi.sub_v3.CoveragePeriod;
import org.uddi.sub_v3.GetSubscriptionResults;
import org.uddi.sub_v3.SubscriptionResultsList;
import org.uddi.subr_v3.NotifySubscriptionListener;
import org.uddi.v3_service.DispositionReportFaultMessage;
import org.uddi.v3_service.UDDISubscriptionListenerPortType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubscriptionNotifier
extends TimerTask {
    private Logger log = Logger.getLogger(this.getClass());
    private Timer timer = null;
    private long startBuffer = AppConfig.getConfiguration().getLong("juddi.notification.start.buffer", 20000L);
    private long interval = AppConfig.getConfiguration().getLong("juddi.notification.interval", 300000L);
    private UDDISubscriptionImpl subscriptionImpl = new UDDISubscriptionImpl();
    private static long ACCEPTABLE_LAG_TIME = 500L;
    private static String SUBR_V3_NAMESPACE = "urn:uddi-org:v3_service";
    private static String SUBSCRIPTION_LISTENER = "UDDI_SubscriptionListener_Port";

    public SubscriptionNotifier() throws ConfigurationException {
        this.timer = new Timer(true);
        this.timer.scheduleAtFixedRate((TimerTask)this, this.startBuffer, this.interval);
    }

    @Override
    public void run() {
        if (this.firedOnTime(this.scheduledExecutionTime())) {
            long startTime = System.currentTimeMillis();
            this.log.debug((Object)"Start Notification background task; checking if subscription notifications need to be send out..");
            Collection<Subscription> subscriptions = this.getAllAsyncSubscriptions();
            for (Subscription subscription : subscriptions) {
                if (subscription.getExpiresAfter() != null && subscription.getExpiresAfter().getTime() <= startTime) continue;
                try {
                    GetSubscriptionResults getSubscriptionResults = this.buildGetSubscriptionResults(subscription, new Date(this.scheduledExecutionTime()));
                    getSubscriptionResults.setSubscriptionKey(subscription.getSubscriptionKey());
                    UddiEntityPublisher publisher = new UddiEntityPublisher();
                    publisher.setAuthorizedName(subscription.getAuthorizedName());
                    SubscriptionResultsList resultList = this.subscriptionImpl.getSubscriptionResults(getSubscriptionResults, publisher);
                    if (!this.resultListContainsChanges(resultList)) continue;
                    this.log.info((Object)"We have a change and need to notify..");
                    this.notify(getSubscriptionResults, resultList);
                }
                catch (Exception e) {
                    this.log.error((Object)("Could not obtain subscriptionResult for subscriptionKey " + subscription.getSubscriptionKey() + ". " + e.getMessage()), (Throwable)e);
                }
            }
            long endTime = System.currentTimeMillis();
            if (endTime - startTime > this.interval) {
                this.log.warn((Object)("Notification background task duration exceeds the JUDDI_NOTIFICATION_INTERVAL of " + this.interval));
                this.log.warn((Object)("Notification background task took " + (endTime - startTime) + " milliseconds."));
            } else {
                this.log.debug((Object)("Notification background task took " + (endTime - startTime) + " milliseconds."));
            }
        } else {
            this.log.warn((Object)"Skipping current notification cycle because the registry is too busy.");
        }
    }

    private boolean firedOnTime(long scheduleExecutionTime) {
        long lagTime = System.currentTimeMillis() - scheduleExecutionTime;
        if (lagTime <= ACCEPTABLE_LAG_TIME) {
            return true;
        }
        this.log.warn((Object)("NotificationTimer is lagging " + lagTime + " milli seconds behind. A lag time " + "which exceeds an acceptable lagtime of " + ACCEPTABLE_LAG_TIME + "ms indicates " + "that the registry server is under stress. We are therefore skipping this notification " + "cycle."));
        return false;
    }

    protected GetSubscriptionResults buildGetSubscriptionResults(Subscription subscription, Date endPoint) throws DispositionReportFaultMessage, DatatypeConfigurationException {
        GetSubscriptionResults getSubscriptionResults = null;
        Date startPoint = subscription.getLastNotified();
        if (startPoint == null) {
            startPoint = new Date(0L);
        }
        Duration duration = TypeConvertor.convertStringToDuration(subscription.getNotificationInterval());
        Date nextDesiredNotificationDate = new Date(startPoint.getTime());
        duration.addTo(nextDesiredNotificationDate);
        if (subscription.getLastNotified() == null || nextDesiredNotificationDate.after(startPoint) && nextDesiredNotificationDate.before(endPoint)) {
            getSubscriptionResults = new GetSubscriptionResults();
            CoveragePeriod period = new CoveragePeriod();
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTimeInMillis(startPoint.getTime());
            period.setStartPoint(DatatypeFactory.newInstance().newXMLGregorianCalendar(calendar));
            calendar.setTimeInMillis(endPoint.getTime());
            period.setEndPoint(DatatypeFactory.newInstance().newXMLGregorianCalendar(calendar));
            getSubscriptionResults.setCoveragePeriod(period);
        }
        return getSubscriptionResults;
    }

    protected boolean resultListContainsChanges(SubscriptionResultsList resultList) {
        if (resultList == null) {
            return false;
        }
        return resultList.getBindingDetail() != null || resultList.getBusinessDetail() != null || resultList.getBusinessList() != null || resultList.getServiceDetail() != null || resultList.getServiceList() != null || resultList.getTModelDetail() != null || resultList.getTModelList() != null || resultList.getRelatedBusinessesList() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection<Subscription> getAllAsyncSubscriptions() {
        List subscriptions = null;
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            Query query = em.createQuery("SELECT s FROM Subscription s WHERE s.bindingKey IS NOT NULL");
            subscriptions = query.getResultList();
            tx.commit();
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
        return subscriptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notify(GetSubscriptionResults getSubscriptionResults, SubscriptionResultsList resultList) {
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            Subscription modelSubscription = (Subscription)em.find(Subscription.class, (Object)resultList.getSubscription().getSubscriptionKey());
            this.log.debug((Object)"Taking out a write lock on this subscription, and bail if we can't get it since that would mean another jUDDI instance is in the process of sending out the notification.");
            em.lock((Object)modelSubscription, LockModeType.WRITE);
            Date startPoint = resultList.getCoveragePeriod().getStartPoint().toGregorianCalendar().getTime();
            Date endPoint = resultList.getCoveragePeriod().getEndPoint().toGregorianCalendar().getTime();
            if (modelSubscription.getLastNotified() != null && startPoint.before(modelSubscription.getLastNotified()) && endPoint.after(modelSubscription.getLastNotified())) {
                this.log.info((Object)"We already send out a notification within this coverage period, no need to send another one.");
                return;
            }
            BindingTemplate bindingTemplate = (BindingTemplate)em.find(BindingTemplate.class, (Object)modelSubscription.getBindingKey());
            NotifySubscriptionListener body = new NotifySubscriptionListener();
            if (resultList.getServiceList().getServiceInfos() != null && resultList.getServiceList().getServiceInfos().getServiceInfo().size() == 0) {
                resultList.getServiceList().setServiceInfos(null);
            }
            body.setSubscriptionResultsList(resultList);
            String authorizedName = modelSubscription.getAuthorizedName();
            UDDISecurityImpl security = new UDDISecurityImpl();
            try {
                AuthToken token = security.getAuthToken(authorizedName);
                body.setAuthInfo(token.getAuthInfo());
            }
            catch (DispositionReportFaultMessage e) {
                body.setAuthInfo("Failed to generate token, please contact UDDI admin");
                this.log.error((Object)e.getMessage(), (Throwable)e);
            }
            if (bindingTemplate != null) {
                if (AccessPointType.END_POINT.toString().equalsIgnoreCase(bindingTemplate.getAccessPointType())) {
                    QName qName = new QName(SUBR_V3_NAMESPACE, SUBSCRIPTION_LISTENER);
                    try {
                        Service service = Service.create((URL)new URL(bindingTemplate.getAccessPointUrl()), (QName)qName);
                        UDDISubscriptionListenerPortType subscriptionListenerPort = (UDDISubscriptionListenerPortType)service.getPort(UDDISubscriptionListenerPortType.class);
                        this.log.info((Object)("Sending out notification to " + bindingTemplate.getAccessPointUrl()));
                        subscriptionListenerPort.notifySubscriptionListener(body);
                        String chunkToken = body.getSubscriptionResultsList().getChunkToken();
                        while (chunkToken != null) {
                            UddiEntityPublisher publisher = new UddiEntityPublisher();
                            publisher.setAuthorizedName(modelSubscription.getAuthorizedName());
                            this.log.debug((Object)("Sending out next chunk: " + chunkToken + " to " + bindingTemplate.getAccessPointUrl()));
                            getSubscriptionResults.setChunkToken(chunkToken);
                            resultList = this.subscriptionImpl.getSubscriptionResults(getSubscriptionResults, publisher);
                            body.setSubscriptionResultsList(resultList);
                            subscriptionListenerPort.notifySubscriptionListener(body);
                            chunkToken = body.getSubscriptionResultsList().getChunkToken();
                        }
                        Date notificationDate = new Date();
                        modelSubscription.setLastNotified(notificationDate);
                        em.persist((Object)modelSubscription);
                    }
                    catch (Exception e) {
                        this.log.error((Object)e.getMessage(), (Throwable)e);
                    }
                } else {
                    this.log.error((Object)"Unsupported binding type.");
                }
            } else {
                this.log.error((Object)("There is no valid binding template defined for this subscription: " + modelSubscription.getBindingKey()));
            }
            tx.commit();
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    protected UDDISubscriptionImpl getSubscriptionImpl() {
        return this.subscriptionImpl;
    }
}

