/*
 * Decompiled with CFR 0.152.
 */
package org.drools.xml.processes;

import java.util.List;
import java.util.Map;
import org.drools.process.core.event.EventFilter;
import org.drools.process.core.event.EventTypeFilter;
import org.drools.workflow.core.Node;
import org.drools.workflow.core.node.ConstraintTrigger;
import org.drools.workflow.core.node.EventTrigger;
import org.drools.workflow.core.node.StartNode;
import org.drools.workflow.core.node.Trigger;
import org.drools.xml.XmlDumper;
import org.drools.xml.processes.AbstractNodeHandler;

public class StartNodeHandler
extends AbstractNodeHandler {
    protected Node createNode() {
        return new StartNode();
    }

    public Class generateNodeFor() {
        return StartNode.class;
    }

    public void writeNode(Node node, StringBuilder xmlDump, boolean includeMeta) {
        StartNode startNode = (StartNode)node;
        this.writeNode("start", (Node)startNode, xmlDump, includeMeta);
        List triggers = startNode.getTriggers();
        if (triggers == null || triggers.isEmpty()) {
            this.endNode(xmlDump);
        } else {
            xmlDump.append(">" + EOL);
            xmlDump.append("        <triggers>" + EOL);
            for (Trigger trigger : triggers) {
                Map inMappings;
                if (trigger instanceof ConstraintTrigger) {
                    xmlDump.append("         <trigger type=\"constraint\" >" + EOL);
                    xmlDump.append("           <constraint type=\"rule\" dialect=\"mvel\" >" + ((ConstraintTrigger)trigger).getConstraint() + "</constraint>" + EOL);
                    inMappings = trigger.getInMappings();
                    if (inMappings != null && !inMappings.isEmpty()) {
                        for (Map.Entry entry : inMappings.entrySet()) {
                            xmlDump.append("          <mapping type=\"in\" from=\"" + XmlDumper.replaceIllegalChars((String)entry.getValue()) + "\" to=\"" + (String)entry.getKey() + "\" />" + EOL);
                        }
                    }
                    xmlDump.append("         </trigger>" + EOL);
                    continue;
                }
                if (trigger instanceof EventTrigger) {
                    xmlDump.append("         <trigger type=\"event\" >" + EOL);
                    xmlDump.append("           <eventFilters>" + EOL);
                    for (EventFilter filter : ((EventTrigger)trigger).getEventFilters()) {
                        if (filter instanceof EventTypeFilter) {
                            xmlDump.append("             <eventFilter type=\"eventType\" eventType=\"" + ((EventTypeFilter)filter).getType() + "\" />" + EOL);
                            continue;
                        }
                        throw new IllegalArgumentException("Unknown filter type: " + filter);
                    }
                    xmlDump.append("           </eventFilters>" + EOL);
                    inMappings = trigger.getInMappings();
                    if (inMappings != null && !inMappings.isEmpty()) {
                        for (Map.Entry entry : inMappings.entrySet()) {
                            xmlDump.append("          <mapping type=\"in\" from=\"" + XmlDumper.replaceIllegalChars((String)entry.getValue()) + "\" to=\"" + (String)entry.getKey() + "\" />" + EOL);
                        }
                    }
                    xmlDump.append("         </trigger>" + EOL);
                    continue;
                }
                throw new IllegalArgumentException("Unknown trigger type " + trigger);
            }
            xmlDump.append("        </triggers>" + EOL);
            this.endNode("start", xmlDump);
        }
    }
}

