/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.utils;

import com.sun.org.apache.xml.internal.security.exceptions.Base64DecodingException;
import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.utils.Base64;
import com.sun.org.apache.xml.internal.security.utils.HelperNodeList;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public abstract class ElementProxy {
    static Logger log = Logger.getLogger((class$com$sun$org$apache$xml$internal$security$utils$ElementProxy == null ? (class$com$sun$org$apache$xml$internal$security$utils$ElementProxy = ElementProxy.class$("com.sun.org.apache.xml.internal.security.utils.ElementProxy")) : class$com$sun$org$apache$xml$internal$security$utils$ElementProxy).getName());
    public static final int MODE_CREATE = 0;
    public static final int MODE_PROCESS = 1;
    public static final int MODE_UNKNOWN = 2;
    public static final int MODE_SIGN = 0;
    public static final int MODE_VERIFY = 1;
    public static final int MODE_ENCRYPT = 0;
    public static final int MODE_DECRYPT = 1;
    protected int _state = 2;
    protected Element _constructionElement = null;
    protected String _baseURI = null;
    protected Document _doc = null;
    static HashMap _prefixMappings = new HashMap();
    static /* synthetic */ Class class$com$sun$org$apache$xml$internal$security$utils$ElementProxy;

    public abstract String getBaseNamespace();

    public abstract String getBaseLocalName();

    public ElementProxy() {
    }

    public ElementProxy(Document document) {
        this();
        if (document == null) {
            throw new RuntimeException("Document is null");
        }
        this._doc = document;
        this._state = 0;
        this._constructionElement = ElementProxy.createElementForFamily(this._doc, this.getBaseNamespace(), this.getBaseLocalName());
    }

    public static Element createElementForFamily(Document document, String string2, String string3) {
        Element element = null;
        String string4 = ElementProxy.getDefaultPrefix(string2);
        if (string2 == null) {
            element = document.createElementNS(null, string3);
        } else if (string4 == null || string4.length() == 0) {
            element = document.createElementNS(string2, string3);
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", string2);
        } else {
            element = document.createElementNS(string2, string4 + ":" + string3);
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + string4, string2);
        }
        return element;
    }

    public void setElement(Element element, String string2) throws XMLSecurityException {
        if (element == null) {
            throw new XMLSecurityException("ElementProxy.nullElement");
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "setElement(" + element.getTagName() + ", \"" + string2 + "\"");
        }
        this._doc = element.getOwnerDocument();
        this._state = 1;
        this._constructionElement = element;
        this._baseURI = string2;
    }

    public ElementProxy(Element element, String string2) throws XMLSecurityException {
        this();
        if (element == null) {
            throw new XMLSecurityException("ElementProxy.nullElement");
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "setElement(\"" + element.getTagName() + "\", \"" + string2 + "\")");
        }
        this._doc = element.getOwnerDocument();
        this._state = 1;
        this._constructionElement = element;
        this._baseURI = string2;
        this.guaranteeThatElementInCorrectSpace();
    }

    public final Element getElement() {
        return this._constructionElement;
    }

    public final NodeList getElementPlusReturns() {
        HelperNodeList helperNodeList = new HelperNodeList();
        helperNodeList.appendChild(this._doc.createTextNode("\n"));
        helperNodeList.appendChild(this.getElement());
        helperNodeList.appendChild(this._doc.createTextNode("\n"));
        return helperNodeList;
    }

    public Document getDocument() {
        return this._doc;
    }

    public String getBaseURI() {
        return this._baseURI;
    }

    public void guaranteeThatElementInCorrectSpace() throws XMLSecurityException {
        String string2 = this.getBaseLocalName();
        String string3 = this.getBaseNamespace();
        String string4 = this._constructionElement.getLocalName();
        String string5 = this._constructionElement.getNamespaceURI();
        if (!string2.equals(string4) || !string3.equals(string5)) {
            Object[] objectArray = new Object[]{string5 + ":" + string4, string3 + ":" + string2};
            throw new XMLSecurityException("xml.WrongElement", objectArray);
        }
    }

    public void addBigIntegerElement(BigInteger bigInteger, String string2) {
        if (bigInteger != null) {
            Element element = XMLUtils.createElementInSignatureSpace(this._doc, string2);
            Base64.fillElementWithBigInteger(element, bigInteger);
            this._constructionElement.appendChild(element);
            XMLUtils.addReturnToElement(this._constructionElement);
        }
    }

    public void addBase64Element(byte[] byArray, String string2) {
        if (byArray != null) {
            Element element = Base64.encodeToElement(this._doc, string2, byArray);
            this._constructionElement.appendChild(element);
            this._constructionElement.appendChild(this._doc.createTextNode("\n"));
        }
    }

    public void addTextElement(String string2, String string3) {
        Element element = XMLUtils.createElementInSignatureSpace(this._doc, string3);
        Text text = this._doc.createTextNode(string2);
        element.appendChild(text);
        this._constructionElement.appendChild(element);
        XMLUtils.addReturnToElement(this._constructionElement);
    }

    public void addBase64Text(byte[] byArray) {
        if (byArray != null) {
            Text text = this._doc.createTextNode("\n" + Base64.encode(byArray) + "\n");
            this._constructionElement.appendChild(text);
        }
    }

    public void addText(String string2) {
        if (string2 != null) {
            Text text = this._doc.createTextNode(string2);
            this._constructionElement.appendChild(text);
        }
    }

    public BigInteger getBigIntegerFromChildElement(String string2, String string3) throws Base64DecodingException {
        return Base64.decodeBigIntegerFromText(XMLUtils.selectNodeText(this._constructionElement.getFirstChild(), string3, string2, 0));
    }

    public byte[] getBytesFromChildElement(String string2, String string3) throws XMLSecurityException {
        Element element = XMLUtils.selectNode(this._constructionElement.getFirstChild(), string3, string2, 0);
        return Base64.decode(element);
    }

    public String getTextFromChildElement(String string2, String string3) {
        Text text = (Text)XMLUtils.selectNode(this._constructionElement.getFirstChild(), string3, string2, 0).getFirstChild();
        return text.getData();
    }

    public byte[] getBytesFromTextChild() throws XMLSecurityException {
        Text text = (Text)this._constructionElement.getFirstChild();
        return Base64.decode(text.getData());
    }

    public String getTextFromTextChild() {
        return XMLUtils.getFullTextChildrenFromElement(this._constructionElement);
    }

    public int length(String string2, String string3) {
        int n = 0;
        for (Node node = this._constructionElement.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!string3.equals(node.getLocalName()) || !string2.equals(node.getNamespaceURI())) continue;
            ++n;
        }
        return n;
    }

    public void setXPathNamespaceContext(String string2, String string3) throws XMLSecurityException {
        if (string2 == null || string2.length() == 0) {
            throw new XMLSecurityException("defaultNamespaceCannotBeSetHere");
        }
        if (string2.equals("xmlns")) {
            throw new XMLSecurityException("defaultNamespaceCannotBeSetHere");
        }
        String string4 = string2.startsWith("xmlns:") ? string2 : "xmlns:" + string2;
        Attr attr = this._constructionElement.getAttributeNodeNS("http://www.w3.org/2000/xmlns/", string4);
        if (attr != null) {
            if (!attr.getNodeValue().equals(string3)) {
                Object[] objectArray = new Object[]{string4, this._constructionElement.getAttributeNS(null, string4)};
                throw new XMLSecurityException("namespacePrefixAlreadyUsedByOtherURI", objectArray);
            }
            return;
        }
        this._constructionElement.setAttributeNS("http://www.w3.org/2000/xmlns/", string4, string3);
    }

    public static void setDefaultPrefix(String string2, String string3) throws XMLSecurityException {
        Object v;
        if (_prefixMappings.containsValue(string3) && !(v = _prefixMappings.get(string2)).equals(string3)) {
            Object[] objectArray = new Object[]{string3, string2, v};
            throw new XMLSecurityException("prefix.AlreadyAssigned", objectArray);
        }
        _prefixMappings.put(string2, string3);
    }

    public static String getDefaultPrefix(String string2) {
        String string3 = (String)_prefixMappings.get(string2);
        return string3;
    }

    static /* synthetic */ Class class$(String string2) {
        try {
            return Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

