/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.utils.resolver;

import com.sun.org.apache.xml.internal.security.signature.XMLSignatureInput;
import com.sun.org.apache.xml.internal.security.utils.resolver.ResourceResolverException;
import com.sun.org.apache.xml.internal.security.utils.resolver.ResourceResolverSpi;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Attr;

public class ResourceResolver {
    static Logger log = Logger.getLogger((class$com$sun$org$apache$xml$internal$security$utils$resolver$ResourceResolver == null ? (class$com$sun$org$apache$xml$internal$security$utils$resolver$ResourceResolver = ResourceResolver.class$("com.sun.org.apache.xml.internal.security.utils.resolver.ResourceResolver")) : class$com$sun$org$apache$xml$internal$security$utils$resolver$ResourceResolver).getName());
    static boolean _alreadyInitialized = false;
    static List _resolverVector = null;
    List _individualResolverVector = null;
    protected ResourceResolverSpi _resolverSpi = null;
    static /* synthetic */ Class class$com$sun$org$apache$xml$internal$security$utils$resolver$ResourceResolver;

    private ResourceResolver(String string2) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        this._resolverSpi = (ResourceResolverSpi)Class.forName(string2).newInstance();
    }

    public ResourceResolver(ResourceResolverSpi resourceResolverSpi) {
        this._resolverSpi = resourceResolverSpi;
    }

    public static final ResourceResolver getInstance(Attr attr, String string2) throws ResourceResolverException {
        int n = _resolverVector.size();
        for (int i = 0; i < n; ++i) {
            ResourceResolver resourceResolver = (ResourceResolver)_resolverVector.get(i);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "check resolvability by class " + resourceResolver.getClass().getName());
            }
            if (resourceResolver == null || !resourceResolver.canResolve(attr, string2)) continue;
            return resourceResolver;
        }
        Object[] objectArray = new Object[]{attr != null ? attr.getNodeValue() : "null", string2};
        throw new ResourceResolverException("utils.resolver.noClass", objectArray, attr, string2);
    }

    public static final ResourceResolver getInstance(Attr attr, String string2, List list) throws ResourceResolverException {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "I was asked to create a ResourceResolver and got " + list.size());
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, " extra resolvers to my existing " + _resolverVector.size() + " system-wide resolvers");
        }
        int n = 0;
        if (list != null && (n = list.size()) > 0) {
            for (int i = 0; i < n; ++i) {
                ResourceResolver resourceResolver = (ResourceResolver)list.get(i);
                if (resourceResolver == null) continue;
                String string3 = resourceResolver._resolverSpi.getClass().getName();
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "check resolvability by class " + string3);
                }
                if (!resourceResolver.canResolve(attr, string2)) continue;
                return resourceResolver;
            }
        }
        return ResourceResolver.getInstance(attr, string2);
    }

    public static void init() {
        if (!_alreadyInitialized) {
            _resolverVector = new ArrayList(10);
            _alreadyInitialized = true;
        }
    }

    public static void register(String string2) {
        ResourceResolver resourceResolver = null;
        try {
            resourceResolver = new ResourceResolver(string2);
            _resolverVector.add(resourceResolver);
        }
        catch (Exception exception) {
            log.log(Level.WARNING, "Error loading resolver " + string2 + " disabling it");
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            log.log(Level.WARNING, "Error loading resolver " + string2 + " disabling it");
        }
    }

    public static void registerAtStart(String string2) {
        _resolverVector.add(0, string2);
    }

    public static XMLSignatureInput resolveStatic(Attr attr, String string2) throws ResourceResolverException {
        ResourceResolver resourceResolver = ResourceResolver.getInstance(attr, string2);
        return resourceResolver.resolve(attr, string2);
    }

    public XMLSignatureInput resolve(Attr attr, String string2) throws ResourceResolverException {
        return this._resolverSpi.engineResolve(attr, string2);
    }

    public void setProperty(String string2, String string3) {
        this._resolverSpi.engineSetProperty(string2, string3);
    }

    public String getProperty(String string2) {
        return this._resolverSpi.engineGetProperty(string2);
    }

    public void addProperties(Map map) {
        this._resolverSpi.engineAddProperies(map);
    }

    public String[] getPropertyKeys() {
        return this._resolverSpi.engineGetPropertyKeys();
    }

    public boolean understandsProperty(String string2) {
        return this._resolverSpi.understandsProperty(string2);
    }

    private boolean canResolve(Attr attr, String string2) {
        return this._resolverSpi.engineCanResolve(attr, string2);
    }

    static /* synthetic */ Class class$(String string2) {
        try {
            return Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

