/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.actions;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.WorkspaceImpl;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.support.UISupport;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.XFormField;
import com.eviware.x.form.XFormFieldListener;
import com.eviware.x.form.support.ADialogBuilder;
import com.eviware.x.form.support.AField;
import com.eviware.x.form.support.AForm;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;

public class NewWsdlProjectAction
extends AbstractAction {
    private final WorkspaceImpl workspace;
    private XFormDialog dialog;

    public NewWsdlProjectAction(WorkspaceImpl workspace) {
        super("New WSDL Project");
        this.workspace = workspace;
        this.putValue("ShortDescription", "Creates a new WSDL Project in this workspace");
        this.putValue("AcceleratorKey", UISupport.getKeyStroke("menu N"));
    }

    public void actionPerformed(ActionEvent e) {
        if (this.dialog == null) {
            this.dialog = ADialogBuilder.buildDialog(Form.class);
            this.dialog.setValue("Create Requests", Boolean.toString(true));
            this.dialog.getFormField("Initial WSDL").addFormFieldListener(new XFormFieldListener(){

                public void valueChanged(XFormField sourceField, String newValue, String oldValue) {
                    NewWsdlProjectAction.this.dialog.getFormField("Create Requests").setEnabled(newValue.trim().length() > 0);
                }
            });
        } else {
            this.dialog.setValue("Project Name", "");
            this.dialog.setValue("Initial WSDL", "");
        }
        if (this.dialog.show()) {
            try {
                WsdlProject project = this.workspace.createProject(this.dialog.getValue("Project Name"));
                if (project != null) {
                    String url = this.dialog.getValue("Initial WSDL").trim();
                    if (url.length() > 0) {
                        if (new File(url).exists()) {
                            url = "file:" + url;
                        }
                        project.importWsdl(url, this.dialog.getValue("Create Requests").equals("true"));
                    }
                    SoapUI.selectModelItem(project);
                }
            }
            catch (Exception ex) {
                UISupport.showErrorMessage(ex);
            }
        }
    }

    @AForm(name="New WSDL Project", description="Creates a new WSDL Project in this workspace")
    private class Form {
        @AField(name="Project Name", description="The name of the project to create", type=AField.AFieldType.STRING)
        public static final String PROJECTNAME = "Project Name";
        @AField(name="Initial WSDL", description="URL or filename of initial WSDL", type=AField.AFieldType.FILE)
        public static final String INITIALWSDL = "Initial WSDL";
        @AField(name="Create Requests", description="Create sample requests for all operations?", type=AField.AFieldType.BOOLEAN, enabled=false)
        public static final String CREATEREQUEST = "Create Requests";

        private Form() {
        }
    }
}

