/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl;

import com.eviware.soapui.config.TestCaseConfig;
import com.eviware.soapui.config.TestSuiteConfig;
import com.eviware.soapui.config.TestSuiteRunTypesConfig;
import com.eviware.soapui.impl.actions.ShowDesktopPanelAction;
import com.eviware.soapui.impl.wsdl.AbstractWsdlModelItem;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.actions.support.ShowOnlineHelpAction;
import com.eviware.soapui.impl.wsdl.actions.testsuite.AddNewTestCaseAction;
import com.eviware.soapui.impl.wsdl.actions.testsuite.CloneTestSuiteAction;
import com.eviware.soapui.impl.wsdl.actions.testsuite.RemoveTestSuiteAction;
import com.eviware.soapui.impl.wsdl.actions.testsuite.RenameTestSuiteAction;
import com.eviware.soapui.impl.wsdl.loadtest.WsdlLoadTest;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStep;
import com.eviware.soapui.model.testsuite.TestCase;
import com.eviware.soapui.model.testsuite.TestSuite;
import com.eviware.soapui.model.testsuite.TestSuiteListener;
import com.eviware.soapui.support.action.ActionSupport;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsdlTestSuite
extends AbstractWsdlModelItem<TestSuiteConfig>
implements TestSuite {
    private final WsdlProject project;
    private List<WsdlTestCase> testCases = new ArrayList<WsdlTestCase>();
    private Set<TestSuiteListener> listeners = new HashSet<TestSuiteListener>();

    public WsdlTestSuite(WsdlProject project, TestSuiteConfig config) {
        super(config, project, "/testSuite.gif");
        this.project = project;
        List testCaseConfigs = config.getTestCaseList();
        for (int i = 0; i < testCaseConfigs.size(); ++i) {
            this.testCases.add(new WsdlTestCase(this, (TestCaseConfig)testCaseConfigs.get(i)));
        }
        this.addAction(new ShowDesktopPanelAction("Open TestSuite Editor", "Opens the TestSuite Editor for this TestSuite", this));
        this.addAction(ActionSupport.SEPARATOR_ACTION);
        this.addAction(new AddNewTestCaseAction(this));
        this.addAction(new CloneTestSuiteAction(this));
        this.addAction(ActionSupport.SEPARATOR_ACTION);
        this.addAction(new RenameTestSuiteAction(this));
        this.addAction(new RemoveTestSuiteAction(this));
        this.addAction(ActionSupport.SEPARATOR_ACTION);
        this.addAction(new ShowOnlineHelpAction("http://www.soapui.org/userguide/functional/testsuites.html"));
        if (!config.isSetRunType()) {
            config.setRunType(TestSuiteRunTypesConfig.SEQUENTIAL);
        }
    }

    @Override
    public TestSuite.TestSuiteRunType getRunType() {
        TestSuiteRunTypesConfig.Enum runType = ((TestSuiteConfig)this.getConfig()).getRunType();
        if (runType.equals(TestSuiteRunTypesConfig.PARALLELL)) {
            return TestSuite.TestSuiteRunType.PARALLEL;
        }
        return TestSuite.TestSuiteRunType.SEQUENTIAL;
    }

    public void setRunType(TestSuite.TestSuiteRunType runType) {
        TestSuite.TestSuiteRunType oldRunType = this.getRunType();
        if (runType == TestSuite.TestSuiteRunType.PARALLEL && oldRunType != TestSuite.TestSuiteRunType.PARALLEL) {
            ((TestSuiteConfig)this.getConfig()).setRunType(TestSuiteRunTypesConfig.PARALLELL);
            this.notifyPropertyChanged(RUNTYPE_PROPERTY, (Object)oldRunType, (Object)runType);
        } else if (runType == TestSuite.TestSuiteRunType.SEQUENTIAL && oldRunType != TestSuite.TestSuiteRunType.SEQUENTIAL) {
            ((TestSuiteConfig)this.getConfig()).setRunType(TestSuiteRunTypesConfig.SEQUENTIAL);
            this.notifyPropertyChanged(RUNTYPE_PROPERTY, (Object)oldRunType, (Object)runType);
        }
    }

    @Override
    public WsdlProject getProject() {
        return this.project;
    }

    @Override
    public int getTestCaseCount() {
        return this.testCases.size();
    }

    @Override
    public WsdlTestCase getTestCaseAt(int index) {
        return this.testCases.get(index);
    }

    @Override
    public WsdlTestCase getTestCaseByName(String testCaseName) {
        return (WsdlTestCase)this.getWsdlModelItemByName(this.testCases, testCaseName);
    }

    public WsdlTestCase cloneTestCase(WsdlTestCase testCase, String name) {
        TestCaseConfig newTestCase = ((TestSuiteConfig)this.getConfig()).addNewTestCase();
        newTestCase.set(testCase.getConfig());
        newTestCase.setName(name);
        WsdlTestCase newWsdlTestCase = new WsdlTestCase(this, newTestCase);
        this.testCases.add(newWsdlTestCase);
        this.fireTestCaseAdded(newWsdlTestCase);
        return newWsdlTestCase;
    }

    public WsdlTestCase addNewTestCase(String name) {
        WsdlTestCase testCase = new WsdlTestCase(this, ((TestSuiteConfig)this.getConfig()).addNewTestCase());
        testCase.setName(name);
        testCase.setFailOnError(true);
        testCase.setSearchProperties(true);
        this.testCases.add(testCase);
        this.fireTestCaseAdded(testCase);
        return testCase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTestCase(WsdlTestCase testCase) {
        int ix = this.testCases.indexOf(testCase);
        this.testCases.remove(ix);
        try {
            this.fireTestCaseRemoved(testCase);
        }
        finally {
            testCase.release();
            ((TestSuiteConfig)this.getConfig()).removeTestCase(ix);
        }
    }

    public void fireTestCaseAdded(WsdlTestCase testCase) {
        TestSuiteListener[] a = this.listeners.toArray(new TestSuiteListener[this.listeners.size()]);
        for (int c = 0; c < a.length; ++c) {
            a[c].testCaseAdded(testCase);
        }
    }

    public void fireTestCaseRemoved(WsdlTestCase testCase) {
        TestSuiteListener[] a = this.listeners.toArray(new TestSuiteListener[this.listeners.size()]);
        for (int c = 0; c < a.length; ++c) {
            a[c].testCaseRemoved(testCase);
        }
    }

    public void fireTestStepAdded(WsdlTestStep testStep, int index) {
        TestSuiteListener[] a = this.listeners.toArray(new TestSuiteListener[this.listeners.size()]);
        for (int c = 0; c < a.length; ++c) {
            a[c].testStepAdded(testStep, index);
        }
    }

    public void fireTestStepRemoved(WsdlTestStep testStep, int ix) {
        TestSuiteListener[] a = this.listeners.toArray(new TestSuiteListener[this.listeners.size()]);
        for (int c = 0; c < a.length; ++c) {
            a[c].testStepRemoved(testStep, ix);
        }
    }

    public void fireTestStepMoved(WsdlTestStep testStep, int ix, int offset) {
        TestSuiteListener[] a = this.listeners.toArray(new TestSuiteListener[this.listeners.size()]);
        for (int c = 0; c < a.length; ++c) {
            a[c].testStepMoved(testStep, ix, offset);
        }
    }

    public void fireLoadTestAdded(WsdlLoadTest loadTest) {
        TestSuiteListener[] a = this.listeners.toArray(new TestSuiteListener[this.listeners.size()]);
        for (int c = 0; c < a.length; ++c) {
            a[c].loadTestAdded(loadTest);
        }
    }

    public void fireLoadTestRemoved(WsdlLoadTest loadTest) {
        TestSuiteListener[] a = this.listeners.toArray(new TestSuiteListener[this.listeners.size()]);
        for (int c = 0; c < a.length; ++c) {
            a[c].loadTestRemoved(loadTest);
        }
    }

    @Override
    public void addTestSuiteListener(TestSuiteListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeTestSuiteListener(TestSuiteListener listener) {
        this.listeners.remove(listener);
    }

    public int getTestCaseIndex(TestCase testCase) {
        return this.testCases.indexOf(testCase);
    }

    @Override
    public void release() {
        super.release();
        for (WsdlTestCase testCase : this.testCases) {
            testCase.release();
        }
    }
}

