/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.support.http;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.model.settings.Settings;
import com.eviware.soapui.model.settings.SettingsListener;
import com.eviware.soapui.settings.HttpSettings;
import com.eviware.soapui.settings.SSLSettings;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.zip.GZIPInputStream;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.contrib.ssl.EasySSLProtocolSocketFactory;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.ssl.KeyMaterial;
import org.apache.log4j.Logger;

public class HttpClientSupport {
    private static final Helper helper = new Helper();

    public static HttpClient getHttpClient() {
        return helper.getHttpClient();
    }

    public static void applyHttpSettings(HttpMethodBase postMethod, Settings settings) {
        String userAgent = settings.getString(HttpSettings.USER_AGENT, null);
        if (userAgent != null && userAgent.length() > 0) {
            postMethod.setRequestHeader("User-Agent", userAgent);
        }
        long timeout = settings.getLong(HttpSettings.SOCKET_TIMEOUT, 60000L);
        postMethod.getParams().setSoTimeout((int)timeout);
    }

    public static boolean isZippedResponse(HttpMethodBase method) {
        Header contentType = method.getResponseHeader("Content-Type");
        Header contentEncoding = method.getResponseHeader("Content-Encoding");
        if (contentType != null && contentType.getValue().toUpperCase().endsWith("GZIP")) {
            return true;
        }
        return contentEncoding != null && contentEncoding.getValue().toUpperCase().endsWith("GZIP");
    }

    public static byte[] decompress(byte[] s) {
        GZIPInputStream zipin;
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(s);
            zipin = new GZIPInputStream(in);
        }
        catch (IOException e) {
            e.printStackTrace();
            return s;
        }
        int sizeBuffer = 8192;
        byte[] buffer = new byte[sizeBuffer];
        try {
            int length;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            while ((length = zipin.read(buffer, 0, sizeBuffer)) != -1) {
                out.write(buffer, 0, length);
            }
            s = out.toByteArray();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return s;
        }
        try {
            zipin.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        return s;
    }

    private static class Helper {
        private HttpClient httpClient;
        private static final Logger log = Logger.getLogger(Helper.class);
        private EasySSLProtocolSocketFactory easySSL;

        public Helper() {
            try {
                this.easySSL = new EasySSLProtocolSocketFactory();
                this.initSSL(this.easySSL);
                Protocol easyhttps = new Protocol("https", (ProtocolSocketFactory)this.easySSL, 443);
                Protocol.registerProtocol((String)"https", (Protocol)easyhttps);
            }
            catch (Throwable e) {
                log.error((Object)("Failed to initialize SSL settings; " + e));
            }
            MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
            connectionManager.getParams().setDefaultMaxConnectionsPerHost(500);
            connectionManager.getParams().setMaxTotalConnections(2000);
            this.httpClient = new HttpClient((HttpConnectionManager)connectionManager);
            SoapUI.getSettings().addSettingsListener(new SettingsListener(){

                public void settingChanged(String name, String newValue, String oldValue) {
                    if (name.equals(SSLSettings.KEYSTORE) || name.equals(SSLSettings.KEYSTORE_PASSWORD)) {
                        try {
                            log.info((Object)"Updating keyStore..");
                            Helper.this.initKeyMaterial(Helper.this.easySSL);
                        }
                        catch (Throwable e) {
                            log.error((Object)("Failed to initialize SSL settings; " + e));
                        }
                    }
                }
            });
        }

        private void initSSL(EasySSLProtocolSocketFactory easySSL) throws IOException, GeneralSecurityException {
            log.info((Object)"Initializing SSL");
            this.initKeyMaterial(easySSL);
        }

        private void initKeyMaterial(EasySSLProtocolSocketFactory easySSL) throws IOException, NoSuchAlgorithmException, KeyStoreException, KeyManagementException, CertificateException {
            Settings settings = SoapUI.getSettings();
            String keyStore = settings.getString(SSLSettings.KEYSTORE, null);
            keyStore = keyStore != null ? keyStore.trim() : "";
            String pass = settings.getString(SSLSettings.KEYSTORE_PASSWORD, "");
            char[] pwd = pass.toCharArray();
            if (!"".equals(keyStore)) {
                File f = new File(keyStore);
                if (f.exists()) {
                    KeyMaterial km = null;
                    try {
                        km = new KeyMaterial(keyStore, pwd);
                        log.info((Object)("Set KeyMaterial from file [" + keyStore + "]"));
                    }
                    catch (GeneralSecurityException gse) {
                        log.error((Object)("Failed to load KeyMaterial [" + keyStore + "] " + gse));
                    }
                    if (km != null) {
                        easySSL.setKeyMaterial(km);
                    }
                }
            } else {
                easySSL.setKeyMaterial(null);
            }
        }

        public HttpClient getHttpClient() {
            return this.httpClient;
        }
    }
}

