/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.fs;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.internal.delta.SVNDeltaCombiner;
import org.tmatesoft.svn.core.internal.io.fs.FSFS;
import org.tmatesoft.svn.core.internal.io.fs.FSFile;
import org.tmatesoft.svn.core.internal.io.fs.FSRepresentation;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionNode;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;
import org.tmatesoft.svn.util.SVNLogType;

public class FSInputStream
extends InputStream {
    private LinkedList myRepStateList = new LinkedList();
    private int myChunkIndex;
    private boolean isChecksumFinalized;
    private String myHexChecksum;
    private long myLength;
    private long myOffset;
    private MessageDigest myDigest;
    private ByteBuffer myBuffer;
    private SVNDeltaCombiner myCombiner;

    private FSInputStream(SVNDeltaCombiner combiner, FSRepresentation representation, FSFS owner) throws SVNException {
        this.myCombiner = combiner;
        this.myChunkIndex = 0;
        this.isChecksumFinalized = false;
        this.myHexChecksum = representation.getMD5HexDigest();
        this.myOffset = 0L;
        this.myLength = representation.getExpandedSize();
        try {
            this.myDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException nsae) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "MD5 implementation not found: {0}", nsae.getLocalizedMessage());
            SVNErrorManager.error(err, nsae, SVNLogType.FSFS);
        }
        try {
            this.buildRepresentationList(representation, this.myRepStateList, owner);
        }
        catch (SVNException svne) {
            this.close();
            throw svne;
        }
    }

    public static InputStream createDeltaStream(SVNDeltaCombiner combiner, FSRevisionNode fileNode, FSFS owner) throws SVNException {
        FSRepresentation representation;
        if (fileNode == null) {
            return SVNFileUtil.DUMMY_IN;
        }
        if (fileNode.getType() != SVNNodeKind.FILE) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FILE, "Attempted to get textual contents of a *non*-file node");
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        if ((representation = fileNode.getTextRepresentation()) == null) {
            return SVNFileUtil.DUMMY_IN;
        }
        return new FSInputStream(combiner, representation, owner);
    }

    public static InputStream createDeltaStream(SVNDeltaCombiner combiner, FSRepresentation fileRep, FSFS owner) throws SVNException {
        if (fileRep == null) {
            return SVNFileUtil.DUMMY_IN;
        }
        return new FSInputStream(combiner, fileRep, owner);
    }

    public int read(byte[] buf, int offset, int length) throws IOException {
        try {
            return this.readContents(buf, offset, length);
        }
        catch (SVNException svne) {
            throw new IOException(svne.getMessage());
        }
    }

    public int read() throws IOException {
        byte[] buf = new byte[1];
        int r = this.read(buf, 0, 1);
        if (r < 0) {
            return -1;
        }
        return buf[0] & 0xFF;
    }

    private int readContents(byte[] buf, int offset, int length) throws SVNException {
        length = this.getContents(buf, offset, length);
        if (!this.isChecksumFinalized && length >= 0) {
            this.myDigest.update(buf, offset, length);
            this.myOffset += (long)length;
            if (this.myOffset == this.myLength) {
                this.isChecksumFinalized = true;
                String hexDigest = SVNFileUtil.toHexDigest(this.myDigest);
                if (!this.myHexChecksum.equals(hexDigest)) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Checksum mismatch while reading representation:\n   expected:  {0}\n     actual:  {1}", new Object[]{this.myHexChecksum, hexDigest});
                    SVNErrorManager.error(err, SVNLogType.FSFS);
                }
            }
        }
        return length;
    }

    private int getContents(byte[] buffer, int offset, int length) throws SVNException {
        int remaining = length;
        int targetPos = offset;
        int read = 0;
        block0: while (remaining > 0) {
            if (this.myBuffer != null && this.myBuffer.hasRemaining()) {
                int copyLength = Math.min(this.myBuffer.remaining(), remaining);
                this.myBuffer.get(buffer, targetPos, copyLength);
                targetPos += copyLength;
                remaining -= copyLength;
                read += copyLength;
                continue;
            }
            FSRepresentationState resultState = (FSRepresentationState)this.myRepStateList.getFirst();
            if (resultState.myOffset == resultState.myEnd) {
                if (read != 0) break;
                read = -1;
                break;
            }
            this.myCombiner.reset();
            ListIterator states = this.myRepStateList.listIterator();
            while (states.hasNext()) {
                FSRepresentationState curState = (FSRepresentationState)states.next();
                while (curState.myChunkIndex < this.myChunkIndex) {
                    this.myCombiner.skipWindow(curState.myFile);
                    ++curState.myChunkIndex;
                    curState.myOffset = curState.myFile.position();
                    if (curState.myOffset < curState.myEnd) continue;
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Reading one svndiff window read beyond the end of the representation");
                    SVNErrorManager.error(err, SVNLogType.FSFS);
                }
                SVNDiffWindow window = this.myCombiner.readWindow(curState.myFile, curState.myVersion);
                ByteBuffer target = this.myCombiner.addWindow(window);
                ++curState.myChunkIndex;
                curState.myOffset = curState.myFile.position();
                if (target == null) continue;
                this.myBuffer = target;
                ++this.myChunkIndex;
                continue block0;
            }
        }
        return read;
    }

    public void close() {
        Iterator states = this.myRepStateList.iterator();
        while (states.hasNext()) {
            FSRepresentationState state = (FSRepresentationState)states.next();
            if (state.myFile != null) {
                state.myFile.close();
            }
            states.remove();
        }
    }

    private FSRepresentationState buildRepresentationList(FSRepresentation firstRep, LinkedList result, FSFS owner) throws SVNException {
        FSFile file = null;
        FSRepresentation rep = new FSRepresentation(firstRep);
        ByteBuffer buffer = ByteBuffer.allocate(4);
        try {
            while (true) {
                file = owner.openAndSeekRepresentation(rep);
                FSRepresentationState repState = FSInputStream.readRepresentationLine(file);
                repState.myFile = file;
                repState.myOffset = repState.myStart = file.position();
                repState.myEnd = repState.myStart + rep.getSize();
                if (!repState.myIsDelta) {
                    return repState;
                }
                buffer.clear();
                int r = file.read(buffer);
                byte[] header = buffer.array();
                if (header[0] != 83 || header[1] != 86 || header[2] != 78 || r != 4) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Malformed svndiff data in representation");
                    SVNErrorManager.error(err, SVNLogType.FSFS);
                }
                repState.myVersion = header[3];
                repState.myChunkIndex = 0;
                repState.myOffset += 4L;
                result.addLast(repState);
                if (repState.myIsDeltaVsEmpty) {
                    return null;
                }
                rep.setRevision(repState.myBaseRevision);
                rep.setOffset(repState.myBaseOffset);
                rep.setSize(repState.myBaseLength);
                rep.setTxnId(null);
            }
        }
        catch (IOException ioe) {
            file.close();
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, ioe.getLocalizedMessage());
            SVNErrorManager.error(err, ioe, SVNLogType.FSFS);
        }
        catch (SVNException svne) {
            file.close();
            throw svne;
        }
        return null;
    }

    public static FSRepresentationState readRepresentationLine(FSFile file) throws SVNException {
        try {
            SVNErrorMessage err;
            String header;
            String line = file.readLine(160);
            FSRepresentationState repState = new FSRepresentationState();
            repState.myIsDelta = false;
            if ("PLAIN".equals(line)) {
                return repState;
            }
            if ("DELTA".equals(line)) {
                repState.myIsDelta = true;
                repState.myIsDeltaVsEmpty = true;
                return repState;
            }
            repState.myIsDelta = true;
            repState.myIsDeltaVsEmpty = false;
            int delimiterInd = line.indexOf(32);
            if (delimiterInd == -1) {
                SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Malformed representation header");
                SVNErrorManager.error(err2, SVNLogType.FSFS);
            }
            if (!"DELTA".equals(header = line.substring(0, delimiterInd))) {
                err = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Malformed representation header");
                SVNErrorManager.error(err, SVNLogType.FSFS);
            }
            line = line.substring(delimiterInd + 1);
            try {
                delimiterInd = line.indexOf(32);
                if (delimiterInd == -1) {
                    err = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Malformed representation header");
                    SVNErrorManager.error(err, SVNLogType.FSFS);
                }
                String baseRevision = line.substring(0, delimiterInd);
                repState.myBaseRevision = Long.parseLong(baseRevision);
                if ((delimiterInd = (line = line.substring(delimiterInd + 1)).indexOf(32)) == -1) {
                    SVNErrorMessage err3 = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Malformed representation header");
                    SVNErrorManager.error(err3, SVNLogType.FSFS);
                }
                String baseOffset = line.substring(0, delimiterInd);
                repState.myBaseOffset = Long.parseLong(baseOffset);
                line = line.substring(delimiterInd + 1);
                repState.myBaseLength = Long.parseLong(line);
            }
            catch (NumberFormatException nfe) {
                SVNErrorMessage err4 = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Malformed representation header");
                SVNErrorManager.error(err4, SVNLogType.FSFS);
            }
            return repState;
        }
        catch (SVNException svne) {
            file.close();
            throw svne;
        }
    }

    public static class FSRepresentationState {
        FSFile myFile;
        long myStart;
        long myOffset;
        long myEnd;
        int myVersion;
        int myChunkIndex;
        boolean myIsDelta;
        boolean myIsDeltaVsEmpty;
        long myBaseRevision;
        long myBaseOffset;
        long myBaseLength;
    }
}

