/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.drools.FactException;
import org.drools.FactHandle;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.RuleBaseConfiguration;
import org.drools.SessionConfiguration;
import org.drools.StatefulSession;
import org.drools.StatelessSession;
import org.drools.common.AbstractRuleBase;
import org.drools.common.DefaultFactHandle;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalRuleBase;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.RuleBasePartitionId;
import org.drools.concurrent.CommandExecutor;
import org.drools.concurrent.ExecutorService;
import org.drools.event.RuleBaseEventListener;
import org.drools.impl.EnvironmentFactory;
import org.drools.impl.KnowledgeBaseImpl;
import org.drools.impl.StatefulKnowledgeSessionImpl;
import org.drools.marshalling.Marshaller;
import org.drools.marshalling.MarshallerFactory;
import org.drools.reteoo.EntryPointNode;
import org.drools.reteoo.ObjectSource;
import org.drools.reteoo.Rete;
import org.drools.reteoo.ReteooBuilder;
import org.drools.reteoo.ReteooFactHandleFactory;
import org.drools.reteoo.ReteooStatefulSession;
import org.drools.reteoo.ReteooStatelessSession;
import org.drools.reteoo.ReteooWorkingMemory;
import org.drools.rule.EntryPoint;
import org.drools.rule.InvalidPatternException;
import org.drools.rule.Package;
import org.drools.rule.Rule;
import org.drools.runtime.Environment;
import org.drools.runtime.KnowledgeSessionConfiguration;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.spi.ExecutorServiceFactory;
import org.drools.spi.FactHandleFactory;
import org.drools.spi.PropagationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReteooRuleBase
extends AbstractRuleBase {
    private static final long serialVersionUID = 500L;
    private transient Rete rete;
    private ReteooBuilder reteooBuilder;

    public ReteooRuleBase() {
    }

    public ReteooRuleBase(String id) {
        this(id, null, new ReteooFactHandleFactory());
    }

    public ReteooRuleBase(String id, FactHandleFactory factHandleFactory) {
        this(id, null, factHandleFactory);
    }

    public ReteooRuleBase(String id, RuleBaseConfiguration config) {
        this(id, config, new ReteooFactHandleFactory());
    }

    public ReteooRuleBase(RuleBaseConfiguration config) {
        this(null, config, new ReteooFactHandleFactory());
    }

    public ReteooRuleBase(String id, RuleBaseConfiguration config, FactHandleFactory factHandleFactory) {
        super(id, config, factHandleFactory);
        this.setupRete();
    }

    private void setupRete() {
        this.rete = new Rete(this);
        this.reteooBuilder = new ReteooBuilder(this);
        EntryPointNode epn = new EntryPointNode(this.reteooBuilder.getIdGenerator().getNextId(), RuleBasePartitionId.MAIN_PARTITION, this.getConfig().isMultithreadEvaluation(), (ObjectSource)this.rete, EntryPoint.DEFAULT);
        epn.attach();
    }

    @Override
    public void writeExternal(ObjectOutput stream) throws IOException {
        super.writeExternal(stream);
        stream.writeObject(this.reteooBuilder);
        stream.writeObject(this.rete);
    }

    @Override
    public void readExternal(ObjectInput stream) throws IOException, ClassNotFoundException {
        super.readExternal(stream);
        this.reteooBuilder = (ReteooBuilder)stream.readObject();
        this.rete = (Rete)stream.readObject();
    }

    @Override
    public Rete getRete() {
        return this.rete;
    }

    @Override
    public ReteooBuilder getReteooBuilder() {
        return this.reteooBuilder;
    }

    @Override
    public void assertObject(FactHandle handle, Object object, PropagationContext context, InternalWorkingMemory workingMemory) throws FactException {
        this.getRete().assertObject((DefaultFactHandle)handle, context, workingMemory);
    }

    @Override
    public void retractObject(FactHandle handle, PropagationContext context, ReteooWorkingMemory workingMemory) throws FactException {
        this.getRete().retractObject((InternalFactHandle)handle, context, workingMemory);
    }

    @Override
    public StatefulSession newStatefulSession(boolean keepReference) {
        SessionConfiguration config = new SessionConfiguration();
        config.setKeepReference(keepReference);
        return this.newStatefulSession(config, EnvironmentFactory.newEnvironment());
    }

    @Override
    public StatefulSession newStatefulSession(InputStream stream) {
        return this.newStatefulSession(stream, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StatefulSession newStatefulSession(InputStream stream, boolean keepReference) {
        StatefulSession session = null;
        try {
            Map map = this.pkgs;
            synchronized (map) {
                ObjectInputStream ois = new ObjectInputStream(stream);
                ReteooStatefulSession rsession = (ReteooStatefulSession)ois.readObject();
                ByteArrayInputStream bais = new ByteArrayInputStream(rsession.bytes);
                Marshaller marshaller = MarshallerFactory.newMarshaller((KnowledgeBase)new KnowledgeBaseImpl(this));
                StatefulKnowledgeSession ksession = marshaller.unmarshall((InputStream)bais, (KnowledgeSessionConfiguration)new SessionConfiguration(), EnvironmentFactory.newEnvironment());
                session = (StatefulSession)((Object)((StatefulKnowledgeSessionImpl)ksession).session);
                if (keepReference) {
                    super.addStatefulSession(session);
                    for (Object listener : session.getRuleBaseUpdateListeners()) {
                        this.addEventListener((RuleBaseEventListener)listener);
                    }
                }
                bais.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to unmarshall session", e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to close stream", e);
            }
        }
        return session;
    }

    @Override
    public StatefulSession newStatefulSession(SessionConfiguration sessionConfig, Environment environment) {
        if (sessionConfig == null) {
            sessionConfig = (SessionConfiguration)KnowledgeBaseFactory.newKnowledgeSessionConfiguration();
        }
        if (environment == null) {
            environment = EnvironmentFactory.newEnvironment();
        }
        return this.newStatefulSession(this.nextWorkingMemoryCounter(), sessionConfig, environment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StatefulSession newStatefulSession(int id, SessionConfiguration sessionConfig, Environment environment) {
        ReteooStatefulSession session;
        if (this.getConfig().isSequential()) {
            throw new RuntimeException("Cannot have a stateful rule session, with sequential configuration set to true");
        }
        Map map = this.pkgs;
        synchronized (map) {
            ExecutorService executor = ExecutorServiceFactory.createExecutorService(this.getConfig().getExecutorService());
            session = new ReteooStatefulSession(id, (InternalRuleBase)this, executor, sessionConfig, environment);
            executor.setCommandExecutor(new CommandExecutor(session));
            if (sessionConfig.isKeepReference()) {
                super.addStatefulSession(session);
                for (Object listener : session.getRuleBaseUpdateListeners()) {
                    this.addEventListener((RuleBaseEventListener)listener);
                }
            }
            session.startPartitionManagers();
            session.queueWorkingMemoryAction(new ReteooWorkingMemory.WorkingMemoryReteAssertAction(session.getInitialFactHandle(), false, true, null, null));
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StatelessSession newStatelessSession() {
        if (this.getConfig().isSequential()) {
            this.reteooBuilder.order();
        }
        Map map = this.pkgs;
        synchronized (map) {
            return new ReteooStatelessSession(this);
        }
    }

    @Override
    protected synchronized void addRule(Rule rule) throws InvalidPatternException {
        this.reteooBuilder.addRule(rule);
    }

    @Override
    protected synchronized void removeRule(Rule rule) {
        this.reteooBuilder.removeRule(rule);
    }

    @Override
    public int getNodeCount() {
        return this.reteooBuilder.getIdGenerator().getLastId() + 1;
    }

    @Override
    public void addPackages(Package[] pkgs) {
        this.addPackages(Arrays.asList(pkgs));
    }

    @Override
    public void addPackages(Collection<Package> pkgs) {
        super.addPackages(pkgs);
        if (this.getConfig().isSequential()) {
            this.reteooBuilder.setOrdered(false);
        }
    }

    @Override
    public void addPackage(Package newPkg) {
        ArrayList<Package> list = new ArrayList<Package>();
        list.add(newPkg);
        super.addPackages(list);
        if (this.getConfig().isSequential()) {
            this.reteooBuilder.setOrdered(false);
        }
    }
}

