/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyConstant;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"BigDecimal"}, parent="Numeric")
public class RubyBigDecimal
extends RubyNumeric {
    private static final ObjectAllocator BIGDECIMAL_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyBigDecimal(runtime, klass);
        }
    };
    @JRubyConstant
    public static final int ROUND_DOWN = 1;
    @JRubyConstant
    public static final int ROUND_CEILING = 2;
    @JRubyConstant
    public static final int ROUND_UP = 0;
    @JRubyConstant
    public static final int ROUND_HALF_DOWN = 5;
    @JRubyConstant
    public static final int ROUND_HALF_EVEN = 6;
    @JRubyConstant
    public static final int ROUND_HALF_UP = 4;
    @JRubyConstant
    public static final int ROUND_FLOOR = 3;
    @JRubyConstant
    public static final int SIGN_POSITIVE_INFINITE = 3;
    @JRubyConstant
    public static final int EXCEPTION_OVERFLOW = 1;
    @JRubyConstant
    public static final int SIGN_POSITIVE_ZERO = 1;
    @JRubyConstant
    public static final int EXCEPTION_ALL = 255;
    @JRubyConstant
    public static final int SIGN_NEGATIVE_FINITE = -2;
    @JRubyConstant
    public static final int EXCEPTION_UNDERFLOW = 4;
    @JRubyConstant
    public static final int SIGN_NaN = 0;
    @JRubyConstant
    public static final int BASE = 10000;
    @JRubyConstant
    public static final int ROUND_MODE = 256;
    @JRubyConstant
    public static final int SIGN_POSITIVE_FINITE = 2;
    @JRubyConstant
    public static final int EXCEPTION_INFINITY = 1;
    @JRubyConstant
    public static final int SIGN_NEGATIVE_INFINITE = -3;
    @JRubyConstant
    public static final int EXCEPTION_ZERODIVIDE = 1;
    @JRubyConstant
    public static final int SIGN_NEGATIVE_ZERO = -1;
    @JRubyConstant
    public static final int EXCEPTION_NaN = 2;
    private static final BigDecimal TWO = new BigDecimal(2);
    private static final double SQRT_10 = 3.1622776601683795;
    private boolean isNaN = false;
    private int infinitySign = 0;
    private int zeroSign = 0;
    private BigDecimal value;
    private static final Pattern INFINITY_PATTERN = Pattern.compile("^([+-])?Infinity$");
    private static final Pattern NUMBER_PATTERN = Pattern.compile("^([+-]?\\d*\\.?\\d*([eE][+-]?)?\\d*).*");

    public static RubyClass createBigDecimal(Ruby runtime) {
        RubyClass result = runtime.defineClass("BigDecimal", runtime.getNumeric(), BIGDECIMAL_ALLOCATOR);
        CallbackFactory callbackFactory = runtime.callbackFactory(RubyBigDecimal.class);
        runtime.getKernel().defineAnnotatedMethods(BigDecimalKernelMethods.class);
        result.setInternalModuleVariable("vpPrecLimit", RubyFixnum.zero(runtime));
        result.setInternalModuleVariable("vpExceptionMode", RubyFixnum.zero(runtime));
        result.setInternalModuleVariable("vpRoundingMode", runtime.newFixnum(4));
        result.defineAnnotatedMethods(RubyBigDecimal.class);
        result.defineAnnotatedConstants(RubyBigDecimal.class);
        return result;
    }

    public BigDecimal getValue() {
        return this.value;
    }

    public RubyBigDecimal(Ruby runtime, RubyClass klass) {
        super(runtime, klass);
    }

    public RubyBigDecimal(Ruby runtime, BigDecimal value) {
        super(runtime, runtime.fastGetClass("BigDecimal"));
        this.value = value;
    }

    public static RubyBigDecimal newBigDecimal(IRubyObject recv, IRubyObject[] args, Block unusedBlock) {
        return RubyBigDecimal.newInstance(recv.getRuntime().fastGetClass("BigDecimal"), args);
    }

    @JRubyMethod(name={"ver"}, meta=true)
    public static IRubyObject ver(IRubyObject recv) {
        return recv.getRuntime().newString("1.0.1");
    }

    @JRubyMethod(name={"_dump"}, optional=1, frame=true)
    public IRubyObject dump(IRubyObject[] args, Block unusedBlock) {
        RubyString precision = RubyString.newUnicodeString(args[0].getRuntime(), "0:");
        RubyString str = this.asString();
        return precision.append(str);
    }

    @JRubyMethod(name={"_load"}, required=1, frame=true, meta=true)
    public static RubyBigDecimal load(IRubyObject recv, IRubyObject from, Block block) {
        RubyBigDecimal rubyBigDecimal = (RubyBigDecimal)((RubyClass)recv).allocate();
        String precisionAndValue = from.convertToString().asJavaString();
        String value = precisionAndValue.substring(precisionAndValue.indexOf(":") + 1);
        rubyBigDecimal.value = new BigDecimal(value);
        return rubyBigDecimal;
    }

    @JRubyMethod(name={"double_fig"}, meta=true)
    public static IRubyObject double_fig(IRubyObject recv) {
        return recv.getRuntime().newFixnum(20);
    }

    @JRubyMethod(name={"limit"}, optional=1, meta=true)
    public static IRubyObject limit(IRubyObject recv, IRubyObject[] args) {
        IRubyObject arg;
        Ruby runtime = recv.getRuntime();
        RubyModule c = (RubyModule)recv;
        IRubyObject nCur = c.searchInternalModuleVariable("vpPrecLimit");
        if (args.length > 0 && !(arg = args[0]).isNil()) {
            if (!(arg instanceof RubyFixnum)) {
                throw runtime.newTypeError(arg, runtime.getFixnum());
            }
            if (0L > ((RubyFixnum)arg).getLongValue()) {
                throw runtime.newArgumentError("argument must be positive");
            }
            c.setInternalModuleVariable("vpPrecLimit", arg);
        }
        return nCur;
    }

    @JRubyMethod(name={"mode"}, required=1, optional=1, meta=true)
    public static IRubyObject mode(ThreadContext context, IRubyObject recv, IRubyObject[] args) {
        long EXCEPTION_ALL;
        Ruby runtime = recv.getRuntime();
        RubyClass clazz = runtime.fastGetClass("BigDecimal");
        RubyModule c = (RubyModule)recv;
        args = Arity.scanArgs(runtime, args, 1, 1);
        IRubyObject mode = args[0];
        IRubyObject value = args[1];
        if (!(mode instanceof RubyFixnum)) {
            throw runtime.newTypeError("wrong argument type " + mode.getMetaClass() + " (expected Fixnum)");
        }
        long longMode = ((RubyFixnum)mode).getLongValue();
        if ((longMode & (EXCEPTION_ALL = ((RubyFixnum)clazz.fastGetConstant("EXCEPTION_ALL")).getLongValue())) != 0L) {
            RubyFixnum EXCEPTION_NaN;
            if (value.isNil()) {
                return c.searchInternalModuleVariable("vpExceptionMode");
            }
            if (!value.isNil() && !(value instanceof RubyBoolean)) {
                throw runtime.newTypeError("second argument must be true or false");
            }
            RubyFixnum currentExceptionMode = (RubyFixnum)c.searchInternalModuleVariable("vpExceptionMode");
            RubyFixnum newExceptionMode = new RubyFixnum(runtime, currentExceptionMode.getLongValue());
            RubyFixnum EXCEPTION_INFINITY = (RubyFixnum)clazz.fastGetConstant("EXCEPTION_INFINITY");
            if ((longMode & EXCEPTION_INFINITY.getLongValue()) != 0L) {
                RubyFixnum rubyFixnum = newExceptionMode = value.isTrue() ? (RubyFixnum)currentExceptionMode.callCoerced(context, "|", EXCEPTION_INFINITY) : (RubyFixnum)currentExceptionMode.callCoerced(context, "&", new RubyFixnum(runtime, EXCEPTION_INFINITY.getLongValue() ^ 0xFFFFFFFFFFFFFFFFL));
            }
            if ((longMode & (EXCEPTION_NaN = (RubyFixnum)clazz.fastGetConstant("EXCEPTION_NaN")).getLongValue()) != 0L) {
                newExceptionMode = value.isTrue() ? (RubyFixnum)currentExceptionMode.callCoerced(context, "|", EXCEPTION_NaN) : (RubyFixnum)currentExceptionMode.callCoerced(context, "&", new RubyFixnum(runtime, EXCEPTION_NaN.getLongValue() ^ 0xFFFFFFFFFFFFFFFFL));
            }
            c.setInternalModuleVariable("vpExceptionMode", newExceptionMode);
            return newExceptionMode;
        }
        long ROUND_MODE = ((RubyFixnum)clazz.fastGetConstant("ROUND_MODE")).getLongValue();
        if (longMode == ROUND_MODE) {
            if (value.isNil()) {
                return c.searchInternalModuleVariable("vpRoundingMode");
            }
            if (!(value instanceof RubyFixnum)) {
                throw runtime.newTypeError("wrong argument type " + mode.getMetaClass() + " (expected Fixnum)");
            }
            RubyFixnum roundingMode = (RubyFixnum)value;
            if (roundingMode != clazz.fastGetConstant("ROUND_UP") && roundingMode != clazz.fastGetConstant("ROUND_DOWN") && roundingMode != clazz.fastGetConstant("ROUND_FLOOR") && roundingMode != clazz.fastGetConstant("ROUND_CEILING") && roundingMode != clazz.fastGetConstant("ROUND_HALF_UP") && roundingMode != clazz.fastGetConstant("ROUND_HALF_DOWN") && roundingMode != clazz.fastGetConstant("ROUND_HALF_EVEN")) {
                throw runtime.newTypeError("invalid rounding mode");
            }
            c.setInternalModuleVariable("vpRoundingMode", roundingMode);
            return c.searchInternalModuleVariable("vpRoundingMode");
        }
        throw runtime.newTypeError("first argument for BigDecimal#mode invalid");
    }

    private RoundingMode getRoundingMode(Ruby runtime) {
        RubyFixnum roundingMode = (RubyFixnum)runtime.fastGetClass("BigDecimal").searchInternalModuleVariable("vpRoundingMode");
        return RoundingMode.valueOf((int)roundingMode.getLongValue());
    }

    private RubyBigDecimal getVpValue(IRubyObject v, boolean must) {
        if (v instanceof RubyBigDecimal) {
            return (RubyBigDecimal)v;
        }
        if (v instanceof RubyFixnum || v instanceof RubyBignum) {
            String s = v.toString();
            return RubyBigDecimal.newInstance(this.getRuntime().fastGetClass("BigDecimal"), new IRubyObject[]{this.getRuntime().newString(s)});
        }
        if (must) {
            String err;
            if (this.isImmediate()) {
                ThreadContext context = this.getRuntime().getCurrentContext();
                err = RubyBigDecimal.inspect(context, this).toString();
            } else {
                err = this.getMetaClass().getBaseName();
            }
            throw this.getRuntime().newTypeError(err + " can't be coerced into BigDecimal");
        }
        return null;
    }

    @JRubyMethod(name={"new"}, required=1, optional=1, meta=true)
    public static RubyBigDecimal newInstance(IRubyObject recv, IRubyObject[] args) {
        BigDecimal decimal;
        if (args.length == 0) {
            decimal = new BigDecimal(0);
        } else {
            String strValue = args[0].convertToString().toString();
            if ("NaN".equals(strValue = strValue.trim())) {
                return RubyBigDecimal.newNaN(recv.getRuntime());
            }
            Matcher m = INFINITY_PATTERN.matcher(strValue);
            if (m.matches()) {
                int sign = 1;
                String signGroup = m.group(1);
                if ("-".equals(signGroup)) {
                    sign = -1;
                }
                return RubyBigDecimal.newInfinity(recv.getRuntime(), sign);
            }
            strValue = strValue.replaceFirst("[dD]", "E");
            strValue = strValue.replaceAll("_", "");
            strValue = NUMBER_PATTERN.matcher(strValue).replaceFirst("$1");
            try {
                decimal = new BigDecimal(strValue);
            }
            catch (NumberFormatException e) {
                decimal = new BigDecimal(0);
            }
            if (decimal.signum() == 0) {
                if (strValue.matches("^\\s*-.*")) {
                    return RubyBigDecimal.newZero(recv.getRuntime(), -1);
                }
                return RubyBigDecimal.newZero(recv.getRuntime(), 1);
            }
        }
        return new RubyBigDecimal(recv.getRuntime(), decimal);
    }

    private static RubyBigDecimal newZero(Ruby runtime, int sign) {
        RubyBigDecimal rbd = new RubyBigDecimal(runtime, BigDecimal.ZERO);
        rbd.zeroSign = sign < 0 ? -1 : 1;
        return rbd;
    }

    private static RubyBigDecimal newNaN(Ruby runtime) {
        RubyBigDecimal rbd = new RubyBigDecimal(runtime, BigDecimal.ZERO);
        rbd.isNaN = true;
        return rbd;
    }

    private static RubyBigDecimal newInfinity(Ruby runtime, int sign) {
        RubyBigDecimal rbd = new RubyBigDecimal(runtime, BigDecimal.ZERO);
        rbd.infinitySign = sign < 0 ? -1 : 1;
        return rbd;
    }

    private RubyBigDecimal setResult() {
        return this.setResult(0);
    }

    private RubyBigDecimal setResult(int scale) {
        int prec = RubyFixnum.fix2int(this.getRuntime().fastGetClass("BigDecimal").searchInternalModuleVariable("vpPrecLimit"));
        int prec2 = Math.max(scale, prec);
        if (prec2 > 0 && this.value.scale() > prec2 - this.getExponent()) {
            this.value = this.value.setScale(prec2 - this.getExponent(), 4);
        }
        return this;
    }

    @JRubyMethod(name={"hash"})
    public RubyFixnum hash() {
        return this.getRuntime().newFixnum(this.value.hashCode());
    }

    @JRubyMethod(name={"%", "modulo"}, required=1)
    public IRubyObject op_mod(ThreadContext context, IRubyObject arg) {
        Ruby runtime = context.getRuntime();
        if (this.isInfinity() || this.isNaN()) {
            return RubyBigDecimal.newNaN(runtime);
        }
        RubyBigDecimal val = this.getVpValue(arg, false);
        if (val == null) {
            return this.callCoerced(context, "%", arg, true);
        }
        if (val.isInfinity() || val.isNaN() || val.isZero()) {
            return RubyBigDecimal.newNaN(runtime);
        }
        BigDecimal modulo = this.value.remainder(val.value);
        if (modulo.signum() * val.value.signum() < 0) {
            modulo = modulo.add(val.value);
        }
        return new RubyBigDecimal(runtime, modulo).setResult();
    }

    @JRubyMethod(name={"remainder"}, required=1)
    public IRubyObject remainder(ThreadContext context, IRubyObject arg) {
        Ruby runtime = context.getRuntime();
        if (this.isInfinity() || this.isNaN()) {
            return RubyBigDecimal.newNaN(runtime);
        }
        RubyBigDecimal val = this.getVpValue(arg, false);
        if (val == null) {
            return this.callCoerced(context, "remainder", arg, true);
        }
        if (val.isInfinity() || val.isNaN() || val.isZero()) {
            return RubyBigDecimal.newNaN(runtime);
        }
        return new RubyBigDecimal(runtime, this.value.remainder(val.value)).setResult();
    }

    @JRubyMethod(name={"*"}, required=1)
    public IRubyObject op_mul(ThreadContext context, IRubyObject arg) {
        return this.mult2(context, arg, RubyFixnum.zero(context.getRuntime()));
    }

    @JRubyMethod(name={"mult"}, required=2)
    public IRubyObject mult2(ThreadContext context, IRubyObject b, IRubyObject n) {
        Ruby runtime = context.getRuntime();
        RubyBigDecimal val = this.getVpValue(b, false);
        if (val == null) {
            return this.callCoerced(context, "*", b);
        }
        int digits = RubyNumeric.fix2int(n);
        if (this.isNaN() || val.isNaN()) {
            return RubyBigDecimal.newNaN(runtime);
        }
        if (this.isInfinity() && val.isZero() || this.isZero() && val.isInfinity()) {
            return RubyBigDecimal.newNaN(runtime);
        }
        if (this.isZero() || val.isZero()) {
            int sign1 = this.isZero() ? this.zeroSign : this.value.signum();
            int sign2 = val.isZero() ? val.zeroSign : val.value.signum();
            return RubyBigDecimal.newZero(runtime, sign1 * sign2);
        }
        if (this.isInfinity() || val.isInfinity()) {
            int sign1 = this.isInfinity() ? this.infinitySign : this.value.signum();
            int sign2 = val.isInfinity() ? val.infinitySign : val.value.signum();
            return RubyBigDecimal.newInfinity(runtime, sign1 * sign2);
        }
        BigDecimal res = this.value.multiply(val.value);
        if (res.precision() > digits) {
            res = res.round(new MathContext(digits, RoundingMode.HALF_UP));
        }
        return new RubyBigDecimal(runtime, res).setResult();
    }

    @JRubyMethod(name={"**", "power"}, required=1)
    public IRubyObject op_pow(IRubyObject arg) {
        if (!(arg instanceof RubyFixnum)) {
            throw this.getRuntime().newTypeError("wrong argument type " + arg.getMetaClass() + " (expected Fixnum)");
        }
        if (this.isNaN() || this.isInfinity()) {
            return RubyBigDecimal.newNaN(this.getRuntime());
        }
        int times = RubyNumeric.fix2int(arg.convertToInteger());
        if (times < 0) {
            if (this.isZero()) {
                return RubyBigDecimal.newInfinity(this.getRuntime(), this.value.signum());
            }
            int precision = (-times + 4) * (this.getAllDigits().length() + 4);
            return new RubyBigDecimal(this.getRuntime(), this.value.pow(times, new MathContext(precision, RoundingMode.HALF_UP)));
        }
        return new RubyBigDecimal(this.getRuntime(), this.value.pow(times));
    }

    @JRubyMethod(name={"+"}, required=1, frame=true)
    public IRubyObject op_plus(ThreadContext context, IRubyObject b) {
        return this.addInternal(context, b, "add", RubyFixnum.zero(context.getRuntime()));
    }

    @JRubyMethod(name={"add"}, required=2, frame=true)
    public IRubyObject add2(ThreadContext context, IRubyObject b, IRubyObject digits) {
        return this.addInternal(context, b, "add", digits);
    }

    private IRubyObject addInternal(ThreadContext context, IRubyObject b, String op, IRubyObject digits) {
        Ruby runtime = context.getRuntime();
        int prec = this.getPositiveInt(context, digits);
        RubyBigDecimal val = this.getVpValue(b, false);
        if (val == null) {
            return this.callCoerced(context, "+", b, true);
        }
        IRubyObject res = this.handleAddSpecialValues(val);
        if (res != null) {
            return res;
        }
        RoundingMode roundMode = this.getRoundingMode(runtime);
        return new RubyBigDecimal(runtime, this.value.add(val.value, new MathContext(prec, roundMode)));
    }

    private int getPositiveInt(ThreadContext context, IRubyObject arg) {
        Ruby runtime = context.getRuntime();
        if (arg instanceof RubyFixnum) {
            int value = RubyNumeric.fix2int(arg);
            if (value < 0) {
                throw runtime.newArgumentError("argument must be positive");
            }
            return value;
        }
        throw runtime.newTypeError(arg, runtime.getFixnum());
    }

    private IRubyObject handleAddSpecialValues(RubyBigDecimal val) {
        int sign;
        if (this.isNaN() || val.isNaN) {
            return RubyBigDecimal.newNaN(this.getRuntime());
        }
        if (this.infinitySign * val.infinitySign > 0) {
            return this.isInfinity() ? this : val;
        }
        if (this.infinitySign * val.infinitySign < 0) {
            return RubyBigDecimal.newNaN(this.getRuntime());
        }
        if (this.infinitySign * val.infinitySign == 0 && (sign = this.infinitySign + val.infinitySign) != 0) {
            return RubyBigDecimal.newInfinity(this.getRuntime(), sign);
        }
        return null;
    }

    @JRubyMethod(name={"+@"})
    public IRubyObject op_uplus() {
        return this;
    }

    @JRubyMethod(name={"-"}, required=1)
    public IRubyObject op_minus(ThreadContext context, IRubyObject arg) {
        RubyBigDecimal val = this.getVpValue(arg, false);
        if (val == null) {
            return this.callCoerced(context, "-", arg);
        }
        RubyBigDecimal res = this.handleMinusSpecialValues(val);
        if (res != null) {
            return res;
        }
        return new RubyBigDecimal(this.getRuntime(), this.value.subtract(val.value)).setResult();
    }

    @JRubyMethod(name={"sub"}, required=2)
    public IRubyObject sub2(ThreadContext context, IRubyObject b, IRubyObject n) {
        RubyBigDecimal val = this.getVpValue(b, false);
        if (val == null) {
            return this.callCoerced(context, "-", b);
        }
        RubyBigDecimal res = this.handleMinusSpecialValues(val);
        if (res != null) {
            return res;
        }
        return new RubyBigDecimal(this.getRuntime(), this.value.subtract(val.value)).setResult();
    }

    private RubyBigDecimal handleMinusSpecialValues(RubyBigDecimal val) {
        if (this.isNaN() || val.isNaN()) {
            return RubyBigDecimal.newNaN(this.getRuntime());
        }
        if (this.infinitySign * val.infinitySign > 0) {
            return RubyBigDecimal.newNaN(this.getRuntime());
        }
        if (this.infinitySign * val.infinitySign < 0) {
            return this;
        }
        if (this.infinitySign * val.infinitySign == 0) {
            if (this.isInfinity()) {
                return this;
            }
            if (val.isInfinity()) {
                return RubyBigDecimal.newInfinity(this.getRuntime(), val.infinitySign * -1);
            }
            int sign = this.infinitySign + val.infinitySign;
            if (sign != 0) {
                return RubyBigDecimal.newInfinity(this.getRuntime(), sign);
            }
        }
        return null;
    }

    @JRubyMethod(name={"-@"})
    public IRubyObject op_uminus() {
        Ruby runtime = this.getRuntime();
        if (this.isNaN()) {
            return RubyBigDecimal.newNaN(runtime);
        }
        if (this.isInfinity()) {
            return RubyBigDecimal.newInfinity(runtime, -this.infinitySign);
        }
        if (this.isZero()) {
            return RubyBigDecimal.newZero(runtime, -this.zeroSign);
        }
        return new RubyBigDecimal(this.getRuntime(), this.value.negate());
    }

    @JRubyMethod(name={"/", "quo"})
    public IRubyObject op_quo(ThreadContext context, IRubyObject other) {
        return this.op_div(context, other, this.getRuntime().newFixnum(200));
    }

    @JRubyMethod(name={"div"})
    public IRubyObject op_div(ThreadContext context, IRubyObject other) {
        RubyBigDecimal val = this.getVpValue(other, false);
        if (val == null) {
            return this.callCoerced(context, "div", other);
        }
        if (this.isNaN() || val.isZero() || val.isNaN()) {
            return RubyBigDecimal.newNaN(this.getRuntime());
        }
        if (this.isInfinity() || val.isInfinity()) {
            return RubyBigDecimal.newNaN(this.getRuntime());
        }
        return new RubyBigDecimal(this.getRuntime(), this.value.divideToIntegralValue(val.value)).setResult();
    }

    @JRubyMethod(name={"div"})
    public IRubyObject op_div(ThreadContext context, IRubyObject other, IRubyObject digits) {
        int scale = RubyNumeric.fix2int(digits);
        RubyBigDecimal val = this.getVpValue(other, false);
        if (val == null) {
            return this.callCoerced(context, "/", other);
        }
        if (this.isNaN() || this.isZero() && val.isZero() || val.isNaN()) {
            return RubyBigDecimal.newNaN(this.getRuntime());
        }
        if (val.isZero()) {
            int sign1 = this.isInfinity() ? this.infinitySign : this.value.signum();
            return RubyBigDecimal.newInfinity(this.getRuntime(), sign1 * val.zeroSign);
        }
        if (this.isInfinity() && !val.isInfinity()) {
            return RubyBigDecimal.newInfinity(this.getRuntime(), this.infinitySign * val.value.signum());
        }
        if (!this.isInfinity() && val.isInfinity()) {
            return RubyBigDecimal.newZero(this.getRuntime(), this.value.signum() * val.infinitySign);
        }
        if (this.isInfinity() && val.isInfinity()) {
            return RubyBigDecimal.newNaN(this.getRuntime());
        }
        if (scale == 0) {
            return this.op_quo(context, other);
        }
        int prec = Math.max(200, scale);
        return new RubyBigDecimal(this.getRuntime(), this.value.divide(val.value, new MathContext(prec, RoundingMode.HALF_UP))).setResult(scale);
    }

    private IRubyObject cmp(ThreadContext context, IRubyObject r, char op) {
        int e = 0;
        RubyBigDecimal rb = this.getVpValue(r, false);
        if (rb == null) {
            IRubyObject ee = this.callCoerced(context, "<=>", r);
            if (ee.isNil()) {
                return this.getRuntime().getNil();
            }
            e = RubyNumeric.fix2int(ee);
        } else {
            if (this.isNaN() | rb.isNaN()) {
                return this.getRuntime().getNil();
            }
            e = this.infinitySign != 0 || rb.infinitySign != 0 ? this.infinitySign - rb.infinitySign : this.value.compareTo(rb.value);
        }
        switch (op) {
            case '*': {
                return this.getRuntime().newFixnum(e);
            }
            case '=': {
                return e == 0 ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
            }
            case '!': {
                return e != 0 ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
            }
            case 'G': {
                return e >= 0 ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
            }
            case '>': {
                return e > 0 ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
            }
            case 'L': {
                return e <= 0 ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
            }
            case '<': {
                return e < 0 ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
            }
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"<=>"}, required=1)
    public IRubyObject op_cmp(ThreadContext context, IRubyObject arg) {
        return this.cmp(context, arg, '*');
    }

    @JRubyMethod(name={"eql?", "==", "==="}, required=1)
    public IRubyObject eql_p(ThreadContext context, IRubyObject arg) {
        return this.cmp(context, arg, '=');
    }

    @JRubyMethod(name={"<"}, required=1)
    public IRubyObject op_lt(ThreadContext context, IRubyObject arg) {
        return this.cmp(context, arg, '<');
    }

    @JRubyMethod(name={"<="}, required=1)
    public IRubyObject op_le(ThreadContext context, IRubyObject arg) {
        return this.cmp(context, arg, 'L');
    }

    @JRubyMethod(name={">"}, required=1)
    public IRubyObject op_gt(ThreadContext context, IRubyObject arg) {
        return this.cmp(context, arg, '>');
    }

    @JRubyMethod(name={">="}, required=1)
    public IRubyObject op_ge(ThreadContext context, IRubyObject arg) {
        return this.cmp(context, arg, 'G');
    }

    @JRubyMethod(name={"abs"})
    public IRubyObject abs() {
        Ruby runtime = this.getRuntime();
        if (this.isNaN) {
            return RubyBigDecimal.newNaN(runtime);
        }
        if (this.isInfinity()) {
            return RubyBigDecimal.newInfinity(runtime, 1);
        }
        return new RubyBigDecimal(this.getRuntime(), this.value.abs()).setResult();
    }

    @JRubyMethod(name={"ceil"}, optional=1)
    public IRubyObject ceil(IRubyObject[] args) {
        if (this.isNaN) {
            return RubyBigDecimal.newNaN(this.getRuntime());
        }
        if (this.isInfinity()) {
            return RubyBigDecimal.newInfinity(this.getRuntime(), this.infinitySign);
        }
        int n = 0;
        if (args.length > 0) {
            n = RubyNumeric.fix2int(args[0]);
        }
        if (this.value.scale() > n) {
            return new RubyBigDecimal(this.getRuntime(), this.value.setScale(n, RoundingMode.CEILING));
        }
        return this;
    }

    @JRubyMethod(name={"coerce"}, required=1)
    public IRubyObject coerce(IRubyObject other) {
        RubyArray obj = other instanceof RubyFloat ? this.getRuntime().newArray(other, this.to_f()) : this.getRuntime().newArray(this.getVpValue(other, true), this);
        return obj;
    }

    public double getDoubleValue() {
        return this.value.doubleValue();
    }

    public long getLongValue() {
        return this.value.longValue();
    }

    public RubyNumeric multiplyWith(ThreadContext context, RubyInteger value) {
        return (RubyNumeric)this.op_mul(context, value);
    }

    public RubyNumeric multiplyWith(ThreadContext context, RubyFloat value) {
        return (RubyNumeric)this.op_mul(context, value);
    }

    public RubyNumeric multiplyWith(ThreadContext context, RubyBignum value) {
        return (RubyNumeric)this.op_mul(context, value);
    }

    @JRubyMethod(name={"divmod"}, required=1)
    public IRubyObject divmod(ThreadContext context, IRubyObject other) {
        Ruby runtime = context.getRuntime();
        if (this.isInfinity() || this.isNaN()) {
            return RubyArray.newArray(runtime, RubyBigDecimal.newNaN(runtime), RubyBigDecimal.newNaN(runtime));
        }
        RubyBigDecimal val = this.getVpValue(other, false);
        if (val == null) {
            return this.callCoerced(context, "divmod", other, true);
        }
        if (val.isInfinity() || val.isNaN() || val.isZero()) {
            return RubyArray.newArray(runtime, RubyBigDecimal.newNaN(runtime), RubyBigDecimal.newNaN(runtime));
        }
        BigDecimal[] divmod = this.value.divideAndRemainder(val.value);
        BigDecimal div = divmod[0];
        BigDecimal mod = divmod[1];
        if (mod.signum() * val.value.signum() < 0) {
            div = div.subtract(BigDecimal.ONE);
            mod = mod.add(val.value);
        }
        return RubyArray.newArray(runtime, new RubyBigDecimal(runtime, div), new RubyBigDecimal(runtime, mod));
    }

    @JRubyMethod(name={"exponent"})
    public IRubyObject exponent() {
        return this.getRuntime().newFixnum(this.getExponent());
    }

    @JRubyMethod(name={"finite?"})
    public IRubyObject finite_p() {
        if (this.isNaN()) {
            return this.getRuntime().getFalse();
        }
        return this.getRuntime().newBoolean(!this.isInfinity());
    }

    @JRubyMethod(name={"floor"}, optional=1)
    public IRubyObject floor(IRubyObject[] args) {
        if (this.isNaN) {
            return RubyBigDecimal.newNaN(this.getRuntime());
        }
        if (this.isInfinity()) {
            return RubyBigDecimal.newInfinity(this.getRuntime(), this.infinitySign);
        }
        int n = 0;
        if (args.length > 0) {
            n = RubyNumeric.fix2int(args[0]);
        }
        if (this.value.scale() > n) {
            return new RubyBigDecimal(this.getRuntime(), this.value.setScale(n, RoundingMode.FLOOR));
        }
        return this;
    }

    @JRubyMethod(name={"frac"})
    public IRubyObject frac() {
        if (this.isNaN) {
            return RubyBigDecimal.newNaN(this.getRuntime());
        }
        if (this.isInfinity()) {
            return RubyBigDecimal.newInfinity(this.getRuntime(), this.infinitySign);
        }
        if (this.value.scale() > 0 && this.value.precision() < this.value.scale()) {
            return new RubyBigDecimal(this.getRuntime(), this.value);
        }
        BigDecimal val = this.value.subtract(((RubyBigDecimal)this.fix()).value);
        return new RubyBigDecimal(this.getRuntime(), val);
    }

    @JRubyMethod(name={"infinite?"})
    public IRubyObject infinite_p() {
        if (this.infinitySign == 0) {
            return this.getRuntime().getNil();
        }
        return this.getRuntime().newFixnum(this.infinitySign);
    }

    @JRubyMethod(name={"inspect"})
    public IRubyObject inspect(ThreadContext context) {
        StringBuilder val = new StringBuilder("#<BigDecimal:").append(Integer.toHexString(System.identityHashCode(this))).append(",");
        val.append("'").append(this.callMethod(context, MethodIndex.TO_S, "to_s")).append("'").append(",");
        val.append(this.getSignificantDigits().length()).append("(");
        int len = this.getAllDigits().length();
        int pow = len / 4;
        val.append((pow + 1) * 4).append(")").append(">");
        return this.getRuntime().newString(val.toString());
    }

    @JRubyMethod(name={"nan?"})
    public IRubyObject nan_p() {
        return this.getRuntime().newBoolean(this.isNaN);
    }

    @JRubyMethod(name={"nonzero?"})
    public IRubyObject nonzero_p() {
        return this.isZero() ? this.getRuntime().getNil() : this;
    }

    @JRubyMethod(name={"precs"})
    public IRubyObject precs() {
        Ruby runtime = this.getRuntime();
        IRubyObject[] array = new IRubyObject[2];
        array[0] = runtime.newFixnum(this.getSignificantDigits().length());
        int len = this.getAllDigits().length();
        int pow = len / 4;
        array[1] = runtime.newFixnum((pow + 1) * 4);
        return RubyArray.newArray(runtime, array);
    }

    @JRubyMethod(name={"round"}, optional=2)
    public IRubyObject round(IRubyObject[] args) {
        int mode;
        int scale = args.length > 0 ? RubyBigDecimal.num2int(args[0]) : 0;
        int n = mode = args.length > 1 ? this.javaRoundingModeFromRubyRoundingMode(args[1]) : 4;
        if (scale < 0) {
            BigDecimal normalized = this.value.movePointRight(scale);
            BigDecimal rounded = normalized.setScale(0, mode);
            return new RubyBigDecimal(this.getRuntime(), rounded.movePointLeft(scale));
        }
        return new RubyBigDecimal(this.getRuntime(), this.value.setScale(scale, mode));
    }

    private int javaRoundingModeFromRubyRoundingMode(IRubyObject arg) {
        return RubyBigDecimal.num2int(arg);
    }

    @JRubyMethod(name={"sign"})
    public IRubyObject sign() {
        if (this.isNaN()) {
            return this.getMetaClass().fastGetConstant("SIGN_NaN");
        }
        if (this.isInfinity()) {
            if (this.infinitySign < 0) {
                return this.getMetaClass().fastGetConstant("SIGN_NEGATIVE_INFINITE");
            }
            return this.getMetaClass().fastGetConstant("SIGN_POSITIVE_INFINITE");
        }
        if (this.isZero()) {
            if (this.zeroSign < 0) {
                return this.getMetaClass().fastGetConstant("SIGN_NEGATIVE_ZERO");
            }
            return this.getMetaClass().fastGetConstant("SIGN_POSITIVE_ZERO");
        }
        if (this.value.signum() < 0) {
            return this.getMetaClass().fastGetConstant("SIGN_NEGATIVE_FINITE");
        }
        return this.getMetaClass().fastGetConstant("SIGN_POSITIVE_FINITE");
    }

    @JRubyMethod(name={"split"})
    public RubyArray split() {
        RubyFixnum exp;
        RubyString digits;
        Ruby runtime = this.getRuntime();
        IRubyObject[] array = new IRubyObject[4];
        RubyFixnum sign = this.isNaN ? RubyFixnum.zero(runtime) : (this.isInfinity() ? runtime.newFixnum(this.infinitySign) : (this.isZero() ? runtime.newFixnum(this.zeroSign) : runtime.newFixnum(this.value.signum())));
        array[0] = sign;
        if (this.isNaN()) {
            digits = runtime.newString("NaN");
            exp = RubyFixnum.zero(runtime);
        } else if (this.isInfinity()) {
            digits = runtime.newString("Infinity");
            exp = RubyFixnum.zero(runtime);
        } else if (this.isZero()) {
            digits = runtime.newString("0");
            exp = RubyFixnum.zero(runtime);
        } else {
            digits = runtime.newString(this.getSignificantDigits());
            exp = runtime.newFixnum(this.getExponent());
        }
        array[1] = digits;
        array[3] = exp;
        array[2] = runtime.newFixnum(10);
        return RubyArray.newArray(runtime, array);
    }

    private String getSignificantDigits() {
        BigDecimal val = this.value.abs().stripTrailingZeros();
        return val.unscaledValue().toString();
    }

    private String getAllDigits() {
        BigDecimal val = this.value.abs();
        return val.unscaledValue().toString();
    }

    private int getExponent() {
        if (this.isZero()) {
            return 0;
        }
        BigDecimal val = this.value.abs().stripTrailingZeros();
        return val.precision() - val.scale();
    }

    @JRubyMethod(name={"sqrt"}, required=1)
    public IRubyObject sqrt(IRubyObject arg) {
        Ruby runtime = this.getRuntime();
        if (this.isNaN()) {
            throw runtime.newFloatDomainError("(VpSqrt) SQRT(NaN value)");
        }
        if (this.isInfinity() && this.infinitySign < 0 || this.value.signum() < 0) {
            throw runtime.newFloatDomainError("(VpSqrt) SQRT(negative value)");
        }
        if (this.isInfinity() && this.infinitySign > 0) {
            return RubyBigDecimal.newInfinity(runtime, 1);
        }
        int n = RubyNumeric.fix2int(arg);
        if (n < 0) {
            throw runtime.newArgumentError("argument must be positive");
        }
        return new RubyBigDecimal(this.getRuntime(), RubyBigDecimal.bigSqrt(this.value, new MathContext(n += 4, RoundingMode.HALF_UP))).setResult();
    }

    @JRubyMethod(name={"to_f"})
    public IRubyObject to_f() {
        if (this.isNaN()) {
            return RubyFloat.newFloat(this.getRuntime(), Double.NaN);
        }
        if (this.isInfinity()) {
            return RubyFloat.newFloat(this.getRuntime(), this.infinitySign < 0 ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY);
        }
        if (this.isZero()) {
            return RubyFloat.newFloat(this.getRuntime(), this.zeroSign < 0 ? -0.0 : 0.0);
        }
        return RubyFloat.newFloat(this.getRuntime(), this.value.doubleValue());
    }

    @JRubyMethod(name={"to_i", "to_int"})
    public IRubyObject to_int() {
        if (this.isNaN() || this.infinitySign != 0) {
            return this.getRuntime().getNil();
        }
        try {
            return RubyNumeric.int2fix(this.getRuntime(), this.value.longValueExact());
        }
        catch (ArithmeticException ae) {
            return RubyBignum.bignorm(this.getRuntime(), this.value.toBigInteger());
        }
    }

    private String removeTrailingZeroes(String in) {
        while (in.length() > 0 && in.charAt(in.length() - 1) == '0') {
            in = in.substring(0, in.length() - 1);
        }
        return in;
    }

    public static boolean formatHasLeadingPlus(String format) {
        return format.startsWith("+");
    }

    public static boolean formatHasLeadingSpace(String format) {
        return format.startsWith(" ");
    }

    public static boolean formatHasFloatingPointNotation(String format) {
        return format.endsWith("F");
    }

    public static int formatFractionalDigitGroups(String format) {
        int groups = 0;
        Pattern p = Pattern.compile("(\\+| )?(\\d+)(E|F)?");
        Matcher m = p.matcher(format);
        if (m.matches()) {
            groups = Integer.parseInt(m.group(2));
        }
        return groups;
    }

    private boolean hasArg(IRubyObject[] args) {
        return args.length != 0 && !args[0].isNil();
    }

    private String format(IRubyObject[] args) {
        return args[0].toString();
    }

    private String firstArgument(IRubyObject[] args) {
        if (this.hasArg(args)) {
            return this.format(args);
        }
        return null;
    }

    private boolean posSpace(String arg) {
        if (null != arg) {
            return RubyBigDecimal.formatHasLeadingSpace(arg);
        }
        return false;
    }

    private boolean posSign(String arg) {
        if (null != arg) {
            return RubyBigDecimal.formatHasLeadingPlus(arg) || this.posSpace(arg);
        }
        return false;
    }

    private boolean asEngineering(String arg) {
        if (null != arg) {
            return !RubyBigDecimal.formatHasFloatingPointNotation(arg);
        }
        return true;
    }

    private int groups(String arg) {
        if (null != arg) {
            return RubyBigDecimal.formatFractionalDigitGroups(arg);
        }
        return 0;
    }

    private boolean isZero() {
        return !this.isNaN() && !this.isInfinity() && this.value.signum() == 0;
    }

    private boolean isNaN() {
        return this.isNaN;
    }

    private boolean isInfinity() {
        return this.infinitySign != 0;
    }

    private String unscaledValue() {
        return this.value.abs().unscaledValue().toString();
    }

    private IRubyObject engineeringValue(String arg) {
        int exponent = this.getExponent();
        int signum = this.value.signum();
        StringBuilder build = new StringBuilder();
        build.append(signum == -1 ? "-" : (signum == 1 ? (this.posSign(arg) ? (this.posSpace(arg) ? " " : "+") : "") : ""));
        build.append("0.");
        if (0 == this.groups(arg)) {
            String s = this.removeTrailingZeroes(this.unscaledValue());
            if ("".equals(s)) {
                build.append("0");
            } else {
                build.append(s);
            }
        } else {
            String sep = "";
            for (int index = 0; index < this.unscaledValue().length(); index += this.groups(arg)) {
                int next = index + this.groups(arg);
                if (next > this.unscaledValue().length()) {
                    next = this.unscaledValue().length();
                }
                build.append(sep).append(this.unscaledValue().substring(index, next));
                sep = " ";
            }
        }
        build.append("E").append(exponent);
        return this.getRuntime().newString(build.toString());
    }

    private IRubyObject floatingPointValue(String arg) {
        String[] values = this.value.abs().stripTrailingZeros().toPlainString().split("\\.");
        String whole = "0";
        if (values.length > 0) {
            whole = values[0];
        }
        String after = "0";
        if (values.length > 1) {
            after = values[1];
        }
        int signum = this.value.signum();
        StringBuilder build = new StringBuilder();
        build.append(signum == -1 ? "-" : (signum == 1 ? (this.posSign(arg) ? (this.posSpace(arg) ? " " : "+") : "") : ""));
        if (this.groups(arg) == 0) {
            build.append(whole);
            if (null != after) {
                build.append(".").append(after);
            }
        } else {
            int next;
            int index;
            String sep = "";
            for (index = 0; index < whole.length(); index += this.groups(arg)) {
                next = index + this.groups(arg);
                if (next > whole.length()) {
                    next = whole.length();
                }
                build.append(sep).append(whole.substring(index, next));
                sep = " ";
            }
            if (null != after) {
                build.append(".");
                sep = "";
                for (index = 0; index < after.length(); index += this.groups(arg)) {
                    next = index + this.groups(arg);
                    if (next > after.length()) {
                        next = after.length();
                    }
                    build.append(sep).append(after.substring(index, next));
                    sep = " ";
                }
            }
        }
        return this.getRuntime().newString(build.toString());
    }

    @JRubyMethod(name={"to_s"}, optional=1)
    public IRubyObject to_s(IRubyObject[] args) {
        String arg = this.firstArgument(args);
        if (this.isNaN()) {
            return this.getRuntime().newString("NaN");
        }
        if (this.infinitySign != 0) {
            if (this.infinitySign == -1) {
                return this.getRuntime().newString("-Infinity");
            }
            return this.getRuntime().newString("Infinity");
        }
        if (this.isZero()) {
            String zero = "0.0";
            if (this.zeroSign < 0) {
                zero = "-" + zero;
            }
            return this.getRuntime().newString(zero);
        }
        if (this.asEngineering(arg)) {
            return this.engineeringValue(arg);
        }
        return this.floatingPointValue(arg);
    }

    @JRubyMethod
    public IRubyObject fix() {
        return this.truncate(RubyFixnum.zero(this.getRuntime()));
    }

    @JRubyMethod
    public IRubyObject truncate() {
        return this.truncate(RubyFixnum.zero(this.getRuntime()));
    }

    @JRubyMethod
    public IRubyObject truncate(IRubyObject arg) {
        if (this.isNaN) {
            return RubyBigDecimal.newNaN(this.getRuntime());
        }
        if (this.isInfinity()) {
            return RubyBigDecimal.newInfinity(this.getRuntime(), this.infinitySign);
        }
        int n = RubyNumeric.fix2int(arg);
        int precision = this.value.precision() - this.value.scale() + n;
        if (precision > 0) {
            return new RubyBigDecimal(this.getRuntime(), this.value.round(new MathContext(precision, RoundingMode.DOWN)));
        }
        return new RubyBigDecimal(this.getRuntime(), BigDecimal.ZERO);
    }

    @JRubyMethod(name={"zero?"})
    public IRubyObject zero_p() {
        return this.getRuntime().newBoolean(this.isZero());
    }

    public static BigDecimal bigSqrt(BigDecimal squarD, MathContext rootMC) {
        int biLen;
        int sign = squarD.signum();
        if (sign == -1) {
            throw new ArithmeticException("Square root of a negative number: " + squarD);
        }
        if (sign == 0) {
            return squarD.round(rootMC);
        }
        int prec = rootMC.getPrecision();
        if (prec == 0) {
            throw new IllegalArgumentException("Most roots won't have infinite precision = 0");
        }
        int BITS = 62;
        int nInit = 16;
        MathContext nMC = new MathContext(18, RoundingMode.HALF_DOWN);
        BigDecimal x = null;
        BigDecimal e = null;
        BigDecimal v = null;
        BigDecimal g = null;
        BigInteger bi = squarD.unscaledValue();
        int shift = Math.max(0, biLen - BITS + ((biLen = bi.bitLength()) % 2 == 0 ? 0 : 1));
        bi = bi.shiftRight(shift);
        double root = Math.sqrt(bi.doubleValue());
        BigDecimal halfBack = new BigDecimal(BigInteger.ONE.shiftLeft(shift / 2));
        int scale = squarD.scale();
        if (scale % 2 == 1) {
            root *= 3.1622776601683795;
        }
        scale = (int)Math.floor((double)scale / 2.0);
        x = new BigDecimal(root, nMC);
        x = x.multiply(halfBack, nMC);
        if (scale != 0) {
            x = x.movePointLeft(scale);
        }
        if (prec < nInit) {
            return x.round(rootMC);
        }
        v = BigDecimal.ONE.divide(TWO.multiply(x), nMC);
        ArrayList<Integer> nPrecs = new ArrayList<Integer>();
        assert (nInit > 3) : "Never ending loop!";
        int m = prec + 1;
        while (m > nInit) {
            nPrecs.add(m);
            m = m / 2 + (m > 100 ? 1 : 2);
        }
        for (int i = nPrecs.size() - 1; i > -1; --i) {
            nMC = new MathContext((Integer)nPrecs.get(i), i % 2 == 1 ? RoundingMode.HALF_UP : RoundingMode.HALF_DOWN);
            e = squarD.subtract(x.multiply(x, nMC), nMC);
            if (i == 0) {
                x = x.add(e.multiply(v, rootMC), rootMC);
                break;
            }
            x = x.add(e.multiply(v, nMC));
            g = BigDecimal.ONE.subtract(TWO.multiply(x).multiply(v, nMC));
            v = v.add(g.multiply(v, nMC));
        }
        return x;
    }

    public static class BigDecimalKernelMethods {
        @JRubyMethod(name={"BigDecimal"}, rest=true, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject newBigDecimal(IRubyObject recv, IRubyObject[] args) {
            return RubyBigDecimal.newBigDecimal(recv, args, Block.NULL_BLOCK);
        }
    }
}

