/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.classfile.Visitor;

public final class ConstantUtf8
extends Constant {
    private final String bytes;
    private static final int MAX_CACHE_ENTRIES = 2000;
    private static final int INITIAL_CACHE_CAPACITY = 2666;
    private static HashMap<String, ConstantUtf8> cache;
    private static int considered;
    private static int hits;
    private static int skipped;
    private static int created;
    static final boolean BCEL_STATISTICS;
    static final boolean BCEL_DONT_CACHE;

    static {
        considered = 0;
        hits = 0;
        skipped = 0;
        created = 0;
        BCEL_STATISTICS = Boolean.getBoolean("bcel.statistics");
        BCEL_DONT_CACHE = Boolean.getBoolean("bcel.dontCache");
        if (BCEL_STATISTICS) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void run() {
                    System.err.println("Cache hit " + hits + "/" + considered + ", " + skipped + " skipped");
                    System.err.println("Total of " + created + " ConstantUtf8 objects created");
                }
            });
        }
    }

    public static synchronized ConstantUtf8 getCachedInstance(String s) {
        ConstantUtf8 result;
        if (BCEL_DONT_CACHE || s.length() > 200) {
            ++skipped;
            return new ConstantUtf8(s);
        }
        ++considered;
        if (cache == null) {
            cache = new LinkedHashMap<String, ConstantUtf8>(2666, 0.75f, true){

                @Override
                protected boolean removeEldestEntry(Map.Entry eldest) {
                    return this.size() > 2000;
                }
            };
        }
        if ((result = cache.get(s)) != null) {
            ++hits;
            return result;
        }
        result = new ConstantUtf8(s);
        cache.put(s, result);
        return result;
    }

    public static ConstantUtf8 getInstance(String s) {
        return ConstantUtf8.getCachedInstance(s);
    }

    public static ConstantUtf8 getInstance(DataInputStream file) throws IOException {
        return ConstantUtf8.getInstance(file.readUTF());
    }

    public ConstantUtf8(ConstantUtf8 c) {
        this(c.getBytes());
    }

    ConstantUtf8(DataInputStream file) throws IOException {
        super((byte)1);
        this.bytes = file.readUTF();
        ++created;
    }

    public ConstantUtf8(String bytes) {
        super((byte)1);
        if (bytes == null) {
            throw new IllegalArgumentException("bytes must not be null!");
        }
        this.bytes = bytes;
        ++created;
    }

    public void accept(Visitor v) {
        v.visitConstantUtf8(this);
    }

    public final void dump(DataOutputStream file) throws IOException {
        file.writeByte(this.tag);
        file.writeUTF(this.bytes);
    }

    public final String getBytes() {
        return this.bytes;
    }

    public final void setBytes(String bytes) {
        throw new UnsupportedOperationException();
    }

    public final String toString() {
        return String.valueOf(super.toString()) + "(\"" + Utility.replace(this.bytes, "\n", "\\n") + "\")";
    }
}

