/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.security.x509;

import com.iplanet.security.util.DerEncoder;
import com.iplanet.security.util.DerInputStream;
import com.iplanet.security.util.DerOutputStream;
import com.iplanet.security.util.DerValue;
import com.iplanet.security.util.ObjectIdentifier;
import com.iplanet.security.x509.CertParseError;
import com.iplanet.security.x509.LdapDNStrConverter;
import com.iplanet.security.x509.X500NameAttrMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import sun.io.ByteToCharConverter;

public final class AVA
implements DerEncoder {
    ObjectIdentifier oid;
    DerValue value;

    public AVA(String avaString) throws IOException {
        AVA ava = LdapDNStrConverter.getDefault().parseAVA(avaString);
        this.oid = ava.getOid();
        this.value = ava.getValue();
    }

    public AVA(String avaString, byte[] tags) throws IOException {
        AVA ava = LdapDNStrConverter.getDefault().parseAVA(avaString, tags);
        this.oid = ava.getOid();
        this.value = ava.getValue();
    }

    public AVA(String avaString, LdapDNStrConverter ldapDNStrConverter) throws IOException {
        AVA ava = ldapDNStrConverter.parseAVA(avaString);
        this.oid = ava.getOid();
        this.value = ava.getValue();
    }

    public AVA(ObjectIdentifier type, DerValue val) throws IOException {
        this.oid = type;
        this.value = val;
    }

    public AVA(InputStream in) throws IOException {
        ByteToCharConverter bcc;
        StringBuffer temp = new StringBuffer();
        byte[] buf = new byte[in.available()];
        in.read(buf);
        try {
            bcc = ByteToCharConverter.getConverter((String)"UTF8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IOException("UTF8 encoding not supported");
        }
        char[] converted_chars = bcc.convertAll(buf);
        temp.append(converted_chars);
        AVA a = LdapDNStrConverter.getDefault().parseAVA(temp.toString());
        this.oid = a.getOid();
        this.value = a.getValue();
    }

    public AVA(DerInputStream in) throws IOException {
        DerValue assertion = in.getDerValue();
        if (assertion.tag != 48) {
            throw new CertParseError("X500 AVA, not a sequence");
        }
        ObjectIdentifier o = assertion.data.getOID();
        this.oid = X500NameAttrMap.getDefault().getOid(o);
        if (this.oid == null) {
            this.oid = o;
        }
        this.value = assertion.data.getDerValue();
        if (assertion.data.available() != 0) {
            throw new CertParseError("AVA, extra bytes = " + assertion.data.available());
        }
    }

    public boolean equals(AVA other) {
        return this.oid.equals(other.oid) && this.value.equals(other.value);
    }

    public boolean equals(Object other) {
        if (other instanceof AVA) {
            return this.equals((AVA)other);
        }
        return false;
    }

    public void encode(DerOutputStream out) throws IOException {
        this.derEncode(out);
    }

    public void derEncode(OutputStream out) throws IOException {
        DerOutputStream tmp = new DerOutputStream();
        DerOutputStream tmp2 = new DerOutputStream();
        tmp.putOID(this.oid);
        this.value.encode(tmp);
        tmp2.write((byte)48, tmp);
        out.write(tmp2.toByteArray());
    }

    public String toLdapDNString() throws IOException {
        LdapDNStrConverter v = LdapDNStrConverter.getDefault();
        return v.encodeAVA(this);
    }

    public String toLdapDNString(LdapDNStrConverter ldapDNStrConverter) throws IOException {
        return ldapDNStrConverter.encodeAVA(this);
    }

    public String toString() {
        String s;
        try {
            s = this.toLdapDNString();
        }
        catch (IOException e) {
            return null;
        }
        return s;
    }

    public ObjectIdentifier getOid() {
        return this.oid;
    }

    public DerValue getValue() {
        return this.value;
    }
}

