/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.util;

import com.iplanet.am.util.JSSInit;
import com.iplanet.services.util.AMEncryption;
import com.iplanet.services.util.ConfigurableKey;
import com.sun.identity.shared.debug.Debug;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Enumeration;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.crypto.Algorithm;
import org.mozilla.jss.crypto.Cipher;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.EncryptionAlgorithm;
import org.mozilla.jss.crypto.IVParameterSpec;
import org.mozilla.jss.crypto.KeyGenAlgorithm;
import org.mozilla.jss.crypto.KeyGenerator;
import org.mozilla.jss.crypto.PBEAlgorithm;
import org.mozilla.jss.crypto.PBEKeyGenParams;
import org.mozilla.jss.crypto.SymmetricKey;
import org.mozilla.jss.util.Password;

public class JSSEncryption
implements AMEncryption,
ConfigurableKey {
    private static final byte VERSION = 1;
    private static final String DEFAULT_KEYGEN_ALG = "PBE_MD5_DES_CBC";
    private static final String DEFAULT_ENCYPTION_ALG = "DES_CBC_PAD";
    private static final String[] KEYGEN_ALGS;
    private static int NUM_KEYGEN_ALG;
    private static final String[] ENCRYPTION_ALGS;
    private static int NUM_ENCRYPTION_ALG;
    private SymmetricKey[] sKeys = null;
    private IVParameterSpec[] ivParamSpecs = null;
    private static CryptoToken mToken;
    private static Debug debug;
    static String method;

    JSSEncryption() {
    }

    private static CryptoToken findToken() throws CryptoManager.NotInitializedException {
        Object token = null;
        CryptoManager cm = CryptoManager.getInstance();
        Enumeration e = cm.getTokensSupportingAlgorithm((Algorithm)JSSEncryption.getEncryptionAlg(DEFAULT_ENCYPTION_ALG));
        while (e.hasMoreElements()) {
            CryptoToken tok = (CryptoToken)e.nextElement();
            boolean foundToken = true;
            for (int i = 0; i < NUM_KEYGEN_ALG; ++i) {
                if (tok.doesAlgorithm((Algorithm)JSSEncryption.getKeyGenAlg(KEYGEN_ALGS[i]))) continue;
                foundToken = false;
                break;
            }
            if (!foundToken) continue;
            return tok;
        }
        return null;
    }

    public void setPassword(String password) throws Exception {
        this.initSymmetricKeysAndInitializationVectors(password);
    }

    private void initSymmetricKeysAndInitializationVectors(String password) {
        this.sKeys = new SymmetricKey[NUM_KEYGEN_ALG];
        this.ivParamSpecs = new IVParameterSpec[NUM_KEYGEN_ALG];
        byte[] salt = new byte[]{1, 1, 1, 1, 1, 1, 1, 1};
        Password pass = new Password(password.toCharArray());
        for (int i = 0; i < NUM_KEYGEN_ALG; ++i) {
            try {
                PBEAlgorithm keyAlg = JSSEncryption.getKeyGenAlg(KEYGEN_ALGS[i]);
                KeyGenerator kg = mToken.getKeyGenerator((KeyGenAlgorithm)keyAlg);
                PBEKeyGenParams kgp = new PBEKeyGenParams(pass, salt, 5);
                kg.initialize((AlgorithmParameterSpec)kgp);
                this.sKeys[i] = kg.generate();
                this.ivParamSpecs[i] = new IVParameterSpec(kg.generatePBE_IV());
                if (!debug.messageEnabled()) continue;
                debug.message("Created symKey successfully : " + KEYGEN_ALGS[i]);
                continue;
            }
            catch (Exception e) {
                debug.error("Failed creating symKey : " + KEYGEN_ALGS[i], e);
            }
        }
        pass.clear();
    }

    private SymmetricKey getSymmetricKey(int type) {
        if (type >= 0 && type < NUM_KEYGEN_ALG) {
            return this.sKeys[type];
        }
        return null;
    }

    private IVParameterSpec getIVParameterSpec(int type) {
        if (type >= 0 && type < NUM_KEYGEN_ALG) {
            return this.ivParamSpecs[type];
        }
        return null;
    }

    public byte[] encrypt(byte[] clearText) {
        return this.encode(clearText);
    }

    public byte[] decrypt(byte[] encoded) {
        return this.decode(encoded);
    }

    private byte[] encode(byte[] clearText) {
        if (clearText == null || clearText.length == 0) {
            return null;
        }
        try {
            byte[] type = new byte[2];
            String encAlgString = DEFAULT_ENCYPTION_ALG;
            EncryptionAlgorithm encAlg = JSSEncryption.getEncryptionAlg(encAlgString);
            int i = JSSEncryption.getEncryptionByte(encAlgString);
            type[1] = (byte)i;
            Cipher cipher = mToken.getCipherContext(encAlg);
            String keyA = DEFAULT_KEYGEN_ALG;
            i = JSSEncryption.getKeyGenByte(keyA);
            type[0] = (byte)i;
            SymmetricKey sk = this.getSymmetricKey(i);
            IVParameterSpec ivSpec = this.getIVParameterSpec(i);
            byte[] iv = ivSpec.getIV();
            cipher.initEncrypt(sk, (AlgorithmParameterSpec)ivSpec);
            byte[] enc = cipher.doFinal(clearText);
            enc = JSSEncryption.addPrefix(type, iv, enc);
            return enc;
        }
        catch (Throwable e) {
            if (debug != null) {
                debug.error("in encode string " + e);
            }
            return null;
        }
    }

    private byte[] decode(byte[] encoded) {
        if (encoded == null || encoded.length == 0) {
            return null;
        }
        try {
            byte[] share = encoded;
            if (share[0] != 1) {
                if (debug != null) {
                    debug.error("In decode string: unsupported version:" + share[0]);
                }
                return null;
            }
            byte[] type = JSSEncryption.getType(share);
            share = JSSEncryption.getRaw(share);
            if (type[1] < 0 && type[1] >= NUM_ENCRYPTION_ALG) {
                if (debug != null) {
                    debug.error("In decode string: unsupported encryption bit:" + type[1]);
                }
                return null;
            }
            EncryptionAlgorithm encAlg = JSSEncryption.getEncryptionAlg(ENCRYPTION_ALGS[type[1]]);
            Cipher cipher = mToken.getCipherContext(encAlg);
            if (type[0] < 0 && type[0] >= NUM_KEYGEN_ALG) {
                if (debug != null) {
                    debug.error("In decode string: unsupported keygen bit:" + type[0]);
                }
                return null;
            }
            SymmetricKey sk = this.getSymmetricKey(type[0]);
            IVParameterSpec ivSpec = this.getIVParameterSpec(type[0]);
            cipher.initDecrypt(sk, (AlgorithmParameterSpec)ivSpec);
            byte[] dec = cipher.doFinal(share);
            if (dec == null) {
                debug.error("Failed to decode " + encoded);
                return null;
            }
            return dec;
        }
        catch (Throwable e) {
            if (debug != null) {
                debug.error("in decoding string " + encoded, e);
            }
            return null;
        }
    }

    private static byte[] addPrefix(byte[] type, byte[] iv, byte[] share) {
        int i;
        byte[] data = new byte[share.length + 11];
        data[0] = 1;
        data[1] = type[0];
        data[2] = type[1];
        for (i = 0; i < 8; ++i) {
            data[3 + i] = iv[i];
        }
        for (i = 0; i < share.length; ++i) {
            data[11 + i] = share[i];
        }
        return data;
    }

    private static byte[] getType(byte[] share) {
        byte[] type = new byte[]{share[1], share[2]};
        return type;
    }

    private static byte[] getIV(byte[] share) {
        byte[] iv = new byte[8];
        for (int i = 0; i < 8; ++i) {
            iv[i] = share[i + 3];
        }
        return iv;
    }

    private static byte[] getRaw(byte[] share) {
        byte[] data = new byte[share.length - 11];
        for (int i = 11; i < share.length; ++i) {
            data[i - 11] = share[i];
        }
        return data;
    }

    private static int getKeyGenByte(String algName) {
        for (int i = 0; i < NUM_KEYGEN_ALG; ++i) {
            if (!algName.equals(KEYGEN_ALGS[i])) continue;
            return i;
        }
        if (debug != null) {
            debug.error("keyGen algorithm is not valid.");
        }
        return 0;
    }

    private static PBEAlgorithm getKeyGenAlg(String algName) {
        if (algName.equals("PBE_SHA1_DES3_CBC")) {
            return PBEAlgorithm.PBE_SHA1_DES3_CBC;
        }
        if (algName.equals("PBE_MD2_DES_CBC")) {
            return PBEAlgorithm.PBE_MD2_DES_CBC;
        }
        if (algName.equals(DEFAULT_KEYGEN_ALG)) {
            return PBEAlgorithm.PBE_MD5_DES_CBC;
        }
        if (algName.equals("PBE_SHA1_DES_CBC")) {
            return PBEAlgorithm.PBE_SHA1_DES_CBC;
        }
        if (algName.equals("PBE_SHA1_RC2_128_CBC")) {
            return PBEAlgorithm.PBE_SHA1_RC2_128_CBC;
        }
        if (algName.equals("PBE_SHA1_RC2_40_CBC")) {
            return PBEAlgorithm.PBE_SHA1_RC2_40_CBC;
        }
        if (algName.equals("PBE_SHA1_RC4_128")) {
            return PBEAlgorithm.PBE_SHA1_RC4_128;
        }
        if (algName.equals("PBE_SHA1_RC4_40")) {
            return PBEAlgorithm.PBE_SHA1_RC4_40;
        }
        if (debug != null) {
            debug.message("keyGen algorithm is not valid.");
        }
        return PBEAlgorithm.PBE_SHA1_DES3_CBC;
    }

    private static int getEncryptionByte(String algName) {
        for (int i = 0; i < NUM_ENCRYPTION_ALG; ++i) {
            if (!algName.equals(ENCRYPTION_ALGS[i])) continue;
            return i;
        }
        if (debug != null) {
            debug.error("Encryption algorithm is not valid.");
        }
        return 0;
    }

    private static EncryptionAlgorithm getEncryptionAlg(String algName) {
        if (algName.equals("DES3_CBC_PAD")) {
            return EncryptionAlgorithm.DES3_CBC_PAD;
        }
        if (algName.equals("DES3_CBC")) {
            return EncryptionAlgorithm.DES3_CBC;
        }
        if (algName.equals("DES3_ECB")) {
            return EncryptionAlgorithm.DES3_ECB;
        }
        if (algName.equals("DES_CBC")) {
            return EncryptionAlgorithm.DES_CBC;
        }
        if (algName.equals(DEFAULT_ENCYPTION_ALG)) {
            return EncryptionAlgorithm.DES_CBC_PAD;
        }
        if (algName.equals("DES_ECB")) {
            return EncryptionAlgorithm.DES_ECB;
        }
        if (algName.equals("RC2_CBC")) {
            return EncryptionAlgorithm.RC2_CBC;
        }
        if (algName.equals("RC4")) {
            return EncryptionAlgorithm.RC4;
        }
        if (debug != null) {
            debug.message("Encryption algorithm is not valid.");
        }
        return EncryptionAlgorithm.DES3_CBC_PAD;
    }

    static {
        block4: {
            KEYGEN_ALGS = new String[]{"PBE_SHA1_DES3_CBC", "PBE_MD2_DES_CBC", DEFAULT_KEYGEN_ALG, "PBE_SHA1_DES_CBC", "PBE_SHA1_RC2_128_CBC", "PBE_SHA1_RC2_40_CBC", "PBE_SHA1_RC4_128", "PBE_SHA1_RC4_40"};
            NUM_KEYGEN_ALG = KEYGEN_ALGS.length;
            ENCRYPTION_ALGS = new String[]{"DES3_CBC_PAD", "DES_CBC", DEFAULT_ENCYPTION_ALG, "DES_ECB", "DES3_CBC", "DES3_ECB", "RC2_CBC", "RC4"};
            NUM_ENCRYPTION_ALG = ENCRYPTION_ALGS.length;
            mToken = null;
            debug = Debug.getInstance("amJSS");
            method = "JSSEncryption.initialize";
            try {
                mToken = JSSEncryption.findToken();
            }
            catch (CryptoManager.NotInitializedException ex) {
                try {
                    JSSInit.initialize();
                    mToken = JSSEncryption.findToken();
                }
                catch (Exception e) {
                    if (debug == null) break block4;
                    debug.error("Crypt: Initialize JSS ", e);
                }
            }
        }
    }
}

