/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.message;

import com.sun.identity.common.SystemConfigurationUtil;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.message.common.FSMsgException;
import com.sun.identity.saml.assertion.NameIdentifier;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLResponderException;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml.protocol.AbstractRequest;
import com.sun.identity.saml.xmlsig.XMLSignatureManager;
import com.sun.identity.shared.DateUtils;
import com.sun.identity.shared.xml.XMLUtils;
import java.util.Date;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FSNameIdentifierMappingRequest
extends AbstractRequest {
    private String providerID;
    private NameIdentifier nameIdentifier;
    private String targetNamespace;
    private int minorVersion = 2;
    private String signatureString;

    public FSNameIdentifierMappingRequest(String providerID, NameIdentifier nameIdentifier, String targetNamespace) throws FSMsgException {
        this.providerID = providerID;
        this.nameIdentifier = nameIdentifier;
        this.targetNamespace = targetNamespace;
        this.requestID = SAMLUtils.generateID();
        this.setIssueInstant(new Date());
    }

    public FSNameIdentifierMappingRequest(Element root) throws FSMsgException {
        if (root == null) {
            FSUtils.debug.message("FSNameIdentifierMappingRequest: null element input.");
            throw new FSMsgException("nullInputParameter", null);
        }
        String tag = null;
        tag = root.getLocalName();
        if (tag == null || !tag.equals("NameIdentifierMappingRequest")) {
            FSUtils.debug.message("FSNameIdentifierMappingRequest: wrong input");
            throw new FSMsgException("wrongInput", null);
        }
        String instantString = root.getAttribute("IssueInstant");
        if (instantString == null || instantString.length() == 0) {
            FSUtils.debug.error("FSNameIdentifierMappingRequest: missing IssueInstant");
            Object[] args = new String[]{"IssueInstant"};
            throw new FSMsgException("missingAttribute", args);
        }
        try {
            this.issueInstant = DateUtils.stringToDate(instantString);
        }
        catch (Exception e) {
            FSUtils.debug.error("FSNameIdentifierMappingRequest: could not parse IssueInstant.", e);
            throw new FSMsgException("wrongInput", null);
        }
        this.requestID = root.getAttribute("RequestID");
        this.parseMajorVersion(root.getAttribute("MajorVersion"));
        this.parseMinorVersion(root.getAttribute("MinorVersion"));
        NodeList contentnl = root.getChildNodes();
        int length = contentnl.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = contentnl.item(i);
            String nodeName = child.getLocalName();
            if (nodeName == null) continue;
            if (nodeName.equals("ProviderID")) {
                this.providerID = XMLUtils.getElementValue((Element)child);
                continue;
            }
            if (nodeName.equals("NameIdentifier")) {
                try {
                    this.nameIdentifier = new NameIdentifier((Element)child);
                    continue;
                }
                catch (SAMLException samle) {
                    FSUtils.debug.error("FSNameIdentifierMappingRequest: unable to initialize NameIdentifier", samle);
                    throw new FSMsgException("nameIdentifierCreateError", null, samle);
                }
            }
            if (!nodeName.equals("TargetNamespace")) continue;
            this.targetNamespace = XMLUtils.getElementValue((Element)child);
        }
        List signs = XMLUtils.getElementsByTagNameNS1(root, "http://www.w3.org/2000/09/xmldsig#", "Signature");
        int signsSize = signs.size();
        if (signsSize == 1) {
            Element elem = (Element)signs.get(0);
            this.setSignature(elem);
            this.signed = true;
        } else if (signsSize != 0) {
            FSUtils.debug.error("FSNameIdentifierMappingRequest: included more than one Signature element.");
            throw new FSMsgException("moreElement", null);
        }
    }

    public static FSNameIdentifierMappingRequest parseXML(String xml) throws FSMsgException {
        Document doc = XMLUtils.toDOMDocument(xml, FSUtils.debug);
        if (doc == null) {
            FSUtils.debug.error("FSNameIdentifierMappingRequest.parseXML: error while parsing input xml string");
            throw new FSMsgException("parseError", null);
        }
        Element root = doc.getDocumentElement();
        return new FSNameIdentifierMappingRequest(root);
    }

    public String getProviderID() {
        return this.providerID;
    }

    public NameIdentifier getNameIdentifier() {
        return this.nameIdentifier;
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    private void parseMajorVersion(String version) throws FSMsgException {
        try {
            this.majorVersion = Integer.parseInt(version);
        }
        catch (NumberFormatException e) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSNameIdentifierMappingRequest.parseMajorVersion: invalid MajorVersion: " + version, e);
            }
            throw new FSMsgException("wrongInput", null);
        }
        if (this.majorVersion != 1) {
            if (this.majorVersion > 1) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSNameIdentifierMappingRequest.parseMajorVersion: MajorVersion is too high");
                }
                throw new FSMsgException("requestVersionTooHigh", null);
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSNameIdentifierMappingRequest.parseMajorVersion: MajorVersion is too low");
            }
            throw new FSMsgException("requestVersionTooLow", null);
        }
    }

    private void parseMinorVersion(String version) throws FSMsgException {
        try {
            this.minorVersion = Integer.parseInt(version);
        }
        catch (NumberFormatException e) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSNameIdentifierMappingRequest.parseMinorVersion: invalid MinorVersion: " + version, e);
            }
            throw new FSMsgException("wrongInput", null);
        }
        if (this.minorVersion > 2) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSNameIdentifierMappingRequest.parseMinorVersion: MinorVersion is too high");
            }
            throw new FSMsgException("requestVersionTooHigh", null);
        }
        if (this.minorVersion < 0) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSNameIdentifierMappingRequest.parseMinorVersion: MinorVersion is too low");
            }
            throw new FSMsgException("requestVersionTooLow", null);
        }
    }

    public void signXML() throws SAMLException {
        String certAlias = SystemConfigurationUtil.getProperty("com.sun.identity.saml.xmlsig.certalias");
        this.signXML(certAlias);
    }

    public void signXML(String certAlias) throws SAMLException {
        FSUtils.debug.message("FSNameIdentifierMappingRequest.signXML");
        if (this.signed) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSNameIdentifierMappingRequest.signXML: the request is already signed.");
            }
            throw new SAMLResponderException("libIDFF", "alreadySigned", null);
        }
        if (certAlias == null || certAlias.length() == 0) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSNameIdentifierMappingRequest.signXML: null certAlias");
            }
            throw new SAMLResponderException("libIDFF", "cannotFindCertAlias", null);
        }
        try {
            XMLSignatureManager manager = XMLSignatureManager.getInstance();
            this.signatureString = manager.signXML(this.toXMLString(true, true), certAlias, (String)null, "RequestID", this.getRequestID(), false);
            this.signature = XMLUtils.toDOMDocument(this.signatureString, FSUtils.debug).getDocumentElement();
            this.signed = true;
        }
        catch (Exception e) {
            FSUtils.debug.error("FSNameIdentifierMappingRequest.signXML: unable to sign", e);
            throw new SAMLResponderException("libIDFF", "signFailed", null);
        }
    }

    public String toXMLString() throws FSMsgException {
        return this.toXMLString(true, true);
    }

    public String toXMLString(boolean includeNS, boolean declareNS) throws FSMsgException {
        return this.toXMLString(includeNS, declareNS, false);
    }

    public String toXMLString(boolean includeNS, boolean declareNS, boolean includeHeader) throws FSMsgException {
        String prefix = "";
        String uriLIB = "";
        String uriSAML = "";
        if (includeNS) {
            prefix = "lib:";
        }
        if (declareNS) {
            uriLIB = " xmlns:lib=\"urn:liberty:iff:2003-08\"";
            uriSAML = " xmlns:saml=\"urn:oasis:names:tc:SAML:1.0:assertion\"";
        }
        String instantString = null;
        try {
            instantString = DateUtils.toUTCDateFormat(this.issueInstant);
        }
        catch (Exception e) {
            FSUtils.debug.error("FSNameIdentifierMappingRequest.toXMLString: could not convert issueInstant to String.", e);
        }
        StringBuffer xml = new StringBuffer(1000);
        if (includeHeader) {
            xml.append("<?xml version=\"1.0\" encoding=\"").append("UTF-8").append("\"").append(" ").append('?').append(">").append("\n");
        }
        xml.append("<").append(prefix).append("NameIdentifierMappingRequest").append(uriLIB).append(uriSAML).append(" ").append("RequestID").append('=').append("\"").append(this.requestID).append("\"").append(" ").append(" ").append("MajorVersion").append('=').append("\"").append(this.majorVersion).append("\"").append(" ").append(" ").append("MinorVersion").append('=').append("\"").append(this.minorVersion).append("\"").append(" ").append(" ").append("IssueInstant").append('=').append("\"").append(instantString).append("\"").append(" ").append(">");
        if (this.signed) {
            if (this.signatureString != null) {
                xml.append(this.signatureString);
            } else if (this.signature != null) {
                this.signatureString = XMLUtils.print(this.signature);
                xml.append(this.signatureString);
            }
        }
        xml.append("<").append(prefix).append("ProviderID").append(">").append(this.providerID).append("</").append(prefix).append("ProviderID").append(">");
        if (this.nameIdentifier != null) {
            xml.append(this.nameIdentifier.toString());
        }
        xml.append("<").append(prefix).append("TargetNamespace").append(">").append(this.targetNamespace).append("</").append(prefix).append("TargetNamespace").append(">").append("</").append(prefix).append("NameIdentifierMappingRequest").append(">");
        return xml.toString();
    }
}

