/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.idm;

import com.iplanet.am.sdk.AMObjectListener;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdCachedServices;
import com.sun.identity.idm.IdEventListener;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdServices;
import com.sun.identity.idm.IdServicesFactory;
import com.sun.identity.idm.IdType;
import com.sun.identity.idm.IdUtils;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.jaxrpc.SOAPClient;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigManager;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import netscape.ldap.LDAPDN;
import netscape.ldap.util.DN;

public final class IdRepoListener {
    private Map configMap = null;
    private static AMObjectListener remoteListener = null;
    private static Debug debug = Debug.getInstance("idrepoListener");
    protected static SOAPClient sclient = new SOAPClient("dummy");

    public void allObjectsChanged() {
        String org;
        ArrayList list;
        IdServices idServices;
        if (debug.messageEnabled()) {
            debug.message("IdRepoListener: allObjectsChanged Called!");
        }
        if ((idServices = IdServicesFactory.getDataStoreServices()) instanceof IdCachedServices) {
            ((IdCachedServices)idServices).clearCache();
        }
        if ((list = (ArrayList)AMIdentityRepository.listeners.get(org = (String)this.configMap.get("realm"))) != null) {
            int size = list.size();
            for (int j = 0; j < size; ++j) {
                IdEventListener l = (IdEventListener)list.get(j);
                l.allIdentitiesChanged();
            }
        }
        if (remoteListener != null) {
            remoteListener.allObjectsChanged();
        }
    }

    public void objectChanged(String name, int type, Map cMap) {
        if (debug.messageEnabled()) {
            debug.message("objectChanged called = name:: " + name + "  type:: " + type + "\n  configmap = " + this.configMap);
        }
        String org = (String)this.configMap.get("realm");
        ArrayList list = (ArrayList)AMIdentityRepository.listeners.get(org);
        IdServices idServices = IdServicesFactory.getDataStoreServices();
        boolean dirtyCache = false;
        if (idServices instanceof IdCachedServices) {
            dirtyCache = true;
        }
        if (name.length() > 0) {
            String[] changed = this.getChangedIds(name, cMap);
            for (int i = 0; i < changed.length; ++i) {
                if (dirtyCache) {
                    ((IdCachedServices)idServices).dirtyCache(changed[i], type, false, false, Collections.EMPTY_SET);
                }
                if (list != null) {
                    int size = list.size();
                    block6: for (int j = 0; j < size; ++j) {
                        IdEventListener l = (IdEventListener)list.get(j);
                        switch (type) {
                            case 1: 
                            case 4: {
                                l.identityChanged(changed[i]);
                                continue block6;
                            }
                            case 2: {
                                l.identityDeleted(changed[i]);
                                continue block6;
                            }
                            case 8: {
                                l.identityRenamed(changed[i]);
                            }
                        }
                    }
                }
                if (remoteListener == null) continue;
                remoteListener.objectChanged(changed[i], type, this.configMap);
            }
        }
    }

    public Map getConfigMap() {
        return this.configMap;
    }

    public static void addRemoteListener(AMObjectListener l) {
        remoteListener = l;
    }

    public void setConfigMap(Map cMap) {
        this.configMap = cMap;
    }

    public void setServiceAttributes(String sName, Map attrs) throws IdRepoException {
        String realm = (String)this.configMap.get("realm");
        String pluginName = (String)this.configMap.get("plugin-name");
        if (realm == null || pluginName == null) {
            AMIdentityRepository.debug.error("IdRepoListener.setServiveAttribute: realm or plugin name is null");
            Object[] args = new Object[]{sName, IdType.ROLE.getName()};
            throw new IdRepoException("amIdRepo", "105", args);
        }
        try {
            SSOToken token = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
            ServiceConfigManager scm = new ServiceConfigManager(token, "sunIdentityRepositoryService", "1.0");
            ServiceConfig sc = scm.getOrganizationConfig(realm, null);
            if (sc == null) {
                return;
            }
            ServiceConfig subConfig = sc.getSubConfig(pluginName);
            if (subConfig == null) {
                return;
            }
            Map attributes = subConfig.getAttributes();
            HashSet<String> vals = (HashSet<String>)attributes.get("sun-idrepo-ldapv3-config-service-attributes");
            if (vals == null || vals == Collections.EMPTY_SET) {
                vals = new HashSet<String>();
            }
            String mapStr = sclient.encodeMap("result", attrs);
            vals = new HashSet();
            vals.add(mapStr);
            attributes.put("sun-idrepo-ldapv3-config-service-attributes", vals);
            subConfig.setAttributes(attributes);
        }
        catch (SMSException smse) {
            AMIdentityRepository.debug.error("IdRepoListener: Unable to set service attributes", smse);
            Object[] args = new Object[]{sName, IdType.ROLE.getName()};
            throw new IdRepoException("amIdRepo", "105", args);
        }
        catch (SSOException ssoe) {
            AMIdentityRepository.debug.error("IdRepoListener: Unable to set service attributes", ssoe);
            Object[] args = new Object[]{sName, IdType.ROLE.getName()};
            throw new IdRepoException("amIdRepo", "105", args);
        }
    }

    private String[] getChangedIds(String name, Map configMap) {
        int size = IdUtils.supportedTypes.size();
        if (configMap == null) {
            String[] ct = new String[]{name};
            return ct;
        }
        String[] changedTypes = new String[size];
        int i = 0;
        if (configMap == null || configMap.isEmpty()) {
            changedTypes[i] = name;
            return changedTypes;
        }
        String realm = (String)configMap.get("realm");
        String Amsdk = (String)configMap.get("amsdk");
        boolean isAmsdk = Amsdk != null;
        Iterator it = IdUtils.supportedTypes.iterator();
        while (it.hasNext()) {
            IdType itype = (IdType)it.next();
            String n = DN.isDN(name) ? LDAPDN.explodeDN(name, true)[0] : name;
            String id = "id=" + n + ",ou=" + itype.getName() + "," + realm;
            if (isAmsdk) {
                id = id + ",amsdkdn=" + name;
            }
            changedTypes[i] = id;
            ++i;
        }
        return changedTypes;
    }
}

