/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.jaxrpc;

import com.iplanet.am.sdk.remote.AMRemoteException;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.sso.SSOException;
import com.sun.identity.common.HttpURLConnectionManager;
import com.sun.identity.entity.EntityException;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.jaxrpc.JAXRPCUtil;
import com.sun.identity.jaxrpc.SOAPClientException;
import com.sun.identity.shared.datastruct.OrderedSet;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.encode.Base64;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SMSSchema;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class SOAPClient {
    static final Debug debug = Debug.getInstance("amJAXRPC");
    String serviceName;
    String url;
    String[] urls;
    String exceptionClassName;
    String exceptionMessage;
    String exceptionCode;
    String smsExceptionCode;
    int ldapErrorCode;
    String resourceBundleName;
    String errorString;
    Set messageArgs;
    Exception exception;
    boolean isException;
    private static boolean useCache = Boolean.getBoolean(SystemProperties.get("com.sun.identity.urlconnection.useCache", "false"));
    static final String ENVELOPE = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<env:Envelope xmlns:env=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:enc=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:ns0=\"http://isp.com/types\" xmlns:ns1=\"http://java.sun.com/jax-rpc-ri/internal\" env:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">";
    static final String HEADSTART = "<env:Header>";
    static final String HEADEND = "</env:Header>";
    static final String ENV_BODY = "<env:Body>";
    static final String SUFFIX = "</env:Body></env:Envelope>\n";
    static final String BODY = "body";
    static final String RESULT = "result";
    static final String TYPE = "xsi:type";
    static final String STRING = "xsd:string";
    static final String INTEGER = "xsd:int";
    static final String BOOLEAN = "xsd:boolean";
    static final String SET = "ns1:hashSet";
    static final String TREESET = "ns1:treeSet";
    static final String MAP = "ns1:hashMap";
    static final String LIST = "ns1:linkedList";
    static final String MAPENTRY = "ns1:mapEntry";
    static final String ITEM = "item";
    static final String KEY = "key";
    static final String VALUE = "value";
    static final String FAULT_STRING = "faultstring";
    static final String MESSAGE = "message";
    static final String ERROR_CODE = "errorCode";
    static final String EXCEPTION_CODE = "exceptionCode";
    static final String LDAP_ERROR_CODE = "LDAPErrorCode";
    static final String ERROR_STRING = "errorString";
    static final String RMIREMOTEEXCEPTION = "java.rmi.RemoteException";
    static final String SSOEXCEPTION = "com.iplanet.sso.SSOException";
    static final String AMREMOTEEXCEPTION = "com.iplanet.am.sdk.remote.AMRemoteException";
    static final String SMSEXCEPTION = "com.sun.identity.sm.SMSException";
    static final String IDREPOEXCEPTION = "com.sun.identity.sm.IdRepoException";
    static final String ENTITYEXCEPTION = "com.sun.identity.entity.EntityException";
    static final String SAMLEXCEPTION = "com.sun.identity.common.SAMLException";
    static final String RESOURCE_BUNDLE_NAME = "resourceBundleName";
    static final String MESSAGE_ARGS = "messageArgs";
    static final String HREF = "href";
    static final String ARRAY_OF_ANY_TYPE = "ArrayOfanyType";
    static final String ID = "id";
    static final String DECODE_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><env:Envelope xmlns:env=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:enc=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:ns0=\"http://isp.com/types\" xmlns:ns1=\"http://java.sun.com/jax-rpc-ri/internal\" env:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\"><env:Body><ans1:readResponse xmlns:ans1=\"http://isp.com/wsdl\">";
    static final String DECODE_FOOTER = "</ans1:readResponse></env:Body></env:Envelope>";

    public SOAPClient() throws IOException {
    }

    public SOAPClient(String serviceName) {
        this.serviceName = serviceName;
    }

    public SOAPClient(String[] urls) {
        this.urls = urls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream call(String message, String cookies) throws Exception {
        Object data;
        if (debug.messageEnabled()) {
            debug.message("SOAP Client: Message being sent:" + message);
        }
        InputStream in_buf = null;
        boolean done = false;
        int urlIndex = 0;
        while (!done) {
            String userInfo;
            if (this.url == null) {
                if (this.urls != null) {
                    if (urlIndex >= this.urls.length) {
                        if (debug.warningEnabled()) {
                            debug.warning("SOAPClient: No vaild server found");
                        }
                        throw new RemoteException("no-server-found");
                    }
                    this.url = this.urls[urlIndex++];
                } else {
                    this.url = JAXRPCUtil.getValidURL(this.serviceName);
                }
            }
            URL endpoint = new URL(this.url);
            HttpURLConnection connection = HttpURLConnectionManager.getConnection(endpoint);
            connection.setDoOutput(true);
            connection.setUseCaches(useCache);
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "text/xml; charset=\"utf-8\"");
            if (cookies == null) {
                if (SystemProperties.iasGXId != null) {
                    connection.setRequestProperty("Cookie", "GX_jst=" + SystemProperties.iasGXId);
                }
            } else {
                if (SystemProperties.iasGXId != null) {
                    cookies = cookies + "; GX_jst=" + SystemProperties.iasGXId;
                }
                connection.setRequestProperty("Cookie", cookies);
            }
            if ((userInfo = endpoint.getUserInfo()) != null) {
                connection.setRequestProperty("Authorization", "Basic " + Base64.encode(userInfo.getBytes("UTF-8")));
            }
            data = message.getBytes("UTF-8");
            int requestLength = ((Object)data).length;
            connection.setRequestProperty("Content-Length", Integer.toString(requestLength));
            OutputStream out = null;
            try {
                out = connection.getOutputStream();
            }
            catch (ConnectException ce) {
                if (debug.warningEnabled()) {
                    debug.warning("SOAP Client: Connection Exception: " + this.url, ce);
                }
                JAXRPCUtil.serverFailed(this.url);
                this.url = null;
                continue;
            }
            out.write((byte[])data);
            out.flush();
            try {
                in_buf = connection.getInputStream();
            }
            catch (IOException ioe) {
                if (debug.messageEnabled()) {
                    debug.message("SOAP Client: READ Exception", ioe);
                }
                in_buf = connection.getErrorStream();
                this.isException = true;
            }
            finally {
                done = true;
            }
        }
        if (debug.messageEnabled()) {
            String line;
            StringBuffer inbuf = new StringBuffer();
            BufferedReader reader = new BufferedReader(new InputStreamReader(in_buf, "UTF-8"));
            while ((line = reader.readLine()) != null) {
                inbuf.append(line).append("\n");
            }
            data = new String(inbuf);
            debug.message("SOAP Client: Input: " + message + "\nOutput: " + (String)data);
            in_buf = new ByteArrayInputStream(((String)data).getBytes("UTF-8"));
        }
        return in_buf;
    }

    public synchronized Object send(String functionName, Object[] params, String cookies) throws Exception {
        return this.send(this.encodeMessage(functionName, params), cookies);
    }

    public synchronized Object send(String functionName, Object param, String cookies) throws Exception {
        return this.send(this.encodeMessage(functionName, param), cookies);
    }

    public synchronized Object send(String message, String cookies) throws Exception {
        SOAPContentHandler handler;
        block7: {
            this.exceptionMessage = null;
            this.exceptionClassName = null;
            this.exceptionCode = null;
            this.resourceBundleName = null;
            this.smsExceptionCode = null;
            this.messageArgs = null;
            this.errorString = null;
            this.ldapErrorCode = 0;
            this.isException = false;
            InputStream in_buf = this.call(message, cookies);
            handler = new SOAPContentHandler();
            try {
                SAXParserFactory saxFactory = SAXParserFactory.newInstance();
                saxFactory.setNamespaceAware(true);
                if (debug.warningEnabled()) {
                    saxFactory.setValidating(true);
                } else {
                    saxFactory.setValidating(false);
                }
                XMLReader parser = saxFactory.newSAXParser().getXMLReader();
                parser.setContentHandler(handler);
                parser.setErrorHandler(new SOAPErrorHandler());
                parser.parse(new InputSource(in_buf));
            }
            catch (ParserConfigurationException pce) {
                if (debug.warningEnabled()) {
                    debug.warning("SOAPClient:send parser config exception", pce);
                }
            }
            catch (SAXException saxe) {
                if (!debug.warningEnabled()) break block7;
                debug.warning("SOAPClient:send SAX exception", saxe);
            }
        }
        if (this.isException) {
            throw this.exception;
        }
        return handler.getObject();
    }

    public void setURL(String url) {
        this.url = url;
    }

    void setURLs(String[] urls) {
        this.urls = urls;
    }

    String encodeString(String str) {
        return this.encodeString("String_1", str);
    }

    String encodeInt(String name, Integer i) {
        StringBuffer sb = new StringBuffer(100);
        sb.append("<").append(name);
        sb.append(" xsi:type=\"xsd:int\">");
        sb.append(i).append("</").append(name).append(">");
        return sb.toString();
    }

    String encodeInt(Integer i) {
        return this.encodeInt("int_1", i);
    }

    String encodeBoolean(String name, Boolean b) {
        StringBuffer sb = new StringBuffer(100);
        sb.append("<").append(name);
        sb.append(" xsi:type=\"xsd:boolean\">");
        sb.append(b).append("</").append(name).append(">");
        return sb.toString();
    }

    String encodeBoolean(Boolean b) {
        return this.encodeBoolean("boolean_1", b);
    }

    String encodeString(String name, String str) {
        StringBuffer sb = new StringBuffer(100);
        sb.append("<").append(name);
        sb.append(" xsi:type=\"xsd:string\">");
        String data = SMSSchema.escapeSpecialCharacters(str);
        sb.append(data).append("</").append(name).append(">");
        return sb.toString();
    }

    String encodeSet(Set set) {
        return this.encodeSet("Set_1", set);
    }

    String encodeSet(String name, Set set) {
        StringBuffer sb = new StringBuffer(200);
        sb.append("<").append(name);
        sb.append(" xsi:type=\"ns1:hashSet\" enc:arrayType=\"xsd:anyType[");
        sb.append(set.size());
        sb.append("]\">");
        Iterator items = set.iterator();
        while (items.hasNext()) {
            sb.append(this.encodeString(ITEM, items.next().toString()));
        }
        sb.append("</").append(name).append(">");
        return sb.toString();
    }

    String encodeList(List list) {
        return this.encodeList("List_1", list);
    }

    String encodeList(String name, List list) {
        StringBuffer sb = new StringBuffer(200);
        sb.append("<").append(name);
        sb.append(" xsi:type=\"ns1:linkedList\" enc:arrayType=\"xsd:anyType[");
        sb.append(list.size());
        sb.append("]\">");
        Iterator items = list.iterator();
        while (items.hasNext()) {
            sb.append(this.encodeString(ITEM, items.next().toString()));
        }
        sb.append("</").append(name).append(">");
        return sb.toString();
    }

    public String encodeMap(Map map) {
        return this.encodeMap("Map_1", map);
    }

    String encodeByteArrayArray(String name, byte[][] data) {
        return null;
    }

    public String encodeMap(String name, Map map) {
        StringBuffer sb = new StringBuffer(200);
        sb.append("<").append(name);
        sb.append(" xsi:type=\"ns1:hashMap\" enc:arrayType=\"ns1:mapEntry[");
        sb.append(map.size()).append("]\">");
        Iterator items = map.entrySet().iterator();
        while (items.hasNext()) {
            Map.Entry entry = items.next();
            sb.append("<item xsi:type=\"ns1:mapEntry\">");
            sb.append(this.encodeString(KEY, entry.getKey().toString()));
            Object value = entry.getValue();
            if (value instanceof Set) {
                sb.append(this.encodeSet(VALUE, (Set)value));
            } else if (value instanceof Map) {
                sb.append(this.encodeMap(VALUE, (Map)value));
            } else if (value instanceof List) {
                sb.append(this.encodeList(VALUE, (List)value));
            } else if (value instanceof String) {
                sb.append(this.encodeString(VALUE, (String)value));
            } else if (value instanceof byte[][]) {
                sb.append(this.encodeByteArrayArray(VALUE, (byte[][])value));
            }
            sb.append("</item>");
        }
        sb.append("</").append(name).append(">");
        return sb.toString();
    }

    public Map decodeMap(String xmlMap) {
        if (xmlMap == null || xmlMap.length() == 0) {
            return Collections.EMPTY_MAP;
        }
        StringBuffer sb = new StringBuffer(200);
        sb.append(DECODE_HEADER);
        sb.append(xmlMap);
        sb.append(DECODE_FOOTER);
        SOAPContentHandler handler = new SOAPContentHandler();
        try {
            SAXParserFactory saxFactory = SAXParserFactory.newInstance();
            saxFactory.setNamespaceAware(true);
            saxFactory.setValidating(false);
            XMLReader parser = saxFactory.newSAXParser().getXMLReader();
            parser.setContentHandler(handler);
            parser.setErrorHandler(new SOAPErrorHandler());
            parser.parse(new InputSource(new ByteArrayInputStream(sb.toString().getBytes("UTF-8"))));
        }
        catch (Exception e) {
            if (debug.warningEnabled()) {
                debug.warning("SOAPClient::decodeMap Exception", e);
            }
            return Collections.EMPTY_MAP;
        }
        return (Map)handler.getObject();
    }

    public String encodeMessage(String function, Object param) {
        Object[] params = null;
        if (param != null) {
            params = new Object[]{param};
        }
        return this.encodeMessage(function, params);
    }

    public synchronized String encodeMessage(String function, Object[] params) {
        int index = 1;
        StringBuffer sb = new StringBuffer(1000);
        sb.append(ENVELOPE).append(HEADSTART).append(HEADEND).append(ENV_BODY);
        sb.append("<ans1:").append(function).append(" xmlns:ans1=\"http://isp.com/wsdl\">");
        for (int i = 0; params != null && i < params.length; ++i) {
            if (params[i] instanceof String) {
                sb.append(this.encodeString("String_" + index++, (String)params[i]));
                continue;
            }
            if (params[i] instanceof Set) {
                sb.append(this.encodeSet("Set_" + index++, (Set)params[i]));
                continue;
            }
            if (params[i] instanceof Map) {
                sb.append(this.encodeMap("Map_" + index++, (Map)params[i]));
                continue;
            }
            if (params[i] instanceof List) {
                sb.append(this.encodeList("List_" + index++, (List)params[i]));
                continue;
            }
            if (params[i] instanceof Integer) {
                sb.append(this.encodeInt("int_" + index++, (Integer)params[i]));
                continue;
            }
            if (params[i] instanceof Boolean) {
                sb.append(this.encodeBoolean("boolean_" + index++, (Boolean)params[i]));
                continue;
            }
            if (params[i] == null) {
                ++index;
                continue;
            }
            debug.error("SOAPClient: Unknown class: " + params.getClass().getName());
        }
        sb.append("</ans1:").append(function).append(">").append(SUFFIX);
        return sb.toString();
    }

    class SOAPErrorHandler
    implements ErrorHandler {
        SOAPErrorHandler() {
        }

        public void fatalError(SAXParseException spe) throws SAXParseException {
            debug.error("SOAPClient:PARSER.fatalError", spe);
        }

        public void error(SAXParseException spe) throws SAXParseException {
        }

        public void warning(SAXParseException spe) throws SAXParseException {
        }
    }

    class SOAPContentHandler
    implements ContentHandler {
        Locator locator;
        boolean started;
        List types = new LinkedList();
        List maps = new LinkedList();
        List keys = new LinkedList();
        Object answer;
        String currentType;
        String type;
        StringBuffer currentString;
        Set set;
        Set currentSet;
        Map map;
        List list;
        List currentList;

        protected SOAPContentHandler() {
        }

        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        public void startElement(String namespaceURI, String localName, String rawName, Attributes attrs) throws SAXException {
            if (!this.started && localName.equalsIgnoreCase(SOAPClient.BODY)) {
                this.started = true;
                return;
            }
            if (!SOAPClient.this.isException) {
                if (localName.equalsIgnoreCase(SOAPClient.RESULT)) {
                    this.type = this.currentType = attrs.getValue(attrs.getIndex(SOAPClient.TYPE));
                    if (this.type.equalsIgnoreCase(SOAPClient.SET)) {
                        this.set = this.currentSet = new OrderedSet();
                    } else if (this.type.equalsIgnoreCase(SOAPClient.TREESET)) {
                        this.set = this.currentSet = new TreeSet();
                    } else if (this.type.equalsIgnoreCase(SOAPClient.MAP)) {
                        this.map = new HashMap();
                        this.maps.add(0, this.map);
                    } else if (this.type.equalsIgnoreCase(SOAPClient.LIST)) {
                        this.list = this.currentList = new LinkedList();
                    }
                } else if (localName.equalsIgnoreCase(SOAPClient.ITEM)) {
                    this.types.add(0, this.currentType);
                    this.currentType = attrs.getValue(attrs.getIndex(SOAPClient.TYPE));
                } else if (localName.equalsIgnoreCase(SOAPClient.VALUE)) {
                    this.types.add(0, this.currentType);
                    this.currentType = attrs.getValue(attrs.getIndex(SOAPClient.TYPE));
                    if (this.currentType.equalsIgnoreCase(SOAPClient.SET)) {
                        this.currentSet = new OrderedSet();
                    } else if (this.currentType.equalsIgnoreCase(SOAPClient.MAP)) {
                        this.maps.add(0, new HashMap());
                    } else if (this.currentType.equalsIgnoreCase(SOAPClient.LIST)) {
                        this.currentList = new LinkedList();
                    }
                }
            } else if (localName.equals(SOAPClient.ARRAY_OF_ANY_TYPE)) {
                SOAPClient.this.messageArgs = new HashSet();
            }
            if (this.currentString == null) {
                this.currentString = new StringBuffer();
            }
        }

        public void endElement(String namespaceURI, String localName, String rawName) throws SAXException {
            if (!this.started) {
                return;
            }
            if (!SOAPClient.this.isException) {
                if (localName.equalsIgnoreCase(SOAPClient.ITEM)) {
                    if (this.currentType.equalsIgnoreCase(SOAPClient.STRING)) {
                        if (this.currentSet != null) {
                            this.currentSet.add(this.currentString.toString());
                        } else {
                            this.currentList.add(this.currentString.toString());
                        }
                    }
                    this.currentType = (String)this.types.remove(0);
                } else if (localName.equalsIgnoreCase(SOAPClient.VALUE)) {
                    if (this.currentType.equalsIgnoreCase(SOAPClient.SET) || this.currentType.equalsIgnoreCase(SOAPClient.TREESET)) {
                        Map map1 = (Map)this.maps.get(0);
                        map1.put(this.keys.remove(0), this.currentSet);
                    } else if (this.currentType.equalsIgnoreCase(SOAPClient.MAP)) {
                        Map map1 = (Map)this.maps.remove(0);
                        Map map2 = (Map)this.maps.get(0);
                        map2.put(this.keys.remove(0), map1);
                    } else if (this.currentType.equalsIgnoreCase(SOAPClient.LIST)) {
                        Map map1 = (Map)this.maps.get(0);
                        map1.put(this.keys.remove(0), this.currentList);
                    } else if (this.currentType.equalsIgnoreCase(SOAPClient.STRING) && ((String)this.types.get(0)).equalsIgnoreCase(SOAPClient.MAPENTRY)) {
                        this.map.put(this.keys.remove(0), this.currentString.toString());
                    }
                    this.currentType = (String)this.types.remove(0);
                } else if (localName.equals(SOAPClient.KEY)) {
                    this.keys.add(0, this.currentString.toString());
                } else if (localName.equalsIgnoreCase(SOAPClient.RESULT)) {
                    if (this.type.equalsIgnoreCase(SOAPClient.SET) || this.type.equalsIgnoreCase(SOAPClient.TREESET)) {
                        this.answer = this.set;
                    } else if (this.type.equalsIgnoreCase(SOAPClient.MAP)) {
                        this.answer = this.map;
                    } else if (this.type.equalsIgnoreCase(SOAPClient.STRING)) {
                        this.answer = this.currentString.toString();
                    } else if (this.type.equalsIgnoreCase(SOAPClient.INTEGER)) {
                        try {
                            this.answer = new Integer(this.currentString.toString());
                        }
                        catch (NumberFormatException nfe) {
                            this.answer = new Integer(0);
                        }
                    } else if (this.type.equalsIgnoreCase(SOAPClient.BOOLEAN)) {
                        this.answer = Boolean.valueOf(this.currentString.toString());
                    } else if (this.type.equalsIgnoreCase(SOAPClient.LIST)) {
                        this.answer = this.list;
                    }
                }
            } else {
                if (localName.equals(SOAPClient.FAULT_STRING)) {
                    SOAPClient.this.exceptionClassName = this.currentString.toString();
                } else if (localName.equals(SOAPClient.MESSAGE)) {
                    SOAPClient.this.exceptionMessage = this.currentString.toString();
                } else if (localName.equals(SOAPClient.ERROR_CODE)) {
                    SOAPClient.this.exceptionCode = this.currentString.toString();
                } else if (localName.equals(SOAPClient.EXCEPTION_CODE)) {
                    SOAPClient.this.smsExceptionCode = this.currentString.toString();
                } else if (localName.equals(SOAPClient.RESOURCE_BUNDLE_NAME)) {
                    SOAPClient.this.resourceBundleName = this.currentString.toString();
                } else if (localName.equals(SOAPClient.ITEM)) {
                    SOAPClient.this.messageArgs.add(this.currentString.toString());
                }
                if (localName.equals(SOAPClient.LDAP_ERROR_CODE)) {
                    SOAPClient.this.ldapErrorCode = Integer.parseInt(this.currentString.toString());
                }
                if (localName.equals(SOAPClient.ERROR_STRING)) {
                    SOAPClient.this.errorString = this.currentString.toString();
                }
            }
            this.currentString = null;
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            this.currentString.append(ch, start, length);
        }

        Object getObject() {
            return this.answer;
        }

        public void startDocument() throws SAXException {
        }

        public void endDocument() throws SAXException {
            if (SOAPClient.this.isException) {
                if (SOAPClient.this.exceptionClassName.equals(SOAPClient.SSOEXCEPTION)) {
                    SOAPClient.this.exception = SOAPClient.this.resourceBundleName != null ? new SSOException(SOAPClient.this.resourceBundleName, SOAPClient.this.exceptionCode, SOAPClient.this.messageArgs.toArray()) : (SOAPClient.this.exceptionMessage != null ? new SSOException(SOAPClient.this.exceptionMessage) : new SSOException("no message"));
                } else if (SOAPClient.this.exceptionClassName.equals(SOAPClient.SMSEXCEPTION)) {
                    if (SOAPClient.this.resourceBundleName != null) {
                        SOAPClient.this.exception = new SMSException(SOAPClient.this.resourceBundleName, SOAPClient.this.exceptionCode, SOAPClient.this.messageArgs == null ? null : SOAPClient.this.messageArgs.toArray());
                    } else if (SOAPClient.this.exceptionMessage != null && SOAPClient.this.exceptionCode != null) {
                        try {
                            SOAPClient.this.exception = new SMSException(Integer.parseInt(SOAPClient.this.exceptionCode), SOAPClient.this.exceptionMessage);
                        }
                        catch (NumberFormatException nfe) {
                            SOAPClient.this.exception = new SMSException(SOAPClient.this.exceptionMessage);
                        }
                    } else if (SOAPClient.this.smsExceptionCode != null) {
                        try {
                            SOAPClient.this.exception = new SMSException(Integer.parseInt(SOAPClient.this.smsExceptionCode), null);
                        }
                        catch (NumberFormatException nfe) {
                            SOAPClient.this.exception = new SMSException(SOAPClient.this.exceptionCode);
                        }
                    } else {
                        SOAPClient.this.exception = SOAPClient.this.exceptionMessage != null ? new SMSException(SOAPClient.this.exceptionMessage) : new SMSException();
                    }
                } else {
                    SOAPClient.this.exception = SOAPClient.this.exceptionClassName.equals(SOAPClient.IDREPOEXCEPTION) ? (SOAPClient.this.resourceBundleName != null ? new IdRepoException(SOAPClient.this.resourceBundleName, SOAPClient.this.exceptionCode, SOAPClient.this.messageArgs == null ? null : SOAPClient.this.messageArgs.toArray()) : (SOAPClient.this.exceptionCode != null ? new IdRepoException(SOAPClient.this.exceptionMessage, SOAPClient.this.exceptionCode) : (SOAPClient.this.exceptionMessage != null ? new IdRepoException(SOAPClient.this.exceptionMessage) : new SMSException()))) : (SOAPClient.this.exceptionClassName.equals(SOAPClient.AMREMOTEEXCEPTION) ? new AMRemoteException(SOAPClient.this.exceptionMessage, SOAPClient.this.exceptionCode, SOAPClient.this.ldapErrorCode, SOAPClient.this.messageArgs != null ? (String[])SOAPClient.this.messageArgs.toArray() : null) : (SOAPClient.this.exceptionClassName.equals(SOAPClient.ENTITYEXCEPTION) ? (SOAPClient.this.messageArgs != null ? new EntityException(SOAPClient.this.exceptionMessage, SOAPClient.this.exceptionCode, SOAPClient.this.messageArgs.toArray()) : new EntityException(SOAPClient.this.exceptionMessage, SOAPClient.this.exceptionCode)) : (SOAPClient.this.exceptionClassName.equals(SOAPClient.SAMLEXCEPTION) ? (SOAPClient.this.exceptionMessage != null ? new SOAPClientException(SOAPClient.this.exceptionClassName, SOAPClient.this.exceptionMessage) : new SOAPClientException(SOAPClient.this.exceptionClassName)) : (SOAPClient.this.exceptionClassName.indexOf(SOAPClient.RMIREMOTEEXCEPTION) != -1 ? new RemoteException(SOAPClient.this.exceptionClassName) : (SOAPClient.this.exceptionMessage != null ? new Exception(SOAPClient.this.exceptionMessage) : new Exception("unknown-exception"))))));
                }
            }
        }

        public void processingInstruction(String target, String data) throws SAXException {
        }

        public void startPrefixMapping(String prefix, String url) {
        }

        public void endPrefixMapping(String prefix) {
        }

        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        public void skippedEntity(String name) throws SAXException {
        }
    }
}

