/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml.common;

import com.sun.identity.common.SystemConfigurationUtil;
import com.sun.identity.saml.common.SAMLConstants;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml.xmlsig.PasswordDecoder;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.encode.Base64;
import com.sun.identity.shared.locale.Locale;
import java.security.SecureRandom;
import java.util.ResourceBundle;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class SAMLUtilsCommon {
    private static String PASSWORD_DECODER = "com.sun.identity.saml.xmlsig.passwordDecoder";
    private static String FM_PASSWORD_DECODER = "com.sun.identity.saml.xmlsig.FMPasswordDecoder";
    public static SecureRandom random = new SecureRandom();
    public static final String SAMLID_PREFIX = "s";
    public static SAMLConstants sc;
    public static ResourceBundle bundle;
    public static Debug debug;

    public static void setResourceBundle(ResourceBundle resBundle) {
        bundle = resBundle;
    }

    public static void setDebugInstance(Debug dbg) {
        debug = dbg;
    }

    public static String generateAssertionID() {
        return SAMLUtilsCommon.generateID();
    }

    public static String generateID() {
        if (random == null) {
            return null;
        }
        byte[] bytes = new byte[20];
        random.nextBytes(bytes);
        String encodedID = SAMLID_PREFIX + SAMLUtilsCommon.byteArrayToHexString(bytes);
        if (debug.messageEnabled()) {
            debug.message("SAMLUtils.generated ID is: " + encodedID);
        }
        return encodedID;
    }

    public static String byteArrayToHexString(byte[] byteArray) {
        int readBytes = byteArray.length;
        StringBuffer hexData = new StringBuffer();
        for (int i = 0; i < readBytes; ++i) {
            int onebyte = 0xFF & byteArray[i] | 0xFFFFFF00;
            hexData.append(Integer.toHexString(onebyte).substring(6));
        }
        return hexData.toString();
    }

    public static String makeEndElementTagXML(String elementName, boolean includeNS) {
        StringBuffer xml = new StringBuffer(100);
        String appendNS = "";
        if (includeNS) {
            appendNS = "saml:";
        }
        xml.append("</").append(appendNS).append(elementName).append(">").append("\n");
        return xml.toString();
    }

    public static String makeStartElementTagXML(String elementName, boolean includeNS, boolean declareNS) {
        StringBuffer xml = new StringBuffer(1000);
        String appendNS = "";
        String NS = "";
        if (includeNS) {
            appendNS = "saml:";
        }
        if (declareNS) {
            NS = " xmlns:saml=\"urn:oasis:names:tc:SAML:1.0:assertion\"";
        }
        xml.append("<").append(appendNS).append(elementName).append(NS).append(">");
        return xml.toString();
    }

    public static boolean checkStatement(Element element, String statementname) {
        String tag = element.getLocalName();
        if (tag == null) {
            return false;
        }
        if (tag.equals("Statement") || tag.equals("SubjectStatement")) {
            NamedNodeMap nm = element.getAttributes();
            int len = nm.getLength();
            String attrName = null;
            Attr attr = null;
            for (int j = 0; j < len; ++j) {
                attr = (Attr)nm.item(j);
                attrName = attr.getLocalName();
                if (attrName == null || !attrName.equals("type") || !attr.getNodeValue().equals(statementname + "Type")) continue;
                return true;
            }
        } else if (tag.equals(statementname)) {
            return true;
        }
        return false;
    }

    public static String decodePassword(String password) {
        String decoPasswd;
        String decodePwdSpi = SystemConfigurationUtil.getProperty(PASSWORD_DECODER, FM_PASSWORD_DECODER);
        try {
            PasswordDecoder pwdDecoder = (PasswordDecoder)Class.forName(decodePwdSpi).newInstance();
            decoPasswd = pwdDecoder.getDecodedPassword(password);
        }
        catch (Throwable t) {
            decoPasswd = password;
        }
        return decoPasswd;
    }

    public static String removeNewLineChars(String s) {
        String retString = null;
        if (s != null && s.length() > 0 && s.indexOf(10) != -1) {
            char[] chars = s.toCharArray();
            int len = chars.length;
            StringBuffer sb = new StringBuffer(len);
            for (int i = 0; i < len; ++i) {
                char c = chars[i];
                if (c == '\n') continue;
                sb.append(c);
            }
            retString = sb.toString();
        } else {
            retString = s;
        }
        return retString;
    }

    public static String getDecodedSourceIDString(String encodedID) {
        String result = null;
        if (encodedID == null) {
            SAMLUtils.debug.error("SAMLUtils.getDecodedSourceIDString: null input.");
            return null;
        }
        try {
            result = SAMLUtilsCommon.byteArrayToString(Base64.decode(encodedID));
        }
        catch (Exception e) {
            SAMLUtils.debug.error("SAMLUtils.getDecodedSourceIDString: ", e);
            return null;
        }
        return result;
    }

    public static String byteArrayToString(byte[] bytes) {
        char[] chars = new char[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            chars[i] = (char)bytes[i];
        }
        return new String(chars);
    }

    static {
        bundle = Locale.getInstallResourceBundle("libSAML");
        debug = Debug.getInstance("libSAML");
    }
}

