/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml.protocol;

import com.sun.identity.saml.assertion.AttributeDesignator;
import com.sun.identity.saml.assertion.Subject;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLRequesterException;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml.protocol.SubjectQuery;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AttributeQuery
extends SubjectQuery {
    protected List attributeDesignators = Collections.EMPTY_LIST;
    protected String resource = null;

    protected AttributeQuery() {
    }

    public AttributeQuery(Element element) throws SAMLException {
        if (element == null) {
            SAMLUtils.debug.message("AttributeQuery(Element): null input.");
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("nullInput"));
        }
        boolean valid = SAMLUtils.checkQuery(element, "AttributeQuery");
        if (!valid) {
            SAMLUtils.debug.message("AttributeQuery: wrong input.");
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
        }
        if (element.hasAttribute("Resource")) {
            this.resource = element.getAttribute("Resource");
        }
        NodeList nl = element.getChildNodes();
        int length = nl.getLength();
        for (int k = 0; k < length; ++k) {
            Node child = nl.item(k);
            String childName = child.getLocalName();
            if (childName == null) continue;
            if (childName.equals("Subject")) {
                if (this.subject != null) {
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("AttributeQuery(Element): contained more than one Subject");
                    }
                    throw new SAMLRequesterException(SAMLUtils.bundle.getString("moreElement"));
                }
                this.subject = new Subject((Element)child);
                continue;
            }
            if (childName.equals("AttributeDesignator")) {
                if (this.attributeDesignators == Collections.EMPTY_LIST) {
                    this.attributeDesignators = new ArrayList();
                }
                this.attributeDesignators.add(new AttributeDesignator((Element)child));
                continue;
            }
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AttributeQuery(Element): included wrong element:" + childName);
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
        }
        if (this.subject == null) {
            SAMLUtils.debug.message("AttributeQuery: missing Subject");
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("missingElement"));
        }
    }

    public AttributeQuery(Subject theSubject, List designators, String theResource) throws SAMLException {
        this.buildAttributeQuery(theSubject, designators, theResource);
    }

    public AttributeQuery(Subject theSubject, List designators) throws SAMLException {
        this.buildAttributeQuery(theSubject, designators, null);
    }

    public AttributeQuery(Subject theSubject) throws SAMLException {
        this.buildAttributeQuery(theSubject, null, null);
    }

    private void buildAttributeQuery(Subject theSubject, List designators, String theResource) throws SAMLException {
        int length;
        if (theSubject == null) {
            SAMLUtils.debug.message("AttributeQuery: missing subject.");
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("missingElement"));
        }
        this.subject = theSubject;
        Object temp = null;
        if (designators != null && (length = designators.size()) != 0) {
            for (int i = 0; i < length; ++i) {
                temp = designators.get(i);
                if (temp instanceof AttributeDesignator) continue;
                if (SAMLUtils.debug.messageEnabled()) {
                    SAMLUtils.debug.message("AttributeQuery: Wrong input for AttributeDesignator.");
                }
                throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
            }
            this.attributeDesignators = designators;
        }
        this.resource = theResource;
    }

    public String getResource() {
        return this.resource;
    }

    public List getAttributeDesignator() {
        return this.attributeDesignators;
    }

    public int getQueryType() {
        return 2;
    }

    public String toString() {
        return this.toString(true, false);
    }

    public String toString(boolean includeNS, boolean declareNS) {
        StringBuffer xml = new StringBuffer(300);
        String prefix = "";
        String uri = "";
        if (includeNS) {
            prefix = "samlp:";
        }
        if (declareNS) {
            uri = " xmlns:samlp=\"urn:oasis:names:tc:SAML:1.0:protocol\"";
        }
        xml.append("<").append(prefix).append("AttributeQuery").append(uri);
        if (this.resource != null) {
            xml.append(" Resource=\"").append(this.resource).append("\"");
        }
        xml.append(">\n").append(this.subject.toString(true, true));
        Iterator iterator = this.attributeDesignators.iterator();
        while (iterator.hasNext()) {
            xml.append(((AttributeDesignator)iterator.next()).toString(true, true));
        }
        xml.append("</").append(prefix).append("AttributeQuery>\n");
        return xml.toString();
    }
}

