/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml2.assertion.impl;

import com.sun.identity.saml2.assertion.AssertionFactory;
import com.sun.identity.saml2.assertion.BaseID;
import com.sun.identity.saml2.assertion.EncryptedID;
import com.sun.identity.saml2.assertion.NameID;
import com.sun.identity.saml2.assertion.SubjectConfirmation;
import com.sun.identity.saml2.assertion.SubjectConfirmationData;
import com.sun.identity.saml2.common.SAML2Exception;
import com.sun.identity.saml2.common.SAML2SDKUtils;
import com.sun.identity.shared.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SubjectConfirmationImpl
implements SubjectConfirmation {
    private SubjectConfirmationData subjectConfirmationData = null;
    private BaseID baseId = null;
    private NameID nameId = null;
    private EncryptedID encryptedId = null;
    private String method = null;
    private boolean isMutable = true;
    public static final String SUBJECT_CONFIRMATION_ELEMENT = "SubjectConfirmation";
    public static final String SUBJECT_CONFIRMATION_DATA_ELEMENT = "SubjectConfirmationData";
    public static final String BASE_ID_ELEMENT = "BaseID";
    public static final String NAME_ID_ELEMENT = "NameID";
    public static final String ENCRYPTED_ID_ELEMENT = "EncryptedID";
    public static final String METHOD_ATTR = "Method";

    public SubjectConfirmationImpl() {
    }

    public SubjectConfirmationImpl(String xml) throws SAML2Exception {
        Document document = XMLUtils.toDOMDocument(xml, SAML2SDKUtils.debug);
        if (document == null) {
            SAML2SDKUtils.debug.error("SubjectConfirmationImpl.processElement(): invalid XML input");
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("errorObtainingElement"));
        }
        Element rootElement = document.getDocumentElement();
        this.processElement(rootElement);
        this.makeImmutable();
    }

    public SubjectConfirmationImpl(Element element) throws SAML2Exception {
        this.processElement(element);
        this.makeImmutable();
    }

    private void processElement(Element element) throws SAML2Exception {
        if (element == null) {
            SAML2SDKUtils.debug.error("SubjectConfirmationImpl.processElement(): invalid root element");
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("invalid_element"));
        }
        String elemName = element.getLocalName();
        if (elemName == null) {
            SAML2SDKUtils.debug.error("SubjectConfirmationImpl.processElement(): local name missing");
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("missing_local_name"));
        }
        if (!elemName.equals(SUBJECT_CONFIRMATION_ELEMENT)) {
            SAML2SDKUtils.debug.error("SubjectConfirmationImpl.processElement(): invalid local name " + elemName);
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("invalid_local_name"));
        }
        String attrValue = element.getAttribute(METHOD_ATTR);
        if (attrValue == null || attrValue.length() == 0) {
            SAML2SDKUtils.debug.error("SubjectConfirmationImpl.processElement(): method missing");
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("missing_confirmation_method"));
        }
        this.method = attrValue;
        NodeList nodes = element.getChildNodes();
        int numOfNodes = nodes.getLength();
        if (numOfNodes < 1) {
            return;
        }
        int nextElem = 0;
        Node child = nodes.item(nextElem);
        while (child.getNodeType() != 1) {
            if (++nextElem >= numOfNodes) {
                return;
            }
            child = nodes.item(nextElem);
        }
        String childName = child.getLocalName();
        if (childName != null) {
            if (childName.equals(SUBJECT_CONFIRMATION_DATA_ELEMENT)) {
                this.subjectConfirmationData = AssertionFactory.getInstance().createSubjectConfirmationData((Element)child);
            } else if (childName.equals(BASE_ID_ELEMENT)) {
                this.baseId = AssertionFactory.getInstance().createBaseID((Element)child);
            } else if (childName.equals(NAME_ID_ELEMENT)) {
                this.nameId = AssertionFactory.getInstance().createNameID((Element)child);
            } else if (childName.equals(ENCRYPTED_ID_ELEMENT)) {
                this.encryptedId = AssertionFactory.getInstance().createEncryptedID((Element)child);
            } else {
                SAML2SDKUtils.debug.error("SubjectConfirmationImpl.processElement(): unexpected subelement " + childName);
                throw new SAML2Exception(SAML2SDKUtils.bundle.getString("unexpected_subelement"));
            }
        }
    }

    public EncryptedID getEncryptedID() {
        return this.encryptedId;
    }

    public void setEncryptedID(EncryptedID value) throws SAML2Exception {
        if (!this.isMutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.encryptedId = value;
    }

    public NameID getNameID() {
        return this.nameId;
    }

    public void setNameID(NameID value) throws SAML2Exception {
        if (!this.isMutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.nameId = value;
    }

    public SubjectConfirmationData getSubjectConfirmationData() {
        return this.subjectConfirmationData;
    }

    public void setSubjectConfirmationData(SubjectConfirmationData value) throws SAML2Exception {
        if (!this.isMutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.subjectConfirmationData = value;
    }

    public BaseID getBaseID() {
        return this.baseId;
    }

    public void setBaseID(BaseID value) throws SAML2Exception {
        if (!this.isMutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.baseId = value;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String value) throws SAML2Exception {
        if (!this.isMutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.method = value;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String toXMLString(boolean includeNSPrefix, boolean declareNS) throws SAML2Exception {
        String appendNS;
        StringBuffer sb;
        block8: {
            block9: {
                block10: {
                    sb = new StringBuffer(2000);
                    String NS = "";
                    appendNS = "";
                    if (declareNS) {
                        NS = " xmlns:saml=\"urn:oasis:names:tc:SAML:2.0:assertion\"";
                    }
                    if (includeNSPrefix) {
                        appendNS = "saml:";
                    }
                    sb.append("<").append(appendNS).append(SUBJECT_CONFIRMATION_ELEMENT).append(NS);
                    if (this.method == null || this.method.trim().length() == 0) {
                        SAML2SDKUtils.debug.error("SubjectConfirmationImpl.toXMLString(): method missing");
                        throw new SAML2Exception(SAML2SDKUtils.bundle.getString("missing_confirmation_method"));
                    }
                    sb.append(" ").append(METHOD_ATTR).append("=\"").append(this.method).append("\"").append(">\n");
                    if (this.subjectConfirmationData != null) break block9;
                    if (this.baseId == null && this.nameId == null && this.encryptedId == null) break block8;
                    if (this.baseId == null || this.nameId != null || this.encryptedId != null) break block10;
                    sb.append(this.baseId.toXMLString(includeNSPrefix, false));
                    break block8;
                }
                if (this.nameId != null && this.baseId == null && this.encryptedId == null) {
                    sb.append(this.nameId.toXMLString(includeNSPrefix, false));
                    break block8;
                } else if (this.encryptedId != null && this.baseId == null && this.nameId == null) {
                    sb.append(this.encryptedId.toXMLString(includeNSPrefix, false));
                    break block8;
                } else {
                    SAML2SDKUtils.debug.error("SubjectConfirmationImpl.toXMLString(): more than one types of id specified");
                    throw new SAML2Exception(SAML2SDKUtils.bundle.getString("too_many_ids_specified"));
                }
            }
            if (this.baseId != null || this.nameId != null || this.encryptedId != null) {
                SAML2SDKUtils.debug.error("SubjectConfirmationImpl.toXMLString(): Only one of the ids or confirmation can be specified");
                throw new SAML2Exception(SAML2SDKUtils.bundle.getString("id_and_confirmation_both_specified"));
            }
            sb.append(this.subjectConfirmationData.toXMLString(includeNSPrefix, false));
        }
        sb.append("</").append(appendNS).append(SUBJECT_CONFIRMATION_ELEMENT).append(">\n");
        return sb.toString();
    }

    public String toXMLString() throws SAML2Exception {
        return this.toXMLString(true, false);
    }

    public void makeImmutable() {
        if (this.isMutable) {
            if (this.subjectConfirmationData != null) {
                this.subjectConfirmationData.makeImmutable();
            }
            if (this.baseId != null) {
                this.baseId.makeImmutable();
            }
            if (this.nameId != null) {
                this.nameId.makeImmutable();
            }
            this.isMutable = false;
        }
    }

    public boolean isMutable() {
        return this.isMutable;
    }
}

