/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml2.meta;

import com.sun.identity.saml2.jaxb.entityconfig.EntityConfigElement;
import com.sun.identity.saml2.jaxb.metadata.EntityDescriptorElement;
import com.sun.identity.saml2.meta.SAML2MetaUtils;
import com.sun.identity.shared.debug.Debug;
import java.util.Hashtable;

class SAML2MetaCache {
    private static Debug debug = SAML2MetaUtils.debug;
    private static Hashtable descriptorCache = new Hashtable();
    private static Hashtable configCache = new Hashtable();

    private SAML2MetaCache() {
    }

    static EntityDescriptorElement getEntityDescriptor(String realm, String entityId) {
        String cacheKey = SAML2MetaCache.buildCacheKey(realm, entityId);
        EntityDescriptorElement descriptor = (EntityDescriptorElement)descriptorCache.get(cacheKey);
        if (debug.messageEnabled()) {
            debug.message("SAML2MetaCache.getEntityDescriptor: cacheKey = " + cacheKey + ", found = " + (descriptor != null));
        }
        return descriptor;
    }

    static void putEntityDescriptor(String realm, String entityId, EntityDescriptorElement descriptor) {
        String cacheKey = SAML2MetaCache.buildCacheKey(realm, entityId);
        if (descriptor != null) {
            if (debug.messageEnabled()) {
                debug.message("SAML2MetaCache.putEntityDescriptor: cacheKey = " + cacheKey);
            }
            descriptorCache.put(cacheKey, descriptor);
        } else {
            if (debug.messageEnabled()) {
                debug.message("SAML2MetaCache.putEntityDescriptor: delete cacheEey = " + cacheKey);
            }
            descriptorCache.remove(cacheKey);
            configCache.remove(cacheKey);
        }
    }

    static EntityConfigElement getEntityConfig(String realm, String entityId) {
        String cacheKey = SAML2MetaCache.buildCacheKey(realm, entityId);
        EntityConfigElement config = (EntityConfigElement)configCache.get(cacheKey);
        if (debug.messageEnabled()) {
            debug.message("SAML2MetaCache.getEntityConfig: cacheKey = " + cacheKey + ", found = " + (config != null));
        }
        return config;
    }

    static void putEntityConfig(String realm, String entityId, EntityConfigElement config) {
        String cacheKey = SAML2MetaCache.buildCacheKey(realm, entityId);
        if (config != null) {
            if (debug.messageEnabled()) {
                debug.message("SAML2MetaCache.putEntityConfig: cacheKey = " + cacheKey);
            }
            configCache.put(cacheKey, config);
        } else {
            if (debug.messageEnabled()) {
                debug.message("SAML2MetaCache.putEntityConfig: delete cacheKey = " + cacheKey);
            }
            configCache.remove(cacheKey);
        }
    }

    static void clear() {
        descriptorCache.clear();
        configCache.clear();
    }

    private static String buildCacheKey(String realm, String entityId) {
        return realm + "//" + entityId;
    }
}

