/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.shared.encode;

import com.sun.identity.shared.configuration.SystemPropertiesManager;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.encode.URLEncDec;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

public class CookieUtils {
    static boolean secureCookie = SystemPropertiesManager.get("com.iplanet.am.cookie.secure") != null && SystemPropertiesManager.get("com.iplanet.am.cookie.secure").equalsIgnoreCase("true");
    static boolean cookieEncoding = SystemPropertiesManager.get("com.iplanet.am.cookie.encode") != null && SystemPropertiesManager.get("com.iplanet.am.cookie.encode").equalsIgnoreCase("true");
    static String amCookieName = SystemPropertiesManager.get("com.iplanet.am.cookie.name");
    static String amPCookieName = SystemPropertiesManager.get("com.iplanet.am.pcookie.name");
    static String cdssoCookiedomain = SystemPropertiesManager.get("com.iplanet.services.cdsso.cookiedomain");
    static String fedCookieName = SystemPropertiesManager.get("com.sun.identity.federation.fedCookieName");
    private static Set cookieDomains = null;
    private static int defAge = -1;
    static Debug debug = Debug.getInstance("amCookieUtils");

    public static String getAmCookieName() {
        return amCookieName;
    }

    public static String getAmPCookieName() {
        return amPCookieName;
    }

    public static Set getCdssoCookiedomain() {
        if (cookieDomains != null) {
            return cookieDomains;
        }
        HashSet<String> cookieDomains = new HashSet<String>();
        if (cdssoCookiedomain == null || cdssoCookiedomain.length() < 1) {
            return Collections.EMPTY_SET;
        }
        StringTokenizer st = new StringTokenizer(cdssoCookiedomain, ",");
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            if (token.length() <= 0) continue;
            cookieDomains.add(token);
        }
        return cookieDomains.isEmpty() ? Collections.EMPTY_SET : cookieDomains;
    }

    public static String getFedCookieName() {
        return fedCookieName;
    }

    public static boolean isCookieSecure() {
        return secureCookie;
    }

    public static String getCookieValueFromReq(HttpServletRequest req, String name) {
        String cookieValue = null;
        Cookie cookie = CookieUtils.getCookieFromReq(req, name);
        if (cookie != null) {
            cookieValue = CookieUtils.getCookieValue(cookie);
        } else {
            debug.message("No Cookie is in the request");
        }
        return cookieValue;
    }

    public static Cookie getCookieFromReq(HttpServletRequest req, String name) {
        Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            for (int nCookie = 0; nCookie < cookies.length; ++nCookie) {
                if (!cookies[nCookie].getName().equalsIgnoreCase(name)) continue;
                return cookies[nCookie];
            }
        }
        return null;
    }

    public static String getCookieValue(Cookie cookie) {
        String cookieValue = CookieUtils.checkDoubleQuote(cookie.getValue());
        if (cookieValue != null && cookieEncoding) {
            return URLEncDec.decode(cookieValue);
        }
        return cookieValue;
    }

    public static Cookie[] getCookieArrayFromReq(HttpServletRequest req) {
        Cookie[] cookies = req.getCookies();
        if (!cookieEncoding) {
            return cookies;
        }
        if (cookies != null) {
            for (int nCookie = 0; nCookie < cookies.length; ++nCookie) {
                String cookieValue = CookieUtils.checkDoubleQuote(cookies[nCookie].getValue());
                if (cookieValue == null) continue;
                cookies[nCookie].setValue(URLEncDec.decode(cookieValue));
            }
        }
        return cookies;
    }

    public static Cookie newCookie(String name, String value) {
        return CookieUtils.newCookie(name, value, defAge, null, null);
    }

    public static Cookie newCookie(String name, String value, int maxAge) {
        return CookieUtils.newCookie(name, value, maxAge, null, null);
    }

    public static Cookie newCookie(String name, String value, String path) {
        return CookieUtils.newCookie(name, value, defAge, path, null);
    }

    public static Cookie newCookie(String name, String value, String path, String domain) {
        return CookieUtils.newCookie(name, value, defAge, path, domain);
    }

    public static Cookie newCookie(String name, String value, int maxAge, String path, String domain) {
        Cookie cookie = null;
        cookie = cookieEncoding ? new Cookie(name, URLEncDec.encode(value)) : new Cookie(name, value);
        cookie.setMaxAge(maxAge);
        if (path != null && path.length() > 0) {
            cookie.setPath(path);
        } else {
            cookie.setPath("/");
        }
        if (domain != null && domain.length() > 0) {
            cookie.setDomain(domain);
        }
        cookie.setSecure(CookieUtils.isCookieSecure());
        return cookie;
    }

    public static String checkDoubleQuote(String cookie) {
        String double_quote = "\"";
        if (cookie != null && cookie.startsWith(double_quote) && cookie.endsWith(double_quote)) {
            int last = cookie.length() - 1;
            cookie = cookie.substring(1, last);
        }
        return cookie;
    }
}

