/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.wss.sts;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.shared.xml.XMLUtils;
import com.sun.identity.wss.sts.ClientUserToken;
import com.sun.identity.wss.sts.FAMSTSException;
import com.sun.identity.wss.sts.STSUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class STSClientUserToken
implements ClientUserToken {
    String tokenId = null;
    String tokenType = null;

    public STSClientUserToken() {
    }

    public void init(Object credential) throws FAMSTSException {
        try {
            SSOToken ssoToken = (SSOToken)credential;
            SSOTokenManager.getInstance().validateToken(ssoToken);
            this.tokenId = ((Object)ssoToken.getTokenID()).toString();
            this.tokenType = "FAMSSOToken";
        }
        catch (SSOException se) {
            throw new FAMSTSException(se.getMessage());
        }
    }

    public STSClientUserToken(Element element) throws FAMSTSException {
        if (element == null) {
            throw new FAMSTSException();
        }
        String localName = element.getLocalName();
        if (!"FAMToken".equals(localName)) {
            throw new FAMSTSException();
        }
        NodeList nl = element.getChildNodes();
        int length = nl.getLength();
        if (length == 0) {
            throw new FAMSTSException();
        }
        for (int i = 0; i < length; ++i) {
            Node child = nl.item(i);
            if (child.getNodeType() != 1) continue;
            String childName = child.getLocalName();
            if (childName.equals("TokenValue")) {
                this.tokenId = XMLUtils.getElementValue((Element)child);
                continue;
            }
            if (!childName.equals("TokenType")) continue;
            this.tokenType = XMLUtils.getElementValue((Element)child);
        }
    }

    public Element getTokenValue() {
        Document document = XMLUtils.toDOMDocument(this.toString(), STSUtils.debug);
        return document.getDocumentElement();
    }

    public String getTokenId() {
        return this.tokenId;
    }

    public String getPrincipalName() throws FAMSTSException {
        try {
            SSOToken ssoToken = SSOTokenManager.getInstance().createSSOToken(this.tokenId);
            return ssoToken.getPrincipal().getName();
        }
        catch (SSOException se) {
            throw new FAMSTSException(se.getMessage());
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<fam:FAMToken xmlns:fam=\"").append("http://www.sun.com/identity/famtoken").append("\"").append(">").append("\n").append("<fam:TokenValue>").append(this.tokenId).append("</fam:TokenValue>").append("\n").append("<fam:TokenType>").append(this.tokenType).append("</fam:TokenType>").append("\n").append("</fam:FAMToken>");
        return sb.toString();
    }

    public String getType() {
        return this.tokenType;
    }
}

