/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.xacml.context.impl;

import com.sun.identity.shared.xml.XMLUtils;
import com.sun.identity.xacml.common.XACMLConstants;
import com.sun.identity.xacml.common.XACMLException;
import com.sun.identity.xacml.common.XACMLSDKUtils;
import com.sun.identity.xacml.context.Action;
import com.sun.identity.xacml.context.ContextFactory;
import com.sun.identity.xacml.context.Environment;
import com.sun.identity.xacml.context.Request;
import com.sun.identity.xacml.context.Resource;
import com.sun.identity.xacml.context.Subject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RequestImpl
implements Request {
    private List subjects = new ArrayList();
    private List resources = new ArrayList();
    private Action action = null;
    private Environment env = null;
    private boolean isMutable = true;
    private static Set supportedSubjectCategory = new HashSet();

    public RequestImpl() {
    }

    public RequestImpl(String xml) throws XACMLException {
        Document document = XMLUtils.toDOMDocument(xml, XACMLSDKUtils.debug);
        if (document == null) {
            XACMLSDKUtils.debug.error("RequestImpl.processElement(): invalid XML input");
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("errorObtainingElement"));
        }
        Element rootElement = document.getDocumentElement();
        this.processElement(rootElement);
        this.makeImmutable();
    }

    public RequestImpl(Element element) throws XACMLException {
        this.processElement(element);
        this.makeImmutable();
    }

    private void processElement(Element element) throws XACMLException {
        Node child;
        if (element == null) {
            XACMLSDKUtils.debug.error("RequestImpl.processElement(): invalid root element");
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("invalid_element"));
        }
        String elemName = element.getLocalName();
        if (elemName == null) {
            XACMLSDKUtils.debug.error("RequestImpl.processElement(): local name missing");
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("missing_local_name"));
        }
        if (!elemName.equals(XACMLConstants.REQUEST)) {
            XACMLSDKUtils.debug.error("RequestImpl.processElement(): invalid local name " + elemName);
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("invalid_local_name"));
        }
        NodeList nodes = element.getChildNodes();
        int numOfNodes = nodes.getLength();
        if (numOfNodes < 1) {
            XACMLSDKUtils.debug.error("RequestImpl.processElement(): request has no subelements");
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("missing_subelements"));
        }
        ContextFactory factory = ContextFactory.getInstance();
        ArrayList<Node> children = new ArrayList<Node>();
        for (int i = 0; i < numOfNodes; ++i) {
            child = nodes.item(i);
            if (child.getNodeType() != 1) continue;
            children.add(child);
        }
        if (children.isEmpty()) {
            XACMLSDKUtils.debug.error("RequestImpl.processElement(): request has no subelements");
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("missing_subelements"));
        }
        child = (Node)children.get(0);
        String childName = child.getLocalName();
        if (childName == null || !childName.equals(XACMLConstants.SUBJECT)) {
            XACMLSDKUtils.debug.error("RequestImpl.processElement(): the first element is not <Subject>");
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("missing_subelement_subject"));
        }
        Subject subject = factory.getInstance().createSubject((Element)child);
        if (!supportedSubjectCategory.contains(subject.getSubjectCategory().toString())) {
            XACMLSDKUtils.debug.error("RequestImpl.processElement():subject category in subject not supported");
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("unsupported_subject_category"));
        }
        this.subjects.add(subject);
        boolean resourceFound = false;
        boolean actionFound = false;
        boolean envFound = false;
        for (int j = 1; j < children.size(); ++j) {
            child = (Node)children.get(j);
            childName = child.getLocalName();
            if (childName != null && (childName.equals(XACMLConstants.RESOURCE) || childName.equals(XACMLConstants.SUBJECT))) {
                Resource resource;
                if (resourceFound) {
                    if (childName.equals(XACMLConstants.SUBJECT)) {
                        XACMLSDKUtils.debug.error("RequestImpl.processElement(): <Subject> should be before <Resource>");
                        throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("element_out_of_place"));
                    }
                    resource = factory.getInstance().createResource((Element)child);
                    this.resources.add(resource);
                    continue;
                }
                if (childName.equals(XACMLConstants.SUBJECT)) {
                    subject = factory.getInstance().createSubject((Element)child);
                    this.subjects.add(subject);
                    continue;
                }
                resourceFound = true;
                resource = factory.getInstance().createResource((Element)child);
                this.resources.add(resource);
                continue;
            }
            if (childName != null && childName.equals(XACMLConstants.ACTION)) {
                if (!resourceFound) {
                    XACMLSDKUtils.debug.error("RequestImpl.processElement(): <Resource> should be before <Action>");
                    throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("element_out_of_place"));
                }
                actionFound = true;
                this.action = factory.createAction((Element)child);
                continue;
            }
            if (childName == null || !childName.equals(XACMLConstants.ENVIRONMENT)) continue;
            if (!resourceFound || !actionFound) {
                XACMLSDKUtils.debug.error("RequestImpl.processElement(): <Resource> and Action should be before <Environment>");
                throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("element_out_of_place"));
            }
            envFound = true;
            this.env = factory.createEnvironment((Element)child);
        }
        if (XACMLSDKUtils.debug.messageEnabled()) {
            XACMLSDKUtils.debug.message("resourceFound:" + resourceFound);
            XACMLSDKUtils.debug.message("actionFound:" + actionFound);
            XACMLSDKUtils.debug.message("envFound:" + envFound);
        }
        if (!(resourceFound && actionFound && envFound)) {
            XACMLSDKUtils.debug.error("RequestImpl.processElement(): Someof required elements are missing");
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("missing_subelements"));
        }
    }

    public List getSubjects() {
        return this.subjects;
    }

    public void setSubjects(List subjects) throws XACMLException {
        if (!this.isMutable) {
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("objectImmutable"));
        }
        if (subjects == null || subjects.isEmpty()) {
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("null_not_valid"));
        }
        this.subjects.addAll(subjects);
    }

    public List getResources() {
        return this.resources;
    }

    public void setResources(List resources) throws XACMLException {
        if (!this.isMutable) {
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("objectImmutable"));
        }
        if (resources == null || resources.isEmpty()) {
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("null_not_valid"));
        }
        this.resources.addAll(resources);
    }

    public Action getAction() {
        return this.action;
    }

    public void setAction(Action argAction) throws XACMLException {
        if (!this.isMutable) {
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("objectImmutable"));
        }
        if (argAction == null) {
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("null_not_valid"));
        }
        this.action = argAction;
    }

    public Environment getEnvironment() {
        return this.env;
    }

    public void setEnvironment(Environment argEnv) throws XACMLException {
        if (!this.isMutable) {
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("objectImmutable"));
        }
        if (argEnv == null) {
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("null_not_valid"));
        }
        this.env = argEnv;
    }

    public String toXMLString(boolean includeNSPrefix, boolean declareNS) throws XACMLException {
        int i;
        StringBuffer sb = new StringBuffer(2000);
        StringBuffer namespaceBuffer = new StringBuffer(100);
        String nsDeclaration = "";
        if (declareNS) {
            namespaceBuffer.append(XACMLConstants.CONTEXT_NS_DECLARATION).append(XACMLConstants.SPACE);
            namespaceBuffer.append(XACMLConstants.XSI_NS_URI).append(XACMLConstants.SPACE).append(XACMLConstants.CONTEXT_SCHEMA_LOCATION);
        }
        if (includeNSPrefix) {
            nsDeclaration = XACMLConstants.CONTEXT_NS_PREFIX + ":";
        }
        sb.append("\n<").append(nsDeclaration).append(XACMLConstants.REQUEST).append(namespaceBuffer).append(">\n");
        int length = 0;
        if (this.subjects != null && !this.subjects.isEmpty()) {
            length = this.subjects.size();
            for (i = 0; i < length; ++i) {
                Subject sub = (Subject)this.subjects.get(i);
                sb.append(sub.toXMLString(includeNSPrefix, false));
            }
        }
        if (this.resources != null && !this.resources.isEmpty()) {
            length = this.resources.size();
            for (i = 0; i < length; ++i) {
                Resource resource = (Resource)this.resources.get(i);
                sb.append(resource.toXMLString(includeNSPrefix, false));
            }
        }
        if (this.action != null) {
            sb.append(this.action.toXMLString(includeNSPrefix, false));
        }
        if (this.env != null) {
            sb.append(this.env.toXMLString(includeNSPrefix, false));
        }
        sb.append("</").append(nsDeclaration).append(XACMLConstants.REQUEST).append(">\n");
        return sb.toString();
    }

    public String toXMLString() throws XACMLException {
        return this.toXMLString(true, false);
    }

    public void makeImmutable() {
    }

    public boolean isMutable() {
        return this.isMutable;
    }

    static {
        supportedSubjectCategory.add(XACMLConstants.ACCESS_SUBJECT);
        supportedSubjectCategory.add(XACMLConstants.INTERMEDIARY_SUBJECT);
    }
}

