/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.db;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.cfg.Configuration;
import org.hibernate.connection.ConnectionProvider;
import org.hibernate.connection.ConnectionProviderFactory;
import org.hibernate.dialect.Dialect;
import org.hibernate.mapping.Table;
import org.hibernate.tool.hbm2ddl.DatabaseMetadata;
import org.hibernate.tool.hbm2ddl.TableMetadata;
import org.hibernate.util.JDBCExceptionReporter;
import org.jbpm.JbpmException;

public class JbpmSchema {
    private final Configuration configuration;
    private ConnectionProvider connectionProvider;
    private String delimiter;
    private final List exceptions = new ArrayList();
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    public JbpmSchema(Configuration configuration) {
        this.configuration = configuration;
    }

    private Dialect getDialect() {
        return Dialect.getDialect((Properties)this.configuration.getProperties());
    }

    private String getDefaultCatalog() {
        return this.configuration.getProperty("hibernate.default_catalog");
    }

    private String getDefaultSchema() {
        return this.configuration.getProperty("hibernate.default_schema");
    }

    private boolean getShowSql() {
        return "true".equalsIgnoreCase(this.configuration.getProperty("hibernate.show_sql"));
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public List getExceptions() {
        return this.exceptions;
    }

    public String[] getCreateSql() {
        return this.configuration.generateSchemaCreationScript(this.getDialect());
    }

    public String[] getDropSql() {
        return this.configuration.generateDropSchemaScript(this.getDialect());
    }

    public String[] getCleanSql() {
        return JbpmSchema.concat(this.getDropSql(), this.getCreateSql());
    }

    private static String[] concat(String[] array1, String[] array2) {
        int length1 = array1.length;
        int length2 = array2.length;
        String[] result = new String[length1 + length2];
        System.arraycopy(array1, 0, result, 0, length1);
        System.arraycopy(array2, 0, result, length1, length2);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getUpdateSql() {
        Connection connection = null;
        try {
            connection = this.createConnection();
            String[] stringArray = this.configuration.generateSchemaUpdateScript(this.getDialect(), this.getDatabaseMetadata(connection));
            return stringArray;
        }
        catch (SQLException e) {
            this.exceptions.add(e);
            JDBCExceptionReporter.logExceptions((SQLException)e, (String)"failed to generate update sql");
            String[] stringArray = EMPTY_STRING_ARRAY;
            return stringArray;
        }
        finally {
            this.closeConnection(connection);
        }
    }

    public void dropSchema() {
        try {
            this.execute(this.getDropSql());
        }
        catch (SQLException e) {
            this.exceptions.add(e);
            JDBCExceptionReporter.logExceptions((SQLException)e, (String)"failed to drop schema");
        }
    }

    public void createSchema() {
        try {
            this.execute(this.getCreateSql());
        }
        catch (SQLException e) {
            this.exceptions.add(e);
            JDBCExceptionReporter.logExceptions((SQLException)e, (String)"failed to create schema");
        }
    }

    public void cleanSchema() {
        try {
            this.execute(this.getCleanSql());
        }
        catch (SQLException e) {
            this.exceptions.add(e);
            JDBCExceptionReporter.logExceptions((SQLException)e, (String)"failed to clean schema");
        }
    }

    public void updateSchema() {
        try {
            this.execute(this.getUpdateSql());
        }
        catch (SQLException e) {
            this.exceptions.add(e);
            JDBCExceptionReporter.logExceptions((SQLException)e, (String)"failed to update schema");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(String[] script) throws SQLException {
        Connection connection = null;
        try {
            connection = this.createConnection();
            Statement statement = connection.createStatement();
            try {
                boolean showSql = this.getShowSql();
                for (int i = 0; i < script.length; ++i) {
                    String sql = script[i];
                    if (showSql) {
                        System.out.println(sql);
                    }
                    this.execute(sql, statement);
                }
            }
            finally {
                statement.close();
            }
        }
        finally {
            this.closeConnection(connection);
        }
    }

    private void execute(String sql, Statement statement) {
        try {
            statement.executeUpdate(sql);
            SQLWarning warning = statement.getWarnings();
            if (warning != null) {
                JDBCExceptionReporter.logWarnings((SQLWarning)warning);
                statement.clearWarnings();
            }
        }
        catch (SQLException e) {
            JDBCExceptionReporter.logExceptions((SQLException)e, (String)"failed to execute update");
            this.exceptions.add(e);
        }
    }

    public void saveSqlScripts(String dir, String prefix) {
        File path = new File(dir);
        if (!path.isDirectory()) {
            throw new JbpmException(path + " is not a directory");
        }
        try {
            this.saveSqlScript(new File(path, prefix + ".drop.sql"), this.getDropSql());
            this.saveSqlScript(new File(path, prefix + ".create.sql"), this.getCreateSql());
            this.saveSqlScript(new File(path, prefix + ".clean.sql"), this.getCleanSql());
        }
        catch (IOException e) {
            throw new JbpmException("failed to generate scripts", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveSqlScript(File file, String[] script) throws IOException {
        FileWriter writer = new FileWriter(file);
        try {
            this.writeSql(writer, script);
        }
        finally {
            ((Writer)writer).close();
        }
    }

    public void writeSql(Writer writer, String[] script) throws IOException {
        String lineSeparator = System.getProperty("line.separator");
        for (int i = 0; i < script.length; ++i) {
            writer.write(script[i]);
            if (this.delimiter != null) {
                writer.write(this.delimiter);
            }
            writer.write(lineSeparator);
        }
    }

    public Set getJbpmTables() {
        HashSet<String> jbpmTables = new HashSet<String>();
        Iterator i = this.configuration.getTableMappings();
        while (i.hasNext()) {
            Table table = (Table)i.next();
            if (!table.isPhysicalTable()) continue;
            jbpmTables.add(table.getName());
        }
        return jbpmTables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getRowsPerTable() {
        Connection connection = null;
        try {
            connection = this.createConnection();
            HashMap<String, Long> rowsPerTable = new HashMap<String, Long>();
            Statement statement = connection.createStatement();
            try {
                Iterator i = this.getJbpmTables().iterator();
                while (i.hasNext()) {
                    String tableName = (String)i.next();
                    String sql = "SELECT COUNT(*) FROM " + tableName;
                    ResultSet resultSet = statement.executeQuery(sql);
                    if (!resultSet.next()) continue;
                    long count = resultSet.getLong(1);
                    if (resultSet.wasNull()) continue;
                    rowsPerTable.put(tableName, new Long(count));
                    resultSet.close();
                }
            }
            finally {
                statement.close();
            }
            HashMap<String, Long> hashMap = rowsPerTable;
            return hashMap;
        }
        catch (SQLException e) {
            this.exceptions.add(e);
            JDBCExceptionReporter.logExceptions((SQLException)e, (String)"could not count records");
            Map map = Collections.EMPTY_MAP;
            return map;
        }
        finally {
            this.closeConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getExistingTables() {
        Connection connection = null;
        try {
            connection = this.createConnection();
            HashSet<String> existingTables = new HashSet<String>();
            DatabaseMetaData metaData = connection.getMetaData();
            boolean storesLowerCaseIdentifiers = metaData.storesLowerCaseIdentifiers();
            ResultSet resultSet = metaData.getTables(this.getDefaultCatalog(), this.getDefaultSchema(), null, new String[]{"TABLE"});
            try {
                while (resultSet.next()) {
                    String tableName = resultSet.getString("TABLE_NAME");
                    if (storesLowerCaseIdentifiers) {
                        tableName = tableName.toUpperCase();
                    }
                    existingTables.add(tableName);
                }
            }
            finally {
                resultSet.close();
            }
            HashSet<String> hashSet = existingTables;
            return hashSet;
        }
        catch (SQLException e) {
            this.exceptions.add(e);
            JDBCExceptionReporter.logExceptions((SQLException)e, (String)"could not get available table names");
            Set set = Collections.EMPTY_SET;
            return set;
        }
        finally {
            this.closeConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tableExists(String tableName) {
        Connection connection = null;
        try {
            connection = this.createConnection();
            Table table = this.findTableMapping(tableName);
            boolean bl = this.getTableMetadata(connection, table) != null;
            return bl;
        }
        catch (SQLException e) {
            this.exceptions.add(e);
            JDBCExceptionReporter.logExceptions((SQLException)e, (String)"could not determine whether table exists");
            boolean bl = false;
            return bl;
        }
        finally {
            this.closeConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTable(String tableName) {
        Connection connection = null;
        try {
            connection = this.createConnection();
            Table table = this.findTableMapping(tableName);
            Iterator script = table.sqlAlterStrings(this.getDialect(), this.configuration.buildMapping(), this.getTableMetadata(connection, table), this.getDefaultCatalog(), this.getDefaultSchema());
            Statement statement = connection.createStatement();
            try {
                while (script.hasNext()) {
                    String sql = (String)script.next();
                    this.execute(sql, statement);
                }
            }
            finally {
                statement.close();
            }
        }
        catch (SQLException e) {
            this.exceptions.add(e);
            JDBCExceptionReporter.logExceptions((SQLException)e, (String)"failed to update table");
        }
        finally {
            this.closeConnection(connection);
        }
    }

    private Table findTableMapping(String tableName) {
        Iterator i = this.configuration.getTableMappings();
        while (i.hasNext()) {
            Table table = (Table)i.next();
            if (!tableName.equals(table.getName())) continue;
            return table;
        }
        throw new JbpmException("no mapping found for table: " + tableName);
    }

    private DatabaseMetadata getDatabaseMetadata(Connection connection) throws SQLException {
        return new DatabaseMetadata(connection, this.getDialect());
    }

    private TableMetadata getTableMetadata(Connection connection, Table table) throws SQLException {
        String tableSchema = table.getSchema();
        String tableCatalog = table.getCatalog();
        return this.getDatabaseMetadata(connection).getTableMetadata(table.getName(), tableSchema != null ? tableSchema : this.getDefaultSchema(), tableCatalog != null ? tableCatalog : this.getDefaultCatalog(), table.isQuoted());
    }

    public void createTable(String tableName) {
        Table table = this.findTableMapping(tableName);
        String sql = table.sqlCreateString(this.getDialect(), this.configuration.buildMapping(), this.getDefaultCatalog(), this.getDefaultSchema());
        try {
            this.execute(new String[]{sql});
        }
        catch (SQLException e) {
            this.exceptions.add(e);
            JDBCExceptionReporter.logExceptions((SQLException)e, (String)"failed to create table");
        }
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            String action = args[0];
            if ("create".equalsIgnoreCase(action)) {
                JbpmSchema.getJbpmSchema(args, 1).createSchema();
            } else if ("drop".equalsIgnoreCase(action)) {
                JbpmSchema.getJbpmSchema(args, 1).dropSchema();
            } else if ("clean".equalsIgnoreCase(action)) {
                JbpmSchema.getJbpmSchema(args, 1).cleanSchema();
            } else if ("scripts".equalsIgnoreCase(action) && args.length > 2) {
                JbpmSchema.getJbpmSchema(args, 3).saveSqlScripts(args[1], args[2]);
            } else {
                JbpmSchema.syntax();
            }
        } else {
            JbpmSchema.syntax();
        }
    }

    private static void syntax() {
        System.err.println("Syntax:");
        System.err.println("JbpmSchema create [<hibernate.cfg.xml> [<hibernate.properties>]]");
        System.err.println("JbpmSchema drop [<hibernate.cfg.xml> [<hibernate.properties>]]");
        System.err.println("JbpmSchema clean [<hibernate.cfg.xml> [<hibernate.properties>]]");
        System.err.println("JbpmSchema scripts <dir> <prefix> [<hibernate.cfg.xml> [<hibernate.properties>]]");
        System.exit(1);
    }

    private static JbpmSchema getJbpmSchema(String[] args, int index) {
        Configuration configuration = new Configuration();
        if (index < args.length) {
            String hibernateCfgXml = args[index];
            configuration.configure(new File(hibernateCfgXml));
            if (index + 1 < args.length) {
                String hibernateProperties = args[index + 1];
                try {
                    FileInputStream inputStream = new FileInputStream(hibernateProperties);
                    Properties properties = new Properties();
                    properties.load(inputStream);
                    configuration.addProperties(properties);
                }
                catch (IOException e) {
                    throw new JbpmException("failed to load hibernate properties", e);
                }
            }
        } else {
            configuration.configure();
        }
        return new JbpmSchema(configuration);
    }

    private Connection createConnection() throws SQLException {
        try {
            this.connectionProvider = ConnectionProviderFactory.newConnectionProvider((Properties)this.configuration.getProperties());
        }
        catch (HibernateException e) {
            throw new SQLException(e.getMessage());
        }
        Connection connection = this.connectionProvider.getConnection();
        if (!connection.getAutoCommit()) {
            connection.commit();
            connection.setAutoCommit(true);
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeConnection(Connection connection) {
        if (this.connectionProvider != null) {
            try {
                if (connection != null) {
                    JDBCExceptionReporter.logAndClearWarnings((Connection)connection);
                    this.connectionProvider.closeConnection(connection);
                }
            }
            catch (SQLException e) {
                this.exceptions.add(e);
                JDBCExceptionReporter.logExceptions((SQLException)e);
            }
            finally {
                this.connectionProvider.close();
                this.connectionProvider = null;
            }
        }
    }
}

