/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.security.util;

import sun.io.CharToByteConverter;
import sun.io.ConversionBufferFullException;
import sun.io.MalformedInputException;
import sun.io.UnknownCharacterException;

public class CharToBytePrintable
extends CharToByteConverter {
    public String getCharacterEncoding() {
        return "ASN.1 Printable";
    }

    public static boolean isPrintableChar(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == ' ' || c == '\'' || c == '(' || c == ')' || c == '+' || c == ',' || c == '-' || c == '.' || c == '/' || c == ':' || c == '=' || c == '?';
    }

    public int convert(char[] input, int inStart, int inEnd, byte[] output, int outStart, int outEnd) throws MalformedInputException, UnknownCharacterException, ConversionBufferFullException {
        int j = outStart;
        int i = inStart;
        while (i < inEnd) {
            if (j >= outEnd) {
                this.charOff = i;
                this.byteOff = j;
                throw new ConversionBufferFullException();
            }
            if (!this.subMode && !CharToBytePrintable.isPrintableChar(input[i])) {
                this.charOff = i;
                this.byteOff = j;
                this.badInputLength = 1;
                throw new UnknownCharacterException();
            }
            output[j] = (byte)(input[i] & 0x7F);
            ++i;
            ++j;
        }
        this.charOff = i;
        this.byteOff = j;
        return j - outStart;
    }

    public int flush(byte[] output, int outStart, int outEnd) throws MalformedInputException, ConversionBufferFullException {
        return 0;
    }

    public void reset() {
    }

    public int getMaxBytesPerChar() {
        return 1;
    }
}

