/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import java.util.BitSet;
import org.apache.jackrabbit.core.query.lucene.DocId;
import org.apache.jackrabbit.core.query.lucene.DocNumberCache;
import org.apache.jackrabbit.core.query.lucene.FieldNames;
import org.apache.jackrabbit.core.query.lucene.SingleTermDocs;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.FilterIndexReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CachingIndexReader
extends FilterIndexReader {
    private static final Logger log = LoggerFactory.getLogger((Class)CachingIndexReader.class);
    private static long currentTick;
    private final DocId[] parents;
    private final long creationTick = CachingIndexReader.getNextCreationTick();
    private final DocNumberCache cache;
    static final TermDocs EMPTY;

    CachingIndexReader(IndexReader delegatee, DocNumberCache cache) {
        super(delegatee);
        this.cache = cache;
        this.parents = new DocId[delegatee.maxDoc()];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DocId getParent(int n, BitSet deleted) throws IOException {
        boolean existing = false;
        DocId parent = this.parents[n];
        if (parent != null) {
            existing = true;
            if (!parent.isValid(deleted)) {
                if (log.isDebugEnabled()) {
                    log.debug(parent + " not valid anymore.");
                }
                parent = null;
            }
        }
        if (parent == null) {
            Document doc = this.document(n);
            String parentUUID = doc.get(FieldNames.PARENT);
            if (parentUUID == null || parentUUID.length() == 0) {
                parent = DocId.NULL;
            } else {
                if (!existing) {
                    Term id = new Term(FieldNames.UUID, parentUUID);
                    TermDocs docs = this.termDocs(id);
                    try {
                        while (docs.next()) {
                            if (deleted.get(docs.doc())) continue;
                            parent = DocId.create(docs.doc());
                            break;
                        }
                    }
                    finally {
                        docs.close();
                    }
                }
                if (parent == null) {
                    parent = DocId.create(parentUUID);
                }
            }
            this.parents[n] = parent;
        }
        return parent;
    }

    public long getCreationTick() {
        return this.creationTick;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TermDocs termDocs(Term term) throws IOException {
        if (term.field() == FieldNames.UUID && this.cache != null) {
            DocNumberCache.Entry e = this.cache.get(term.text());
            if (e != null && e.reader == this && !this.isDeleted(e.doc)) {
                return new SingleTermDocs(e.doc);
            }
            TermDocs docs = this.in.termDocs(term);
            try {
                if (docs.next()) {
                    this.cache.put(term.text(), this, docs.doc());
                    SingleTermDocs singleTermDocs = new SingleTermDocs(docs.doc());
                    return singleTermDocs;
                }
                TermDocs termDocs = EMPTY;
                return termDocs;
            }
            finally {
                docs.close();
            }
        }
        return super.termDocs(term);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getNextCreationTick() {
        Class clazz = CachingIndexReader.class;
        synchronized (clazz) {
            return currentTick++;
        }
    }

    static {
        EMPTY = new TermDocs(){

            public void seek(Term term) {
            }

            public void seek(TermEnum termEnum) {
            }

            public int doc() {
                return -1;
            }

            public int freq() {
                return -1;
            }

            public boolean next() {
                return false;
            }

            public int read(int[] docs, int[] freqs) {
                return 0;
            }

            public boolean skipTo(int target) {
                return false;
            }

            public void close() {
            }
        };
    }
}

