/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import org.apache.jackrabbit.core.query.lucene.FieldNames;
import org.apache.jackrabbit.core.query.lucene.SharedFieldCache;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.ScoreDocComparator;
import org.apache.lucene.search.SortComparator;

public class SharedFieldSortComparator
extends SortComparator {
    static final SortComparator PROPERTIES = new SharedFieldSortComparator(FieldNames.PROPERTIES);
    private final String field;
    private final boolean createComparatorValues;

    public SharedFieldSortComparator(String fieldname) {
        this(fieldname, false);
    }

    public SharedFieldSortComparator(String fieldname, boolean createComparatorValues) {
        this.field = fieldname;
        this.createComparatorValues = createComparatorValues;
    }

    public ScoreDocComparator newComparator(IndexReader reader, String propertyName) throws IOException {
        final FieldCache.StringIndex index = SharedFieldCache.INSTANCE.getStringIndex(reader, this.field, FieldNames.createNamedValue(propertyName, ""), this, this.createComparatorValues);
        return new ScoreDocComparator(){

            public final int compare(ScoreDoc i, ScoreDoc j) {
                int fi = index.order[i.doc];
                int fj = index.order[j.doc];
                if (fi < fj) {
                    return -1;
                }
                if (fi > fj) {
                    return 1;
                }
                return 0;
            }

            public Comparable sortValue(ScoreDoc i) {
                if (index.lookup != null) {
                    return index.lookup[index.order[i.doc]];
                }
                return "";
            }

            public int sortType() {
                return 9;
            }
        };
    }

    protected Comparable getComparable(String termtext) {
        throw new UnsupportedOperationException();
    }
}

