/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.version;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jcr.NodeIterator;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.PropertyImpl;
import org.apache.jackrabbit.core.nodetype.NodeTypeImpl;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.core.version.AbstractVersionManager;
import org.apache.jackrabbit.core.version.InternalFreeze;
import org.apache.jackrabbit.core.version.InternalFreezeImpl;
import org.apache.jackrabbit.core.version.InternalFrozenNode;
import org.apache.jackrabbit.core.version.InternalFrozenVersionHistory;
import org.apache.jackrabbit.core.version.InternalVersionItem;
import org.apache.jackrabbit.core.version.NodeStateEx;
import org.apache.jackrabbit.name.QName;
import org.apache.jackrabbit.uuid.UUID;

class InternalFrozenNodeImpl
extends InternalFreezeImpl
implements InternalFrozenNode {
    private static final int MODE_VERSION = 0;
    private static final int MODE_COPY = 1;
    private static final int MODE_COPY_RECURSIVE = 3;
    private PropertyState[] frozenProperties;
    private InternalFreeze[] frozenNodes = null;
    private UUID frozenUUID = null;
    private QName frozenPrimaryType = null;
    private QName[] frozenMixinTypes = null;

    public InternalFrozenNodeImpl(AbstractVersionManager vMgr, NodeStateEx node, InternalVersionItem parent) throws RepositoryException {
        super(vMgr, node, parent);
        PropertyState[] props;
        try {
            props = node.getProperties();
        }
        catch (ItemStateException e) {
            throw new RepositoryException((Throwable)((Object)e));
        }
        ArrayList<PropertyState> propList = new ArrayList<PropertyState>();
        for (int i = 0; i < props.length; ++i) {
            PropertyState prop = props[i];
            if (prop.getName().equals((Object)QName.JCR_FROZENUUID)) {
                this.frozenUUID = UUID.fromString((String)node.getPropertyValue(QName.JCR_FROZENUUID).internalValue().toString());
                continue;
            }
            if (prop.getName().equals((Object)QName.JCR_FROZENPRIMARYTYPE)) {
                this.frozenPrimaryType = (QName)node.getPropertyValue(QName.JCR_FROZENPRIMARYTYPE).internalValue();
                continue;
            }
            if (prop.getName().equals((Object)QName.JCR_FROZENMIXINTYPES)) {
                InternalValue[] values = node.getPropertyValues(QName.JCR_FROZENMIXINTYPES);
                if (values == null) {
                    this.frozenMixinTypes = new QName[0];
                    continue;
                }
                this.frozenMixinTypes = new QName[values.length];
                for (int j = 0; j < values.length; ++j) {
                    this.frozenMixinTypes[j] = (QName)values[j].internalValue();
                }
                continue;
            }
            if (prop.getName().equals((Object)QName.JCR_PRIMARYTYPE) || prop.getName().equals((Object)QName.JCR_UUID)) continue;
            propList.add(prop);
        }
        this.frozenProperties = propList.toArray(new PropertyState[propList.size()]);
        if (this.frozenMixinTypes == null) {
            this.frozenMixinTypes = new QName[0];
        }
        if (this.frozenPrimaryType == null) {
            throw new RepositoryException("Illegal frozen node. Must have 'frozenPrimaryType'");
        }
    }

    public QName getName() {
        return this.node.getName();
    }

    public NodeId getId() {
        return this.node.getNodeId();
    }

    public synchronized InternalFreeze[] getFrozenChildNodes() throws VersionException {
        if (this.frozenNodes == null) {
            try {
                List entries = this.node.getState().getChildNodeEntries();
                this.frozenNodes = new InternalFreeze[entries.size()];
                Iterator iter = entries.iterator();
                int i = 0;
                while (iter.hasNext()) {
                    NodeState.ChildNodeEntry entry = (NodeState.ChildNodeEntry)iter.next();
                    this.frozenNodes[i++] = (InternalFreeze)this.vMgr.getItem(entry.getId());
                }
            }
            catch (RepositoryException e) {
                throw new VersionException("Unable to retrieve frozen child nodes", (Throwable)e);
            }
        }
        return this.frozenNodes;
    }

    public boolean hasFrozenHistory(UUID uuid) {
        try {
            NodeId id = new NodeId(uuid);
            InternalFreeze[] frozen = this.getFrozenChildNodes();
            for (int i = 0; i < frozen.length; ++i) {
                if (!(frozen[i] instanceof InternalFrozenVersionHistory) || !((InternalFrozenVersionHistory)frozen[i]).getVersionHistoryId().equals(id)) continue;
                return true;
            }
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return false;
    }

    public PropertyState[] getFrozenProperties() {
        return this.frozenProperties;
    }

    public UUID getFrozenUUID() {
        return this.frozenUUID;
    }

    public QName getFrozenPrimaryType() {
        return this.frozenPrimaryType;
    }

    public QName[] getFrozenMixinTypes() {
        return this.frozenMixinTypes;
    }

    protected static NodeStateEx checkin(NodeStateEx parent, QName name, NodeImpl src) throws RepositoryException {
        return InternalFrozenNodeImpl.checkin(parent, name, src, 0);
    }

    private static NodeStateEx checkin(NodeStateEx parent, QName name, NodeImpl src, int mode) throws RepositoryException {
        NodeStateEx node = parent.addNode(name, QName.NT_FROZENNODE, null, true);
        node.setPropertyValue(QName.JCR_FROZENUUID, InternalValue.create(src.internalGetUUID().toString()));
        node.setPropertyValue(QName.JCR_FROZENPRIMARYTYPE, InternalValue.create(((NodeTypeImpl)src.getPrimaryNodeType()).getQName()));
        if (src.hasProperty(QName.JCR_MIXINTYPES)) {
            NodeType[] mixins = src.getMixinNodeTypes();
            InternalValue[] ivalues = new InternalValue[mixins.length];
            for (int i = 0; i < mixins.length; ++i) {
                ivalues[i] = InternalValue.create(((NodeTypeImpl)mixins[i]).getQName());
            }
            node.setPropertyValues(QName.JCR_FROZENMIXINTYPES, 7, ivalues);
        }
        PropertyIterator piter = src.getProperties();
        while (piter.hasNext()) {
            PropertyImpl prop = (PropertyImpl)piter.nextProperty();
            int opv = (mode & 1) > 0 ? 1 : prop.getDefinition().getOnParentVersion();
            switch (opv) {
                case 6: {
                    parent.reload();
                    throw new VersionException("Checkin aborted due to OPV in " + prop.safeGetJCRPath());
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
                case 1: 
                case 2: {
                    if (prop.getQName().equals((Object)QName.JCR_PRIMARYTYPE) || prop.getQName().equals((Object)QName.JCR_MIXINTYPES) || prop.getQName().equals((Object)QName.JCR_UUID)) break;
                    node.copyFrom(prop);
                }
            }
        }
        NodeIterator niter = src.getNodes();
        while (niter.hasNext()) {
            NodeImpl child = (NodeImpl)niter.nextNode();
            int opv = (mode & 3) > 0 ? 1 : child.getDefinition().getOnParentVersion();
            switch (opv) {
                case 6: {
                    throw new VersionException("Checkin aborted due to OPV in " + child.safeGetJCRPath());
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
                case 2: {
                    if (child.isNodeType(QName.MIX_VERSIONABLE)) {
                        NodeStateEx newChild = node.addNode(child.getQName(), QName.NT_VERSIONEDCHILD, null, false);
                        newChild.setPropertyValue(QName.JCR_CHILDVERSIONHISTORY, InternalValue.create(new UUID(child.getVersionHistory().getUUID())));
                        break;
                    }
                    InternalFrozenNodeImpl.checkin(node, child.getQName(), child, 1);
                    break;
                }
                case 1: {
                    InternalFrozenNodeImpl.checkin(node, child.getQName(), child, 3);
                }
            }
        }
        return node;
    }
}

